/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.tasks;

import org.gradle.api.Project;
import org.gradle.api.tasks.JavaExec;
import org.gradle.util.GradleVersion;
import org.javamodularity.moduleplugin.tasks.AbstractModulePluginTask;
import org.javamodularity.moduleplugin.tasks.ModularJavaExec;
import org.javamodularity.moduleplugin.tasks.RunTaskMutator;
import org.javamodularity.moduleplugin.tasks.StartScriptsMutator;

public class RunTask
extends AbstractModulePluginTask {
    public RunTask(Project project) {
        super(project);
    }

    public void configureRun() {
        this.project.getPluginManager().withPlugin("application", plugin -> this.doConfigureRun());
    }

    private void doConfigureRun() {
        if (this.helper().shouldFixEffectiveArguments()) {
            this.project.getTasks().replace("run", ModularJavaExec.class);
        }
        JavaExec runTask = this.getRunTask();
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.4")) >= 0) {
            runTask.getModularity().getInferModulePath().set((Object)true);
        }
        RunTaskMutator mutator = new RunTaskMutator(runTask, this.project);
        mutator.configureRun();
        this.project.afterEvaluate(p -> this.configureStartScripts());
    }

    private void configureStartScripts() {
        StartScriptsMutator mutator = new StartScriptsMutator(this.getRunTask(), this.project);
        mutator.updateStartScriptsTask("startScripts");
        mutator.movePatchedLibs();
    }

    private JavaExec getRunTask() {
        return this.helper().task("run", JavaExec.class);
    }
}

