/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.skins.AdvancedTableColumnHeader;
import com.dlsc.gemsfx.skins.AdvancedTableViewSkin;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.control.Skin;
import javafx.scene.control.TableView;
import javafx.scene.control.skin.NestedTableColumnHeader;
import javafx.scene.control.skin.TableColumnHeader;

public class AdvancedTableView<T>
extends TableView<T> {
    private boolean autoResizeAllColumns;
    private int autoResizeRows;

    public AdvancedTableView() {
        this.init();
    }

    public AdvancedTableView(ObservableList<T> items) {
        super(items);
        this.init();
    }

    protected Skin<?> createDefaultSkin() {
        return new AdvancedTableViewSkin(this);
    }

    private void init() {
        this.skinProperty().addListener(it -> {
            if (this.getSkin() != null && this.autoResizeAllColumns) {
                this.autoResizeAllColumns(this.autoResizeRows);
            }
        });
    }

    public void autoResizeAllColumns() {
        this.autoResizeAllColumns(100);
    }

    public void autoResizeAllColumns(int rows) {
        if (rows <= 0) {
            return;
        }
        AdvancedTableViewSkin skin = (AdvancedTableViewSkin)this.getSkin();
        if (skin != null) {
            this.autoResizeAllColumns = false;
            Platform.runLater(() -> {
                NestedTableColumnHeader rootHeader = skin.getTableHeaderRow().getRootHeader();
                this.resize((TableColumnHeader)rootHeader, this.autoResizeRows);
            });
        } else {
            this.autoResizeAllColumns = true;
            this.autoResizeRows = rows;
        }
    }

    private void resize(TableColumnHeader header, int rows) {
        if (header instanceof NestedTableColumnHeader) {
            NestedTableColumnHeader nestedTableColumnHeader = (NestedTableColumnHeader)header;
            nestedTableColumnHeader.getColumnHeaders().forEach(col -> this.resize((TableColumnHeader)col, rows));
        } else if (header instanceof AdvancedTableColumnHeader) {
            AdvancedTableColumnHeader advancedTableColumnHeader = (AdvancedTableColumnHeader)header;
            advancedTableColumnHeader.resizeColumnToFitContent(rows);
        }
    }
}

