/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.shape.ArcType;
import javafx.util.StringConverter;

public class ArcProgressIndicator
extends ProgressIndicator {
    private static final String DEFAULT_STYLE_CLASS = "arc-progress-indicator";
    private static final ArcType DEFAULT_PROGRESS_ARC_TYPE = ArcType.OPEN;
    private static final ArcType DEFAULT_TRACK_ARC_TYPE = ArcType.CHORD;
    private static final StringConverter<Double> DEFAULT_CONVERTER = new StringConverter<Double>(){

        public String toString(Double progress) {
            if (progress == null || progress < 0.0) {
                return "";
            }
            if (progress == 1.0) {
                return "Completed";
            }
            return String.format("%.0f%%", progress * 100.0);
        }

        public Double fromString(String string) {
            return null;
        }
    };
    private final ObjectProperty<StringConverter<Double>> converter = new SimpleObjectProperty((Object)this, "converter", DEFAULT_CONVERTER);
    private final ObjectProperty<Node> graphic = new SimpleObjectProperty((Object)this, "graphic");
    private ObjectProperty<ArcType> progressArcType;
    private ObjectProperty<ArcType> trackArcType;

    public ArcProgressIndicator() {
        this(-1.0);
    }

    public ArcProgressIndicator(double progress) {
        super(progress);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(ArcProgressIndicator.class.getResource("arc-progress-indicator.css")).toExternalForm();
    }

    public final StringConverter<Double> getConverter() {
        return (StringConverter)this.converter.get();
    }

    public final ObjectProperty<StringConverter<Double>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<Double> converter) {
        this.converterProperty().set(converter);
    }

    public final ObjectProperty<Node> graphicProperty() {
        return this.graphic;
    }

    public final Node getGraphic() {
        return (Node)this.graphic.get();
    }

    public final void setGraphic(Node graphic) {
        this.graphicProperty().set((Object)graphic);
    }

    public final ObjectProperty<ArcType> progressArcTypeProperty() {
        if (this.progressArcType == null) {
            this.progressArcType = new StyleableObjectProperty<ArcType>(DEFAULT_PROGRESS_ARC_TYPE){

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "progressArcType";
                }

                public CssMetaData<? extends Styleable, ArcType> getCssMetaData() {
                    return StyleableProperties.PROGRESS_ARC_TYPE;
                }
            };
        }
        return this.progressArcType;
    }

    public final ArcType getProgressArcType() {
        return this.progressArcType == null ? DEFAULT_PROGRESS_ARC_TYPE : (ArcType)this.progressArcType.get();
    }

    public final void setProgressArcType(ArcType progressArcType) {
        this.progressArcTypeProperty().set((Object)progressArcType);
    }

    public final ObjectProperty<ArcType> trackArcTypeProperty() {
        if (this.trackArcType == null) {
            this.trackArcType = new StyleableObjectProperty<ArcType>(DEFAULT_TRACK_ARC_TYPE){

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "trackArcType";
                }

                public CssMetaData<? extends Styleable, ArcType> getCssMetaData() {
                    return StyleableProperties.TRACK_ARC_TYPE;
                }
            };
        }
        return this.trackArcType;
    }

    public final ArcType getTrackArcType() {
        return this.trackArcType == null ? DEFAULT_TRACK_ARC_TYPE : (ArcType)this.trackArcType.get();
    }

    public final void setTrackArcType(ArcType trackArcType) {
        this.trackArcTypeProperty().set((Object)trackArcType);
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return ArcProgressIndicator.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<ArcProgressIndicator, ArcType> PROGRESS_ARC_TYPE = new CssMetaData<ArcProgressIndicator, ArcType>("-fx-progress-arc-type", (StyleConverter)new EnumConverter(ArcType.class), DEFAULT_PROGRESS_ARC_TYPE){

            public StyleableProperty<ArcType> getStyleableProperty(ArcProgressIndicator control) {
                return (StyleableProperty)control.progressArcTypeProperty();
            }

            public boolean isSettable(ArcProgressIndicator control) {
                return control.progressArcType == null || !control.progressArcType.isBound();
            }
        };
        private static final CssMetaData<ArcProgressIndicator, ArcType> TRACK_ARC_TYPE = new CssMetaData<ArcProgressIndicator, ArcType>("-fx-track-arc-type", (StyleConverter)new EnumConverter(ArcType.class), DEFAULT_TRACK_ARC_TYPE){

            public StyleableProperty<ArcType> getStyleableProperty(ArcProgressIndicator control) {
                return (StyleableProperty)control.trackArcTypeProperty();
            }

            public boolean isSettable(ArcProgressIndicator control) {
                return control.trackArcType == null || !control.trackArcType.isBound();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(ProgressIndicator.getClassCssMetaData());
            Collections.addAll(styleables, PROGRESS_ARC_TYPE, TRACK_ARC_TYPE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

