/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class GlassPane
extends StackPane {
    private final FadeTransition fadeTransition = new FadeTransition();
    private final DoubleProperty blockingOpacity = new SimpleDoubleProperty((Object)this, "blockingOpacity", 0.5);
    private final ObjectProperty<Duration> fadeInOutDuration = new SimpleObjectProperty((Object)this, "fadeInOutDuration", (Object)Duration.millis((double)100.0));
    private final BooleanProperty fadeInOut = new SimpleBooleanProperty((Object)this, "fadeInOut");
    private final BooleanProperty hide = new SimpleBooleanProperty((Object)this, "hide", true);

    public GlassPane() {
        this.getStyleClass().add((Object)"glass-pane");
        this.blockingOpacity.addListener((obs, oldValue, newValue) -> {
            if (newValue.doubleValue() < 0.0 || newValue.doubleValue() > 1.0) {
                this.setBlockingOpacity(oldValue.doubleValue());
            }
        });
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLACK, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.setMouseTransparent(false);
        this.setVisible(false);
        this.fadeTransition.durationProperty().bind(this.fadeInOutDuration);
        this.fadeTransition.setNode((Node)this);
        this.hideProperty().addListener((it, oldHide, newHide) -> {
            if (this.fadeTransition.getStatus().equals((Object)Animation.Status.RUNNING)) {
                this.fadeTransition.stop();
            }
            if (this.isFadeInOut()) {
                this.setVisible(true);
                this.fadeTransition.setFromValue(this.isHide() ? this.getBlockingOpacity() : 0.0);
                this.fadeTransition.setToValue(this.isHide() ? 0.0 : this.getBlockingOpacity());
                this.fadeTransition.setOnFinished(evt -> {
                    if (newHide.booleanValue()) {
                        this.setVisible(false);
                    }
                });
                this.fadeTransition.play();
            } else {
                this.setOpacity(newHide != false ? 0.0 : this.getBlockingOpacity());
                this.setVisible(newHide == false);
            }
        });
    }

    public final double getBlockingOpacity() {
        return this.blockingOpacity.get();
    }

    public final DoubleProperty blockingOpacityProperty() {
        return this.blockingOpacity;
    }

    public final void setBlockingOpacity(double blockingOpacity) {
        this.blockingOpacity.set(blockingOpacity);
    }

    public final Duration getFadeInOutDuration() {
        return (Duration)this.fadeInOutDuration.get();
    }

    public final ObjectProperty<Duration> fadeInOutDurationProperty() {
        return this.fadeInOutDuration;
    }

    public final void setFadeInOutDuration(Duration fadeInOutDuration) {
        this.fadeInOutDuration.set((Object)fadeInOutDuration);
    }

    public final boolean isFadeInOut() {
        return this.fadeInOut.get();
    }

    public final BooleanProperty fadeInOutProperty() {
        return this.fadeInOut;
    }

    public final BooleanProperty hideProperty() {
        return this.hide;
    }

    public final boolean isHide() {
        return this.hide.get();
    }
}

