/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.CalendarPicker;
import com.dlsc.gemsfx.CalendarView;
import com.dlsc.gemsfx.CustomComboBox;
import com.dlsc.gemsfx.skins.ToggleVisibilityComboBoxSkin;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class CalendarPickerSkin
extends ToggleVisibilityComboBoxSkin<CalendarPicker> {
    private CalendarView view;
    private final HBox box;
    private final TextField editor;
    private final StackPane arrowButton;
    private final ChangeListener<LocalDate> localDateChangeListener = (obs, oldValue, newValue) -> {
        if (!Objects.equals(oldValue, newValue)) {
            ((CalendarPicker)this.getSkinnable()).hide();
        }
    };
    private final WeakChangeListener<LocalDate> weakLocalDateChangeListener = new WeakChangeListener(this.localDateChangeListener);

    public CalendarPickerSkin(CalendarPicker picker) {
        super(picker);
        picker.valueProperty().addListener(it -> {
            if (this.view != null) {
                this.view.setYearMonth(YearMonth.from((TemporalAccessor)picker.getValue()));
            }
        });
        Region arrow = new Region();
        arrow.getStyleClass().add((Object)"arrow");
        this.arrowButton = new StackPane(new Node[]{arrow});
        this.arrowButton.setFocusTraversable(false);
        this.arrowButton.getStyleClass().add((Object)"arrow-button");
        this.arrowButton.addEventHandler(MouseEvent.MOUSE_RELEASED, this::mouseReleased);
        this.arrowButton.addEventHandler(MouseEvent.MOUSE_ENTERED, this::mouseEntered);
        this.arrowButton.addEventHandler(MouseEvent.MOUSE_EXITED, this::mouseExited);
        this.editor = picker.getEditor();
        HBox.setHgrow((Node)this.editor, (Priority)Priority.ALWAYS);
        this.box = new HBox();
        this.box.setFillHeight(true);
        this.box.getStyleClass().add((Object)"box");
        this.updateBox();
        this.getChildren().add((Object)this.box);
        this.registerChangeListener((ObservableValue)picker.buttonDisplayProperty(), o -> this.updateBox());
    }

    private void updateBox() {
        CustomComboBox.ButtonDisplay buttonDisplay = ((CalendarPicker)this.getSkinnable()).getButtonDisplay();
        switch (buttonDisplay) {
            case LEFT: {
                this.box.getChildren().setAll((Object[])new Node[]{this.arrowButton, this.editor});
                HBox.setHgrow((Node)this.arrowButton, (Priority)Priority.NEVER);
                break;
            }
            case RIGHT: {
                this.box.getChildren().setAll((Object[])new Node[]{this.editor, this.arrowButton});
                HBox.setHgrow((Node)this.arrowButton, (Priority)Priority.NEVER);
                break;
            }
            case BUTTON_ONLY: {
                this.box.getChildren().setAll((Object[])new Node[]{this.arrowButton});
                HBox.setHgrow((Node)this.arrowButton, (Priority)Priority.ALWAYS);
                break;
            }
            case FIELD_ONLY: {
                this.box.getChildren().setAll((Object[])new Node[]{this.editor});
                HBox.setHgrow((Node)this.arrowButton, (Priority)Priority.NEVER);
            }
        }
    }

    @Override
    protected Node getPopupContent() {
        if (this.view == null) {
            CalendarPicker picker = (CalendarPicker)this.getSkinnable();
            this.view = picker.getCalendarView();
            LocalDate pickerValue = (LocalDate)picker.getValue();
            if (pickerValue != null) {
                this.view.setYearMonth(YearMonth.from(pickerValue));
                this.view.getSelectionModel().select(pickerValue);
            }
            this.view.setFocusTraversable(false);
            this.view.selectionModelProperty().addListener((obs, oldModel, newModel) -> this.bindSelectionModel((CalendarView.SelectionModel)oldModel, (CalendarView.SelectionModel)newModel));
            this.bindSelectionModel(null, this.view.getSelectionModel());
        }
        return this.view;
    }

    private void bindSelectionModel(CalendarView.SelectionModel oldModel, CalendarView.SelectionModel newModel) {
        if (oldModel != null) {
            oldModel.selectedDateProperty().unbindBidirectional((Property)((CalendarPicker)this.getSkinnable()).valueProperty());
            oldModel.selectedDateProperty().removeListener(this.weakLocalDateChangeListener);
        }
        if (newModel != null) {
            newModel.setSelectionMode(CalendarView.SelectionModel.SelectionMode.SINGLE_DATE);
            newModel.selectedDateProperty().bindBidirectional((Property)((CalendarPicker)this.getSkinnable()).valueProperty());
            newModel.selectedDateProperty().addListener(this.weakLocalDateChangeListener);
        }
    }
}

