/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.EnhancedPasswordField;
import com.dlsc.unitfx.skins.CustomTextFieldSkin;
import java.util.Optional;
import java.util.Set;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.text.Text;

public abstract class EnhancedPasswordFieldSkin
extends CustomTextFieldSkin {
    public EnhancedPasswordFieldSkin(final EnhancedPasswordField control) {
        super((TextField)control);
        Set nodes = control.lookupAll(".text");
        Optional<Node> first = nodes.stream().filter(node -> node instanceof Text && node.layoutXProperty().isBound()).findFirst();
        first.ifPresent(node -> {
            Text text = (Text)node;
            text.textProperty().unbind();
            text.textProperty().bind((ObservableValue)new StringBinding(){
                {
                    this.bind(new Observable[]{control.textProperty(), control.showPasswordProperty(), control.echoCharProperty()});
                }

                protected String computeValue() {
                    return EnhancedPasswordFieldSkin.this.maskText(control.textProperty().getValueSafe());
                }
            });
        });
    }

    protected String maskText(String txt) {
        TextField skinnable = (TextField)this.getSkinnable();
        int len = txt.length();
        if (skinnable == null) {
            return this.getDefaultMaskText(len);
        }
        if (skinnable instanceof EnhancedPasswordField) {
            EnhancedPasswordField passwordField = (EnhancedPasswordField)skinnable;
            if (passwordField.isShowPassword()) {
                return txt;
            }
            return String.valueOf(passwordField.getEchoCharSafe()).repeat(len);
        }
        return this.getDefaultMaskText(len);
    }

    private String getDefaultMaskText(int len) {
        return String.valueOf('\u25cf').repeat(len);
    }
}

