/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.ResizableTextArea;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.skin.TextAreaSkin;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class ResizableTextAreaSkin
extends TextAreaSkin {
    private static final PseudoClass RESIZE_HORIZONTAL_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"h-resize");
    private static final PseudoClass RESIZE_VERTICAL_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"v-resize");
    private static final PseudoClass RESIZE_BOTH_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"both-resize");
    private static final PseudoClass RESIZE_NONE_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"no-resize");
    protected final StackPane resizeCorner;
    protected final ScrollPane scrollPane = (ScrollPane)this.getChildren().get(0);
    protected final StackPane contentPane;
    private double startX;
    private double startY;
    private double startW;
    private double startH;
    protected ScrollBar verticalScrollBar;
    protected ScrollBar horizontalScrollBar;

    public ResizableTextAreaSkin(ResizableTextArea control) {
        super((TextArea)control);
        Region resizeIcon = new Region();
        resizeIcon.getStyleClass().add((Object)"resize-icon");
        this.resizeCorner = new StackPane(new Node[]{resizeIcon});
        this.resizeCorner.getStyleClass().add((Object)"resize-corner");
        this.resizeCorner.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.contentPane = new StackPane(new Node[]{this.scrollPane, this.resizeCorner});
        this.contentPane.getStyleClass().add((Object)"content-pane");
        StackPane.setAlignment((Node)this.resizeCorner, (Pos)Pos.BOTTOM_RIGHT);
        this.getChildren().setAll((Object[])new Node[]{this.contentPane});
        this.registerChangeListener((ObservableValue)control.resizeHorizontalProperty(), it -> this.updateResizePseudoClasses());
        this.registerChangeListener((ObservableValue)control.resizeVerticalProperty(), it -> this.updateResizePseudoClasses());
        this.updateResizePseudoClasses();
        this.addResizeEventHandler();
    }

    private void updateResizePseudoClasses() {
        ResizableTextArea control = (ResizableTextArea)this.getSkinnable();
        boolean horResize = control.isResizeHorizontal();
        boolean verResize = control.isResizeVertical();
        boolean bothResize = horResize && verResize;
        boolean noneResize = !horResize && !verResize;
        this.resizeCorner.pseudoClassStateChanged(RESIZE_HORIZONTAL_PSEUDO_CLASS, horResize && !bothResize);
        this.resizeCorner.pseudoClassStateChanged(RESIZE_VERTICAL_PSEUDO_CLASS, verResize && !bothResize);
        this.resizeCorner.pseudoClassStateChanged(RESIZE_BOTH_PSEUDO_CLASS, bothResize);
        this.resizeCorner.pseudoClassStateChanged(RESIZE_NONE_PSEUDO_CLASS, noneResize);
    }

    private void addResizeEventHandler() {
        ResizableTextArea control = (ResizableTextArea)this.getSkinnable();
        this.resizeCorner.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            control.requestFocus();
            this.startX = event.getScreenX();
            this.startY = event.getScreenY();
            this.startW = control.getWidth();
            this.startH = control.getHeight();
            event.consume();
        });
        this.resizeCorner.addEventHandler(MouseEvent.MOUSE_DRAGGED, event -> {
            double w = this.startW + event.getScreenX() - this.startX;
            double h = this.startH + event.getScreenY() - this.startY;
            if (control.getMaxWidth() > 0.0) {
                w = Math.min(control.getMaxWidth(), w);
            }
            if (control.getMaxHeight() > 0.0) {
                h = Math.min(control.getMaxHeight(), h);
            }
            if (control.isResizeHorizontal()) {
                control.setPrefWidth(w);
            }
            if (control.isResizeVertical()) {
                control.setPrefHeight(h);
            }
            event.consume();
        });
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        super.layoutChildren(contentX, contentY, contentWidth, contentHeight);
        if (this.verticalScrollBar == null || this.horizontalScrollBar == null) {
            this.findScrollBar();
            this.bindResizeCornerPosition();
        }
        this.layoutInArea((Node)this.contentPane, contentX, contentY, contentWidth, contentHeight, 0.0, HPos.LEFT, VPos.TOP);
    }

    private void findScrollBar() {
        this.scrollPane.getChildrenUnmodifiable().forEach(node -> {
            if (node instanceof ScrollBar) {
                ScrollBar scrollBar = (ScrollBar)node;
                if (scrollBar.getOrientation() == Orientation.VERTICAL) {
                    this.verticalScrollBar = scrollBar;
                } else {
                    this.horizontalScrollBar = scrollBar;
                }
            }
        });
    }

    private void bindResizeCornerPosition() {
        if (this.verticalScrollBar != null && this.horizontalScrollBar != null) {
            this.resizeCorner.translateXProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.verticalScrollBar.visibleProperty()).then((ObservableNumberValue)this.verticalScrollBar.widthProperty()).otherwise(0.0).negate());
            this.resizeCorner.translateYProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.horizontalScrollBar.visibleProperty()).then((ObservableNumberValue)this.horizontalScrollBar.heightProperty()).otherwise(0.0).negate());
        }
    }
}

