/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.secret;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.annotations.Position;

public final class Secret
extends Struct
implements AutoCloseable {
    @Position(value=0)
    private final ObjectPath session;
    @Position(value=1)
    private final byte[] parameters;
    @Position(value=2)
    private final byte[] value;
    @Position(value=3)
    private final String contentType;
    private String mimeType = null;
    private Charset charset = null;
    public static final String TEXT_PLAIN_CHARSET_UTF_8 = "text/plain; charset=utf-8";
    public static final String TEXT_PLAIN = "text/plain";
    private static final String CHARSET = "charset=";

    public Secret(ObjectPath session, byte[] value) {
        this.session = session;
        this.parameters = "".getBytes();
        this.value = value;
        this.contentType = TEXT_PLAIN_CHARSET_UTF_8;
        this.mimeType = TEXT_PLAIN;
        this.charset = StandardCharsets.UTF_8;
    }

    public Secret(ObjectPath session, byte[] parameters, byte[] value) {
        this.session = session;
        this.parameters = parameters == null ? "".getBytes() : parameters;
        this.value = value;
        this.contentType = TEXT_PLAIN_CHARSET_UTF_8;
        this.mimeType = TEXT_PLAIN;
        this.charset = StandardCharsets.UTF_8;
    }

    public Secret(ObjectPath session, byte[] parameters, byte[] value, String contentType) {
        this.session = Objects.requireNonNull(session);
        this.parameters = parameters == null ? "".getBytes() : parameters;
        this.value = Objects.requireNonNull(value);
        if (contentType == null || contentType.isEmpty()) {
            this.contentType = TEXT_PLAIN_CHARSET_UTF_8;
            this.mimeType = TEXT_PLAIN;
            this.charset = StandardCharsets.UTF_8;
        } else {
            this.parseContentType(contentType);
            this.contentType = this.charset == null ? this.mimeType : Secret.createContentType(this.mimeType, this.charset);
        }
    }

    public Secret(ObjectPath session, byte[] parameters, byte[] value, Charset charset) {
        this.session = Objects.requireNonNull(session);
        this.parameters = parameters == null ? "".getBytes() : parameters;
        this.value = Objects.requireNonNull(value);
        this.contentType = Secret.createContentType(charset);
        this.parseContentType(this.contentType);
    }

    private void parseContentType(String contentType) {
        String pattern = "[\\s\\\"\\;\\,]";
        List<String> split = Arrays.asList(contentType.split(pattern));
        List filtered = split.stream().filter(s -> !s.isEmpty() && s.length() != 1).collect(Collectors.toList());
        this.mimeType = filtered.size() > 0 ? (String)filtered.get(0) : TEXT_PLAIN;
        this.charset = filtered.size() == 2 && ((String)filtered.get(1)).startsWith(CHARSET) ? Charset.forName(((String)filtered.get(1)).substring(CHARSET.length()).toUpperCase()) : null;
    }

    public static String createContentType(String mimeType, Charset charset) {
        return mimeType + "; " + CHARSET + charset.name().toLowerCase();
    }

    public static String createContentType(Charset charset) {
        return "text/plain; charset=" + charset.name().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(CharSequence passphrase) {
        ByteBuffer encoded = StandardCharsets.UTF_8.encode(CharBuffer.wrap(passphrase));
        byte[] bytes = new byte[encoded.remaining()];
        encoded.get(bytes);
        try {
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            Secret.clear(encoded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(char[] passphrase) {
        ByteBuffer encoded = StandardCharsets.UTF_8.encode(CharBuffer.wrap(passphrase));
        byte[] bytes = new byte[encoded.remaining()];
        encoded.get(bytes);
        try {
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            Secret.clear(encoded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] toChars(byte[] bytes) {
        ByteBuffer encoded = ByteBuffer.wrap(bytes);
        CharBuffer decoded = StandardCharsets.UTF_8.decode(encoded);
        char[] chars = new char[decoded.remaining()];
        decoded.get(chars);
        try {
            char[] cArray = chars;
            return cArray;
        }
        finally {
            Secret.clear(encoded);
            Secret.clear(decoded);
        }
    }

    public static void clear(byte[] bytes) {
        Arrays.fill(bytes, (byte)0);
        for (byte b : bytes) {
            assert (0 == b);
        }
    }

    public static void clear(ByteBuffer buffer) {
        byte[] zeros = new byte[buffer.limit()];
        Arrays.fill(zeros, (byte)0);
        buffer.rewind();
        buffer.put(zeros);
        for (byte b : buffer.array()) {
            assert (0 == b);
        }
    }

    public static void clear(CharBuffer buffer) {
        char[] zeros = new char[buffer.limit()];
        Arrays.fill(zeros, '\u0000');
        buffer.rewind();
        buffer.put(zeros);
        for (char c : buffer.array()) {
            assert ('\u0000' == c);
        }
    }

    public void clear() {
        Secret.clear(this.value);
    }

    @Override
    public void close() {
        this.clear();
    }

    public ObjectPath getSession() {
        return this.session;
    }

    public byte[] getSecretValue() {
        return this.value;
    }

    public byte[] getSecretParameters() {
        return this.parameters;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Charset getCharset() {
        return this.charset;
    }
}

