/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.writers.raw;

import java.io.IOException;
import java.net.Socket;
import java.util.Map;
import org.tinylog.core.LogEntry;
import org.tinylog.writers.raw.AbstractSocketWriter;

public class TcpSocketWriter
extends AbstractSocketWriter {
    private Socket socket = new Socket(this.getInetAddress(), this.getPort());

    public TcpSocketWriter(Map<String, String> properties) throws IOException {
        super(properties);
    }

    @Override
    public void write(LogEntry logEntry) throws IOException {
        byte[] message = this.formatMessage(logEntry);
        this.socket.getOutputStream().write(message);
    }

    @Override
    public void flush() throws Exception {
        this.socket.getOutputStream().flush();
    }

    @Override
    public void close() throws Exception {
        this.socket.close();
    }
}

