/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.Illuminant;
import com.github.ajalt.colormath.WhitePoint;
import com.github.ajalt.colormath.internal.ColorSpaceUtilsKt;
import com.github.ajalt.colormath.internal.Matrix;
import com.github.ajalt.colormath.internal.MatrixKt;
import com.github.ajalt.colormath.model.BT2020TransferFunctions;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.RGBColorSpace;
import com.github.ajalt.colormath.model.RGBColorSpacesKt;
import com.github.ajalt.colormath.model.xyY;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\tH\u0016J)\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020!H\u0096\u0002J\b\u0010%\u001a\u00020\u000fH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"Lcom/github/ajalt/colormath/model/BT2020Space;", "Lcom/github/ajalt/colormath/model/RGBColorSpace;", "()V", "components", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "matrixFromXyz", "", "getMatrixFromXyz", "()[F", "matrixToXyz", "getMatrixToXyz", "name", "", "getName", "()Ljava/lang/String;", "transferFunctions", "Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;", "getTransferFunctions", "()Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;", "whitePoint", "Lcom/github/ajalt/colormath/WhitePoint;", "getWhitePoint", "()Lcom/github/ajalt/colormath/WhitePoint;", "convert", "Lcom/github/ajalt/colormath/model/RGB;", "color", "Lcom/github/ajalt/colormath/Color;", "create", "invoke", "r", "", "g", "b", "alpha", "toString", "colormath"})
@SourceDebugExtension(value={"SMAP\nRGBColorSpaces.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RGBColorSpaces.kt\ncom/github/ajalt/colormath/model/BT2020Space\n+ 2 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,413:1\n23#2:414\n12#2,13:415\n1#3:428\n*S KotlinDebug\n*F\n+ 1 RGBColorSpaces.kt\ncom/github/ajalt/colormath/model/BT2020Space\n*L\n238#1:414\n238#1:415,13\n238#1:428\n*E\n"})
final class BT2020Space
implements RGBColorSpace {
    @NotNull
    public static final BT2020Space INSTANCE = new BT2020Space();
    @NotNull
    private static final String name = "BT.2020";
    @NotNull
    private static final List<ColorComponentInfo> components = ColorSpaceUtilsKt.rectangularComponentInfo("RGB");
    @NotNull
    private static final WhitePoint whitePoint = Illuminant.INSTANCE.getD65();
    @NotNull
    private static final RGBColorSpace.TransferFunctions transferFunctions = BT2020TransferFunctions.INSTANCE;
    @NotNull
    private static final float[] matrixToXyz = RGBColorSpacesKt.access$rgbToXyzMatrix(INSTANCE.getWhitePoint(), new xyY(0.708, 0.292, null, 4, null), new xyY(0.17, 0.797, null, 4, null), new xyY(0.131, 0.046, null, 4, null));
    @NotNull
    private static final float[] matrixFromXyz = MatrixKt.inverse-M2Qqt3Q$default(Matrix.constructor-impl(INSTANCE.getMatrixToXyz()), false, 1, null);

    private BT2020Space() {
    }

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    @NotNull
    public List<ColorComponentInfo> getComponents() {
        return components;
    }

    @Override
    @NotNull
    public WhitePoint getWhitePoint() {
        return whitePoint;
    }

    @Override
    @NotNull
    public RGBColorSpace.TransferFunctions getTransferFunctions() {
        return transferFunctions;
    }

    @Override
    @NotNull
    public RGB invoke(float r, float g, float b, float alpha) {
        return new RGB(r, g, b, alpha, this);
    }

    @Override
    @NotNull
    public RGB convert(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "color");
        Color color2 = color;
        return color2 instanceof RGB ? ((RGB)color).convertTo(this) : (color2 instanceof ICtCp ? ((ICtCp)color).toBT2020() : color.toXYZ().toRGB(this));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public RGB create(@NotNull float[] components) {
        void p3;
        void p2;
        void p1;
        float f;
        Intrinsics.checkNotNullParameter(components, "components");
        ColorSpace $this$doCreate$iv = this;
        boolean $i$f$doCreate = false;
        ColorSpace $this$withValidComps$iv$iv = $this$doCreate$iv;
        boolean $i$f$withValidComps = false;
        int size$iv$iv = $this$withValidComps$iv$iv.getComponents().size();
        int n = size$iv$iv - 1;
        int n2 = components.length;
        if (!(n <= n2 ? n2 <= size$iv$iv : false)) {
            boolean bl = false;
            String string = "Invalid component array length: " + components.length + ", expected " + (size$iv$iv - 1) + " or " + size$iv$iv;
            throw new IllegalArgumentException(string.toString());
        }
        float[] it$iv = components;
        boolean bl = false;
        float f2 = components[0];
        float f3 = components[1];
        float f4 = components[2];
        int n3 = 3;
        float[] fArray = components;
        if (n3 <= ArraysKt.getLastIndex(fArray)) {
            f = fArray[n3];
        } else {
            int n4 = n3;
            float f5 = f4;
            float f6 = f3;
            float f7 = f2;
            boolean bl2 = false;
            float f8 = 1.0f;
            f2 = f7;
            f3 = f6;
            f4 = f5;
            f = f8;
        }
        float f9 = f;
        float f10 = f4;
        float f11 = f3;
        float p0 = f2;
        boolean bl3 = false;
        return (RGB)((Color)this.invoke(p0, (float)p1, (float)p2, (float)p3));
    }

    @Override
    @NotNull
    public float[] getMatrixToXyz() {
        return matrixToXyz;
    }

    @Override
    @NotNull
    public float[] getMatrixFromXyz() {
        return matrixFromXyz;
    }

    @NotNull
    public String toString() {
        return this.getName();
    }

    @Override
    @NotNull
    public RGB invoke(@NotNull Number r, @NotNull Number g, @NotNull Number b, @NotNull Number alpha) {
        return RGBColorSpace.DefaultImpls.invoke(this, r, g, b, alpha);
    }

    @Override
    @NotNull
    public RGB invoke(@NotNull String hex) {
        return RGBColorSpace.DefaultImpls.invoke(this, hex);
    }

    @Override
    @NotNull
    public RGB from255(int r, int g, int b, int alpha) {
        return RGBColorSpace.DefaultImpls.from255(this, r, g, b, alpha);
    }

    @Override
    @NotNull
    public RGB grey(@NotNull Number amount, @NotNull Number alpha) {
        return RGBColorSpace.DefaultImpls.grey(this, amount, alpha);
    }
}

