/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.util.ArrayList;
import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.cmd.InsertVariousPointsCmd;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.function.SingleNumericParameterFunction;

public class InterpolateFunction
extends SingleNumericParameterFunction {
    public InterpolateFunction(App app) {
        super(app, 1, 1000);
    }

    @Override
    public String getNameKey() {
        return "function.interpolate";
    }

    @Override
    public String getDescriptionKey() {
        return "dialog.interpolate.parameter.text";
    }

    @Override
    public int getCurrentParamValue() {
        return 0;
    }

    @Override
    public void completeFunction(int n) {
        int n2;
        int n3 = this._app.getTrackInfo().getSelection().getStart();
        int n4 = this._app.getTrackInfo().getSelection().getEnd();
        if (n3 < 0 || n4 < 0 || n4 <= n3 || n <= 0) {
            return;
        }
        boolean bl = false;
        if (!this._app.getTrackInfo().getTrack().isTrackPointWithin(n3, n4)) {
            n2 = JOptionPane.showConfirmDialog(this._parentFrame, I18nManager.getText("dialog.interpolate.betweenwaypoints"), this.getName(), 0);
            if (n2 == 1) {
                return;
            }
            bl = true;
        }
        n2 = n;
        Track track = this._app.getTrackInfo().getTrack();
        InsertVariousPointsCmd insertVariousPointsCmd = this.makeCommand(track, n3, n4, n2, bl);
        if (this._app.execute(insertVariousPointsCmd)) {
            this._app.getTrackInfo().getSelection().selectRange(n3, n4 + insertVariousPointsCmd.getNumInserted());
        }
    }

    private InsertVariousPointsCmd makeCommand(Track track, int n, int n2, int n3, boolean bl) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<DataPoint> arrayList2 = new ArrayList<DataPoint>();
        int n4 = 0;
        while (n4 <= n) {
            arrayList.add(n4);
            ++n4;
        }
        DataPoint dataPoint = track.getPoint(n);
        int n5 = n + 1;
        while (n5 <= n2) {
            boolean bl2;
            DataPoint dataPoint2 = track.getPoint(n5);
            boolean bl3 = bl2 = dataPoint2.isWaypoint() && dataPoint.isWaypoint() && bl || !dataPoint2.isWaypoint() && !dataPoint.isWaypoint() && !dataPoint2.getSegmentStart();
            if (bl2) {
                int n6 = 0;
                while (n6 < n3) {
                    arrayList2.add(dataPoint.interpolate(dataPoint2, n6, n3));
                    arrayList.add(track.getNumPoints() + arrayList2.size() - 1);
                    ++n6;
                }
            }
            arrayList.add(n5);
            if (!dataPoint2.isWaypoint() || bl) {
                dataPoint = dataPoint2;
            }
            ++n5;
        }
        n5 = n2 + 1;
        while (n5 < track.getNumPoints()) {
            arrayList.add(n5);
            ++n5;
        }
        InsertVariousPointsCmd insertVariousPointsCmd = new InsertVariousPointsCmd(arrayList, arrayList2);
        insertVariousPointsCmd.setDescription(this.getName());
        insertVariousPointsCmd.setConfirmText(I18nManager.getTextWithNumber("confirm.pointsadded", arrayList2.size()));
        return insertVariousPointsCmd;
    }
}

