/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.provider;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.print.provider.ComponentPage;
import org.netbeans.modules.print.provider.ComponentPanel;
import org.netbeans.modules.print.util.Percent;
import org.netbeans.spi.print.PrintPage;
import org.netbeans.spi.print.PrintProvider;

public class ComponentProvider
implements PrintProvider {
    private String myName;
    private Date myLastModified;
    private JComponent myComponent;

    public ComponentProvider(List<JComponent> list, String string, Date date) {
        this.myName = string;
        this.myLastModified = date;
        if (list != null) {
            this.myComponent = new ComponentPanel(list);
        }
    }

    protected JComponent getComponent() {
        return this.myComponent;
    }

    @Override
    public PrintPage[][] getPages(int n, int n2, double d) {
        ArrayList<ComponentPage> arrayList = new ArrayList<ComponentPage>();
        JComponent jComponent = this.getComponent();
        if (jComponent == null) {
            return new PrintPage[0][0];
        }
        int n3 = jComponent.getWidth();
        int n4 = jComponent.getHeight();
        double d2 = this.getZoom(d, n, n2, n3, n4);
        n3 = (int)Math.floor((double)n3 * d2);
        n4 = (int)Math.floor((double)n4 * d2);
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n4; i += n2) {
            ++n5;
            n6 = 0;
            for (int j = 0; j < n3; j += n) {
                Rectangle object = new Rectangle((++n6 - 1) * n, (n5 - 1) * n2, n, n2);
                arrayList.add(new ComponentPage(jComponent, object, d2, n5 - 1, n6 - 1));
            }
        }
        PrintPage[][] printPageArray = new PrintPage[n5][n6];
        for (ComponentPage componentPage : arrayList) {
            printPageArray[componentPage.getRow()][componentPage.getColumn()] = componentPage;
        }
        return printPageArray;
    }

    private double getZoom(double d, int n, int n2, int n3, int n4) {
        double d2 = Percent.getZoomFactor(d, -1.0);
        if (0.0 < d2) {
            return d2;
        }
        if (Percent.isZoomPage(d)) {
            d2 = 0.0;
        }
        int n5 = Percent.getZoomWidth(d, -1);
        int n6 = Percent.getZoomHeight(d, -1);
        if (d2 == 0.0) {
            n5 = 1;
            n6 = 1;
        }
        return this.getZoom((double)(n * n5) / (double)n3, (double)(n2 * n6) / (double)n4);
    }

    private double getZoom(double d, double d2) {
        if (d > 0.0 && d2 > 0.0) {
            return Math.min(d, d2);
        }
        if (d < 0.0 && d2 > 0.0) {
            return d2;
        }
        if (d > 0.0 && d2 < 0.0) {
            return d;
        }
        return 1.0;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public Date lastModified() {
        return this.myLastModified;
    }
}

