// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rekognition

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
)

// WaitUntilProjectVersionRunning uses the Amazon Rekognition API operation
// DescribeProjectVersions to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Rekognition) WaitUntilProjectVersionRunning(input *DescribeProjectVersionsInput) error {
	return c.WaitUntilProjectVersionRunningWithContext(aws.BackgroundContext(), input)
}

// WaitUntilProjectVersionRunningWithContext is an extended version of WaitUntilProjectVersionRunning.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) WaitUntilProjectVersionRunningWithContext(ctx aws.Context, input *DescribeProjectVersionsInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilProjectVersionRunning",
		MaxAttempts: 40,
		Delay:       request.ConstantWaiterDelay(30 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathAllWaiterMatch, Argument: "ProjectVersionDescriptions[].Status",
				Expected: "RUNNING",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathAnyWaiterMatch, Argument: "ProjectVersionDescriptions[].Status",
				Expected: "FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeProjectVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeProjectVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilProjectVersionTrainingCompleted uses the Amazon Rekognition API operation
// DescribeProjectVersions to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Rekognition) WaitUntilProjectVersionTrainingCompleted(input *DescribeProjectVersionsInput) error {
	return c.WaitUntilProjectVersionTrainingCompletedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilProjectVersionTrainingCompletedWithContext is an extended version of WaitUntilProjectVersionTrainingCompleted.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) WaitUntilProjectVersionTrainingCompletedWithContext(ctx aws.Context, input *DescribeProjectVersionsInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilProjectVersionTrainingCompleted",
		MaxAttempts: 360,
		Delay:       request.ConstantWaiterDelay(120 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathAllWaiterMatch, Argument: "ProjectVersionDescriptions[].Status",
				Expected: "TRAINING_COMPLETED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathAnyWaiterMatch, Argument: "ProjectVersionDescriptions[].Status",
				Expected: "TRAINING_FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeProjectVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeProjectVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}
