/*
 * Bitbucket API
 *
 * Code against the Bitbucket API to automate simple tasks, embed Bitbucket data into your own site, build mobile or desktop apps, or even add custom UI add-ons into Bitbucket itself using the Connect framework.
 *
 * API version: 2.0
 * Contact: support@bitbucket.org
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package bitbucket

import (
	_context "context"
	_ioutil "io/ioutil"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
)

// Linger please
var (
	_ _context.Context
)

// ReportsApiService ReportsApi service
type ReportsApiService service

type ApiBulkCreateOrUpdateAnnotationsRequest struct {
	ctx        _context.Context
	ApiService *ReportsApiService
	username   string
	repoSlug   string
	commit     string
	reportId   string
	body       *[]ReportAnnotation
}

func (r ApiBulkCreateOrUpdateAnnotationsRequest) Body(body []ReportAnnotation) ApiBulkCreateOrUpdateAnnotationsRequest {
	r.body = &body
	return r
}

func (r ApiBulkCreateOrUpdateAnnotationsRequest) Execute() ([]ReportAnnotation, *_nethttp.Response, error) {
	return r.ApiService.BulkCreateOrUpdateAnnotationsExecute(r)
}

/*
 * BulkCreateOrUpdateAnnotations Method for BulkCreateOrUpdateAnnotations
 * Bulk upload of annotations.
Annotations are individual findings that have been identified as part of a report, for example, a line of code that represents a vulnerability. These annotations can be attached to a specific file and even a specific line in that file, however, that is optional. Annotations are not mandatory and a report can contain up to 1000 annotations.

Add the annotations you want to upload as objects in a JSON array and make sure each annotation has the external_id field set to a unique value. If you want to use an existing id from your own system, we recommend prefixing it with your system's name to avoid collisions, for example, mySystem-annotation001. The external id can later be used to identify the report as an alternative to the generated [UUID](https://developer.atlassian.com/bitbucket/api/2/reference/meta/uri-uuid#uuid). You can upload up to 100 annotations per POST request.

### Sample cURL request:
```
curl --location 'https://api.bitbucket.org/2.0/repositories/<username>/<reposity-name>/commit/<commit-hash>/reports/mysystem-001/annotations' \
--header 'Content-Type: application/json' \
--data-raw '[
  {
        "external_id": "mysystem-annotation001",
        "title": "Security scan report",
        "annotation_type": "VULNERABILITY",
        "summary": "This line represents a security threat.",
        "severity": "HIGH",
      "path": "my-service/src/main/java/com/myCompany/mysystem/logic/Main.java",
        "line": 42
  },
  {
        "external_id": "mySystem-annotation002",
        "title": "Bug report",
        "annotation_type": "BUG",
        "result": "FAILED",
        "summary": "This line might introduce a bug.",
        "severity": "MEDIUM",
      "path": "my-service/src/main/java/com/myCompany/mysystem/logic/Helper.java",
        "line": 13
  }
]'
```

### Possible field values:
annotation_type: VULNERABILITY, CODE_SMELL, BUG
result: PASSED, FAILED, IGNORED, SKIPPED
severity: HIGH, MEDIUM, LOW, CRITICAL

Please refer to the [Code Insights documentation](https://confluence.atlassian.com/bitbucket/code-insights-994316785.html) for more information.

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param username The account.
 * @param repoSlug The repository.
 * @param commit The commit for which to retrieve reports.
 * @param reportId Uuid or external-if of the report for which to get annotations for.
 * @return ApiBulkCreateOrUpdateAnnotationsRequest
*/
func (a *ReportsApiService) BulkCreateOrUpdateAnnotations(ctx _context.Context, username string, repoSlug string, commit string, reportId string) ApiBulkCreateOrUpdateAnnotationsRequest {
	return ApiBulkCreateOrUpdateAnnotationsRequest{
		ApiService: a,
		ctx:        ctx,
		username:   username,
		repoSlug:   repoSlug,
		commit:     commit,
		reportId:   reportId,
	}
}

/*
 * Execute executes the request
 * @return []ReportAnnotation
 */
func (a *ReportsApiService) BulkCreateOrUpdateAnnotationsExecute(r ApiBulkCreateOrUpdateAnnotationsRequest) ([]ReportAnnotation, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  []ReportAnnotation
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ReportsApiService.BulkCreateOrUpdateAnnotations")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/repositories/{username}/{repo_slug}/commit/{commit}/reports/{reportId}/annotations"
	localVarPath = strings.Replace(localVarPath, "{"+"username"+"}", _neturl.PathEscape(parameterToString(r.username, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repo_slug"+"}", _neturl.PathEscape(parameterToString(r.repoSlug, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commit"+"}", _neturl.PathEscape(parameterToString(r.commit, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"reportId"+"}", _neturl.PathEscape(parameterToString(r.reportId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.body == nil {
		return localVarReturnValue, nil, reportError("body is required and must be specified")
	}
	if len(*r.body) < 1 {
		return localVarReturnValue, nil, reportError("body must have at least 1 elements")
	}
	if len(*r.body) > 100 {
		return localVarReturnValue, nil, reportError("body must have less than 100 elements")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.body
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiCreateOrUpdateAnnotationRequest struct {
	ctx          _context.Context
	ApiService   *ReportsApiService
	username     string
	repoSlug     string
	commit       string
	reportId     string
	annotationId string
	body         *ReportAnnotation
}

func (r ApiCreateOrUpdateAnnotationRequest) Body(body ReportAnnotation) ApiCreateOrUpdateAnnotationRequest {
	r.body = &body
	return r
}

func (r ApiCreateOrUpdateAnnotationRequest) Execute() (ReportAnnotation, *_nethttp.Response, error) {
	return r.ApiService.CreateOrUpdateAnnotationExecute(r)
}

/*
 * CreateOrUpdateAnnotation Method for CreateOrUpdateAnnotation
 * Creates or updates an individual annotation for the specified report.
Annotations are individual findings that have been identified as part of a report, for example, a line of code that represents a vulnerability. These annotations can be attached to a specific file and even a specific line in that file, however, that is optional. Annotations are not mandatory and a report can contain up to 1000 annotations.

Just as reports, annotation needs to be uploaded with a unique ID that can later be used to identify the report as an alternative to the generated [UUID](https://developer.atlassian.com/bitbucket/api/2/reference/meta/uri-uuid#uuid). If you want to use an existing id from your own system, we recommend prefixing it with your system's name to avoid collisions, for example, mySystem-annotation001.

### Sample cURL request:
```
curl --request PUT 'https://api.bitbucket.org/2.0/repositories/<username>/<reposity-name>/commit/<commit-hash>/reports/mySystem-001/annotations/mysystem-annotation001' \
--header 'Content-Type: application/json' \
--data-raw '{
    "title": "Security scan report",
    "annotation_type": "VULNERABILITY",
    "summary": "This line represents a security thread.",
    "severity": "HIGH",
    "path": "my-service/src/main/java/com/myCompany/mysystem/logic/Main.java",
    "line": 42
}'
```

### Possible field values:
annotation_type: VULNERABILITY, CODE_SMELL, BUG
result: PASSED, FAILED, IGNORED, SKIPPED
severity: HIGH, MEDIUM, LOW, CRITICAL

Please refer to the [Code Insights documentation](https://confluence.atlassian.com/bitbucket/code-insights-994316785.html) for more information.

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param username The account.
 * @param repoSlug The repository.
 * @param commit The commit the report belongs to.
 * @param reportId Either the uuid or external-id of the report.
 * @param annotationId Either the uuid or external-id of the annotation.
 * @return ApiCreateOrUpdateAnnotationRequest
*/
func (a *ReportsApiService) CreateOrUpdateAnnotation(ctx _context.Context, username string, repoSlug string, commit string, reportId string, annotationId string) ApiCreateOrUpdateAnnotationRequest {
	return ApiCreateOrUpdateAnnotationRequest{
		ApiService:   a,
		ctx:          ctx,
		username:     username,
		repoSlug:     repoSlug,
		commit:       commit,
		reportId:     reportId,
		annotationId: annotationId,
	}
}

/*
 * Execute executes the request
 * @return ReportAnnotation
 */
func (a *ReportsApiService) CreateOrUpdateAnnotationExecute(r ApiCreateOrUpdateAnnotationRequest) (ReportAnnotation, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ReportAnnotation
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ReportsApiService.CreateOrUpdateAnnotation")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/repositories/{username}/{repo_slug}/commit/{commit}/reports/{reportId}/annotations/{annotationId}"
	localVarPath = strings.Replace(localVarPath, "{"+"username"+"}", _neturl.PathEscape(parameterToString(r.username, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repo_slug"+"}", _neturl.PathEscape(parameterToString(r.repoSlug, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commit"+"}", _neturl.PathEscape(parameterToString(r.commit, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"reportId"+"}", _neturl.PathEscape(parameterToString(r.reportId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"annotationId"+"}", _neturl.PathEscape(parameterToString(r.annotationId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.body == nil {
		return localVarReturnValue, nil, reportError("body is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.body
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v ModelError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiCreateOrUpdateReportRequest struct {
	ctx        _context.Context
	ApiService *ReportsApiService
	username   string
	repoSlug   string
	commit     string
	reportId   string
	body       *Report
}

func (r ApiCreateOrUpdateReportRequest) Body(body Report) ApiCreateOrUpdateReportRequest {
	r.body = &body
	return r
}

func (r ApiCreateOrUpdateReportRequest) Execute() (Report, *_nethttp.Response, error) {
	return r.ApiService.CreateOrUpdateReportExecute(r)
}

/*
 * CreateOrUpdateReport Method for CreateOrUpdateReport
 * Creates or updates a report for the specified commit.
To upload a report, make sure to generate an ID that is unique across all reports for that commit. If you want to use an existing id from your own system, we recommend prefixing it with your system's name to avoid collisions, for example, mySystem-001.

### Sample cURL request:
```
curl --request PUT 'https://api.bitbucket.org/2.0/repositories/<username>/<reposity-name>/commit/<commit-hash>/reports/mysystem-001' \
--header 'Content-Type: application/json' \
--data-raw '{
    "title": "Security scan report",
    "details": "This pull request introduces 10 new dependency vulnerabilities.",
    "report_type": "SECURITY",
    "reporter": "mySystem",
    "link": "http://www.mysystem.com/reports/001",
    "result": "FAILED",
    "data": [
        {
            "title": "Duration (seconds)",
            "type": "DURATION",
            "value": 14
        },
        {
            "title": "Safe to merge?",
            "type": "BOOLEAN",
            "value": false
        }
    ]
}'
```

### Possible field values:
report_type: SECURITY, COVERAGE, TEST, BUG
result: PASSED, FAILED, PENDING
data.type: BOOLEAN, DATE, DURATION, LINK, NUMBER, PERCENTAGE, TEXT

Please refer to the [Code Insights documentation](https://confluence.atlassian.com/bitbucket/code-insights-994316785.html) for more information.

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param username The account.
 * @param repoSlug The repository.
 * @param commit The commit the report belongs to.
 * @param reportId Either the uuid or external-id of the report.
 * @return ApiCreateOrUpdateReportRequest
*/
func (a *ReportsApiService) CreateOrUpdateReport(ctx _context.Context, username string, repoSlug string, commit string, reportId string) ApiCreateOrUpdateReportRequest {
	return ApiCreateOrUpdateReportRequest{
		ApiService: a,
		ctx:        ctx,
		username:   username,
		repoSlug:   repoSlug,
		commit:     commit,
		reportId:   reportId,
	}
}

/*
 * Execute executes the request
 * @return Report
 */
func (a *ReportsApiService) CreateOrUpdateReportExecute(r ApiCreateOrUpdateReportRequest) (Report, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Report
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ReportsApiService.CreateOrUpdateReport")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/repositories/{username}/{repo_slug}/commit/{commit}/reports/{reportId}"
	localVarPath = strings.Replace(localVarPath, "{"+"username"+"}", _neturl.PathEscape(parameterToString(r.username, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repo_slug"+"}", _neturl.PathEscape(parameterToString(r.repoSlug, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commit"+"}", _neturl.PathEscape(parameterToString(r.commit, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"reportId"+"}", _neturl.PathEscape(parameterToString(r.reportId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.body == nil {
		return localVarReturnValue, nil, reportError("body is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.body
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v ModelError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiDeleteAnnotationRequest struct {
	ctx          _context.Context
	ApiService   *ReportsApiService
	username     string
	repoSlug     string
	commit       string
	reportId     string
	annotationId string
}

func (r ApiDeleteAnnotationRequest) Execute() (*_nethttp.Response, error) {
	return r.ApiService.DeleteAnnotationExecute(r)
}

/*
 * DeleteAnnotation Method for DeleteAnnotation
 * Deletes a single Annotation matching the provided ID.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param username The account.
 * @param repoSlug The repository.
 * @param commit The commit the annotation belongs to.
 * @param reportId Either the uuid or external-id of the annotation.
 * @param annotationId Either the uuid or external-id of the annotation.
 * @return ApiDeleteAnnotationRequest
 */
func (a *ReportsApiService) DeleteAnnotation(ctx _context.Context, username string, repoSlug string, commit string, reportId string, annotationId string) ApiDeleteAnnotationRequest {
	return ApiDeleteAnnotationRequest{
		ApiService:   a,
		ctx:          ctx,
		username:     username,
		repoSlug:     repoSlug,
		commit:       commit,
		reportId:     reportId,
		annotationId: annotationId,
	}
}

/*
 * Execute executes the request
 */
func (a *ReportsApiService) DeleteAnnotationExecute(r ApiDeleteAnnotationRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ReportsApiService.DeleteAnnotation")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/repositories/{username}/{repo_slug}/commit/{commit}/reports/{reportId}/annotations/{annotationId}"
	localVarPath = strings.Replace(localVarPath, "{"+"username"+"}", _neturl.PathEscape(parameterToString(r.username, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repo_slug"+"}", _neturl.PathEscape(parameterToString(r.repoSlug, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commit"+"}", _neturl.PathEscape(parameterToString(r.commit, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"reportId"+"}", _neturl.PathEscape(parameterToString(r.reportId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"annotationId"+"}", _neturl.PathEscape(parameterToString(r.annotationId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiDeleteReportRequest struct {
	ctx        _context.Context
	ApiService *ReportsApiService
	username   string
	repoSlug   string
	commit     string
	reportId   string
}

func (r ApiDeleteReportRequest) Execute() (*_nethttp.Response, error) {
	return r.ApiService.DeleteReportExecute(r)
}

/*
 * DeleteReport Method for DeleteReport
 * Deletes a single Report matching the provided ID.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param username The account.
 * @param repoSlug The repository.
 * @param commit The commit the report belongs to.
 * @param reportId Either the uuid or external-id of the report.
 * @return ApiDeleteReportRequest
 */
func (a *ReportsApiService) DeleteReport(ctx _context.Context, username string, repoSlug string, commit string, reportId string) ApiDeleteReportRequest {
	return ApiDeleteReportRequest{
		ApiService: a,
		ctx:        ctx,
		username:   username,
		repoSlug:   repoSlug,
		commit:     commit,
		reportId:   reportId,
	}
}

/*
 * Execute executes the request
 */
func (a *ReportsApiService) DeleteReportExecute(r ApiDeleteReportRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ReportsApiService.DeleteReport")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/repositories/{username}/{repo_slug}/commit/{commit}/reports/{reportId}"
	localVarPath = strings.Replace(localVarPath, "{"+"username"+"}", _neturl.PathEscape(parameterToString(r.username, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repo_slug"+"}", _neturl.PathEscape(parameterToString(r.repoSlug, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commit"+"}", _neturl.PathEscape(parameterToString(r.commit, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"reportId"+"}", _neturl.PathEscape(parameterToString(r.reportId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiGetAnnotationRequest struct {
	ctx          _context.Context
	ApiService   *ReportsApiService
	username     string
	repoSlug     string
	commit       string
	reportId     string
	annotationId string
}

func (r ApiGetAnnotationRequest) Execute() (ReportAnnotation, *_nethttp.Response, error) {
	return r.ApiService.GetAnnotationExecute(r)
}

/*
 * GetAnnotation Method for GetAnnotation
 * Returns a single Annotation matching the provided ID.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param username The account.
 * @param repoSlug The repository.
 * @param commit The commit the report belongs to.
 * @param reportId Either the uuid or external-id of the report.
 * @param annotationId Either the uuid or external-id of the annotation.
 * @return ApiGetAnnotationRequest
 */
func (a *ReportsApiService) GetAnnotation(ctx _context.Context, username string, repoSlug string, commit string, reportId string, annotationId string) ApiGetAnnotationRequest {
	return ApiGetAnnotationRequest{
		ApiService:   a,
		ctx:          ctx,
		username:     username,
		repoSlug:     repoSlug,
		commit:       commit,
		reportId:     reportId,
		annotationId: annotationId,
	}
}

/*
 * Execute executes the request
 * @return ReportAnnotation
 */
func (a *ReportsApiService) GetAnnotationExecute(r ApiGetAnnotationRequest) (ReportAnnotation, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ReportAnnotation
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ReportsApiService.GetAnnotation")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/repositories/{username}/{repo_slug}/commit/{commit}/reports/{reportId}/annotations/{annotationId}"
	localVarPath = strings.Replace(localVarPath, "{"+"username"+"}", _neturl.PathEscape(parameterToString(r.username, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repo_slug"+"}", _neturl.PathEscape(parameterToString(r.repoSlug, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commit"+"}", _neturl.PathEscape(parameterToString(r.commit, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"reportId"+"}", _neturl.PathEscape(parameterToString(r.reportId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"annotationId"+"}", _neturl.PathEscape(parameterToString(r.annotationId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v ModelError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetAnnotationsForReportRequest struct {
	ctx        _context.Context
	ApiService *ReportsApiService
	username   string
	repoSlug   string
	commit     string
	reportId   string
}

func (r ApiGetAnnotationsForReportRequest) Execute() (PaginatedAnnotations, *_nethttp.Response, error) {
	return r.ApiService.GetAnnotationsForReportExecute(r)
}

/*
 * GetAnnotationsForReport Method for GetAnnotationsForReport
 * Returns a paginated list of Annotations for a specified report.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param username The account.
 * @param repoSlug The repository.
 * @param commit The commit for which to retrieve reports.
 * @param reportId Uuid or external-if of the report for which to get annotations for.
 * @return ApiGetAnnotationsForReportRequest
 */
func (a *ReportsApiService) GetAnnotationsForReport(ctx _context.Context, username string, repoSlug string, commit string, reportId string) ApiGetAnnotationsForReportRequest {
	return ApiGetAnnotationsForReportRequest{
		ApiService: a,
		ctx:        ctx,
		username:   username,
		repoSlug:   repoSlug,
		commit:     commit,
		reportId:   reportId,
	}
}

/*
 * Execute executes the request
 * @return PaginatedAnnotations
 */
func (a *ReportsApiService) GetAnnotationsForReportExecute(r ApiGetAnnotationsForReportRequest) (PaginatedAnnotations, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  PaginatedAnnotations
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ReportsApiService.GetAnnotationsForReport")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/repositories/{username}/{repo_slug}/commit/{commit}/reports/{reportId}/annotations"
	localVarPath = strings.Replace(localVarPath, "{"+"username"+"}", _neturl.PathEscape(parameterToString(r.username, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repo_slug"+"}", _neturl.PathEscape(parameterToString(r.repoSlug, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commit"+"}", _neturl.PathEscape(parameterToString(r.commit, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"reportId"+"}", _neturl.PathEscape(parameterToString(r.reportId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetReportRequest struct {
	ctx        _context.Context
	ApiService *ReportsApiService
	username   string
	repoSlug   string
	commit     string
	reportId   string
}

func (r ApiGetReportRequest) Execute() (Report, *_nethttp.Response, error) {
	return r.ApiService.GetReportExecute(r)
}

/*
 * GetReport Method for GetReport
 * Returns a single Report matching the provided ID.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param username The account.
 * @param repoSlug The repository.
 * @param commit The commit the report belongs to.
 * @param reportId Either the uuid or external-id of the report.
 * @return ApiGetReportRequest
 */
func (a *ReportsApiService) GetReport(ctx _context.Context, username string, repoSlug string, commit string, reportId string) ApiGetReportRequest {
	return ApiGetReportRequest{
		ApiService: a,
		ctx:        ctx,
		username:   username,
		repoSlug:   repoSlug,
		commit:     commit,
		reportId:   reportId,
	}
}

/*
 * Execute executes the request
 * @return Report
 */
func (a *ReportsApiService) GetReportExecute(r ApiGetReportRequest) (Report, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Report
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ReportsApiService.GetReport")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/repositories/{username}/{repo_slug}/commit/{commit}/reports/{reportId}"
	localVarPath = strings.Replace(localVarPath, "{"+"username"+"}", _neturl.PathEscape(parameterToString(r.username, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repo_slug"+"}", _neturl.PathEscape(parameterToString(r.repoSlug, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commit"+"}", _neturl.PathEscape(parameterToString(r.commit, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"reportId"+"}", _neturl.PathEscape(parameterToString(r.reportId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v ModelError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetReportsForCommitRequest struct {
	ctx        _context.Context
	ApiService *ReportsApiService
	username   string
	repoSlug   string
	commit     string
}

func (r ApiGetReportsForCommitRequest) Execute() (PaginatedReports, *_nethttp.Response, error) {
	return r.ApiService.GetReportsForCommitExecute(r)
}

/*
 * GetReportsForCommit Method for GetReportsForCommit
 * Returns a paginated list of Reports linked to this commit.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param username The account.
 * @param repoSlug The repository.
 * @param commit The commit for which to retrieve reports.
 * @return ApiGetReportsForCommitRequest
 */
func (a *ReportsApiService) GetReportsForCommit(ctx _context.Context, username string, repoSlug string, commit string) ApiGetReportsForCommitRequest {
	return ApiGetReportsForCommitRequest{
		ApiService: a,
		ctx:        ctx,
		username:   username,
		repoSlug:   repoSlug,
		commit:     commit,
	}
}

/*
 * Execute executes the request
 * @return PaginatedReports
 */
func (a *ReportsApiService) GetReportsForCommitExecute(r ApiGetReportsForCommitRequest) (PaginatedReports, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  PaginatedReports
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ReportsApiService.GetReportsForCommit")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/repositories/{username}/{repo_slug}/commit/{commit}/reports"
	localVarPath = strings.Replace(localVarPath, "{"+"username"+"}", _neturl.PathEscape(parameterToString(r.username, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repo_slug"+"}", _neturl.PathEscape(parameterToString(r.repoSlug, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commit"+"}", _neturl.PathEscape(parameterToString(r.commit, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
