// Copyright 2019 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package old

// This file contains the list of known URLs for valid licenses, only.
// Do not add other code.

// TODO: Find a canonical source of this information, or at least a
// disciplined way to develop it. This is cadged from gopkg.in/src-d/go-license-detector.v2.

// The URL text does not include the leading http:// or https://
// or trailing /.
// All entries are lower case.
// Keep this list sorted for easy checking.
var builtinURLs = []License{
	{URL: "creativecommons.org/licenses/by-nc-nd/2.0", Name: "CC-BY-NC-ND-2.0"},
	{URL: "creativecommons.org/licenses/by-nc-nd/2.5", Name: "CC-BY-NC-ND-2.5"},
	{URL: "creativecommons.org/licenses/by-nc-nd/3.0", Name: "CC-BY-NC-ND-3.0"},
	{URL: "creativecommons.org/licenses/by-nc-nd/4.0", Name: "CC-BY-NC-ND-4.0"},
	{URL: "creativecommons.org/licenses/by-nc-sa/1.0", Name: "CC-BY-NC-SA-1.0"},
	{URL: "creativecommons.org/licenses/by-nc-sa/2.0", Name: "CC-BY-NC-SA-2.0"},
	{URL: "creativecommons.org/licenses/by-nc-sa/2.5", Name: "CC-BY-NC-SA-2.5"},
	{URL: "creativecommons.org/licenses/by-nc-sa/3.0", Name: "CC-BY-NC-SA-3.0"},
	{URL: "creativecommons.org/licenses/by-nc-sa/4.0", Name: "CC-BY-NC-SA-4.0"},
	{URL: "creativecommons.org/licenses/by-nc/1.0", Name: "CC-BY-NC-1.0"},
	{URL: "creativecommons.org/licenses/by-nc/2.0", Name: "CC-BY-NC-2.0"},
	{URL: "creativecommons.org/licenses/by-nc/2.5", Name: "CC-BY-NC-2.5"},
	{URL: "creativecommons.org/licenses/by-nc/3.0", Name: "CC-BY-NC-3.0"},
	{URL: "creativecommons.org/licenses/by-nc/4.0", Name: "CC-BY-NC-4.0"},
	{URL: "creativecommons.org/licenses/by-nd-nc/1.0", Name: "CC-BY-NC-ND-1.0"},
	{URL: "creativecommons.org/licenses/by-nd/1.0", Name: "CC-BY-ND-1.0"},
	{URL: "creativecommons.org/licenses/by-nd/2.0", Name: "CC-BY-ND-2.0"},
	{URL: "creativecommons.org/licenses/by-nd/2.5", Name: "CC-BY-ND-2.5"},
	{URL: "creativecommons.org/licenses/by-nd/3.0", Name: "CC-BY-ND-3.0"},
	{URL: "creativecommons.org/licenses/by-nd/4.0", Name: "CC-BY-ND-4.0"},
	{URL: "creativecommons.org/licenses/by-sa/1.0", Name: "CC-BY-SA-1.0"},
	{URL: "creativecommons.org/licenses/by-sa/2.0", Name: "CC-BY-SA-2.0"},
	{URL: "creativecommons.org/licenses/by-sa/2.5", Name: "CC-BY-SA-2.5"},
	{URL: "creativecommons.org/licenses/by-sa/3.0", Name: "CC-BY-SA-3.0"},
	{URL: "creativecommons.org/licenses/by-sa/4.0", Name: "CC-BY-SA-4.0"},
	{URL: "creativecommons.org/licenses/by/1.0", Name: "CC-BY-1.0"},
	{URL: "creativecommons.org/licenses/by/2.0", Name: "CC-BY-2.0"},
	{URL: "creativecommons.org/licenses/by/2.5", Name: "CC-BY-2.5"},
	{URL: "creativecommons.org/licenses/by/3.0", Name: "CC-BY-3.0"},
	{URL: "creativecommons.org/licenses/by/4.0", Name: "CC-BY-4.0"},
	{URL: "creativecommons.org/publicdomain/zero/1.0", Name: "CC0-1.0"},
	{URL: "opensource.org/licenses/apache-1.1", Name: "Apache-1.1"},
	{URL: "opensource.org/licenses/artistic-1.0", Name: "Artistic-1.0"},
	{URL: "opensource.org/licenses/bsdpluspatent", Name: "BSD-2-Clause-Patent"},
	{URL: "opensource.org/licenses/catosl-1.1", Name: "CATOSL-1.1"},
	{URL: "opensource.org/licenses/cpl-1.0", Name: "CPL-1.0"},
	{URL: "opensource.org/licenses/cua-opl-1.0", Name: "CUA-OPL-1.0"},
	{URL: "opensource.org/licenses/ecl-1.0", Name: "ECL-1.0"},
	{URL: "opensource.org/licenses/ecl-2.0", Name: "ECL-2.0"},
	{URL: "opensource.org/licenses/efl-1.0", Name: "EFL-1.0"},
	{URL: "opensource.org/licenses/efl-2.0", Name: "EFL-2.0"},
	{URL: "opensource.org/licenses/entessa", Name: "Entessa"},
	{URL: "opensource.org/licenses/intel", Name: "Intel"},
	{URL: "opensource.org/licenses/lpl-1.0", Name: "LPL-1.0"},
	{URL: "opensource.org/licenses/liliq-p-1.1", Name: "LiLiQ-P-1.1"},
	{URL: "opensource.org/licenses/liliq-r-1.1", Name: "LiLiQ-R-1.1"},
	{URL: "opensource.org/licenses/liliq-rplus-1.1", Name: "LiLiQ-Rplus-1.1"},
	{URL: "opensource.org/licenses/mpl-1.0", Name: "MPL-1.0"},
	{URL: "opensource.org/licenses/mpl-2.0", Name: "MPL-2.0"},
	{URL: "opensource.org/licenses/opl-2.1", Name: "OSET-PL-2.1"},
	{URL: "opensource.org/licenses/osl-1.0", Name: "OSL-1.0"},
	{URL: "opensource.org/licenses/osl-2.1", Name: "OSL-2.1"},
	{URL: "opensource.org/licenses/rpl-1.1", Name: "RPL-1.1"},
	{URL: "opensource.org/licenses/sissl", Name: "SISSL"},
	{URL: "opensource.org/licenses/upl", Name: "UPL-1.0"},
	{URL: "opensource.org/licenses/xnet", Name: "Xnet"},
	{URL: "opensource.org/licenses/zpl-2.0", Name: "ZPL-2.0"},
	{URL: "www.apache.org/licenses/license-2.0", Name: "Apache-2.0"},
	{URL: "www.gnu.org/licenses/agpl.txt", Name: "AGPL-3.0"},
	{URL: "www.gnu.org/licenses/autoconf-exception-3.0.html", Name: "GPL-3.0-with-autoconf-exception"},
	{URL: "www.gnu.org/licenses/ecos-license.html", Name: "eCos-2.0"},
	{URL: "www.gnu.org/licenses/fdl-1.3.txt", Name: "GFDL-1.3"},
	{URL: "www.gnu.org/licenses/gcc-exception-3.1.html", Name: "GPL-3.0-with-GCC-exception"},
	{URL: "www.gnu.org/licenses/gpl-3.0-standalone.html", Name: "GPL-3.0"},
	{URL: "www.gnu.org/licenses/gpl-faq.html#fontexception", Name: "GPL-2.0-with-font-exception"},
	{URL: "www.gnu.org/licenses/lgpl-3.0-standalone.html", Name: "LGPL-3.0"},
	{URL: "www.gnu.org/licenses/old-licenses/fdl-1.1.txt", Name: "GFDL-1.1"},
	{URL: "www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", Name: "GPL-1.0"},
	{URL: "www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", Name: "GPL-2.0"},
	{URL: "www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", Name: "LGPL-2.0"},
	{URL: "www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", Name: "LGPL-2.1"},
	{URL: "www.gnu.org/prep/maintain/html_node/license-notices-for-other-files.html", Name: "FSFAP"},
	{URL: "www.gnu.org/software/classpath/license.html", Name: "GPL-2.0-with-classpath-exception"},
	{URL: "www.opensource.org/licenses/agpl-3.0", Name: "AGPL-3.0"},
	{URL: "www.opensource.org/licenses/apl-1.0", Name: "APL-1.0"},
	{URL: "www.opensource.org/licenses/apache-2.0", Name: "Apache-2.0"},
	{URL: "www.opensource.org/licenses/bsd-2-clause", Name: "BSD-2-Clause"},
	{URL: "www.opensource.org/licenses/bsd-3-clause", Name: "BSD-3-Clause"},
	{URL: "www.opensource.org/licenses/bsl-1.0", Name: "BSL-1.0"},
	{URL: "www.opensource.org/licenses/cnri-python", Name: "CNRI-Python"},
	{URL: "www.opensource.org/licenses/cpal-1.0", Name: "CPAL-1.0"},
	{URL: "www.opensource.org/licenses/epl-1.0", Name: "EPL-1.0"},
	{URL: "www.opensource.org/licenses/epl-2.0", Name: "EPL-2.0"},
	{URL: "www.opensource.org/licenses/eudatagrid", Name: "EUDatagrid"},
	{URL: "www.opensource.org/licenses/eupl-1.1", Name: "EUPL-1.1"},
	{URL: "www.opensource.org/licenses/fair", Name: "Fair"},
	{URL: "www.opensource.org/licenses/frameworx-1.0", Name: "Frameworx-1.0"},
	{URL: "www.opensource.org/licenses/gpl-2.0", Name: "GPL-2.0"},
	{URL: "www.opensource.org/licenses/gpl-3.0", Name: "GPL-3.0"},
	{URL: "www.opensource.org/licenses/hpnd", Name: "HPND"},
	{URL: "www.opensource.org/licenses/ipa", Name: "IPA"},
	{URL: "www.opensource.org/licenses/ipl-1.0", Name: "IPL-1.0"},
	{URL: "www.opensource.org/licenses/isc", Name: "ISC"},
	{URL: "www.opensource.org/licenses/lgpl-2.1", Name: "LGPL-2.1"},
	{URL: "www.opensource.org/licenses/lgpl-3.0", Name: "LGPL-3.0"},
	{URL: "www.opensource.org/licenses/lpl-1.02", Name: "LPL-1.02"},
	{URL: "www.opensource.org/licenses/lppl-1.3c", Name: "LPPL-1.3c"},
	{URL: "www.opensource.org/licenses/mit", Name: "MIT"},
	{URL: "www.opensource.org/licenses/mpl-1.1", Name: "MPL-1.1"},
	{URL: "www.opensource.org/licenses/ms-pl", Name: "MS-PL"},
	{URL: "www.opensource.org/licenses/ms-rl", Name: "MS-RL"},
	{URL: "www.opensource.org/licenses/miros", Name: "MirOS"},
	{URL: "www.opensource.org/licenses/motosoto", Name: "Motosoto"},
	{URL: "www.opensource.org/licenses/multics", Name: "Multics"},
	{URL: "www.opensource.org/licenses/nasa-1.3", Name: "NASA-1.3"},
	{URL: "www.opensource.org/licenses/ncsa", Name: "NCSA"},
	{URL: "www.opensource.org/licenses/ngpl", Name: "NGPL"},
	{URL: "www.opensource.org/licenses/nosl3.0", Name: "NPOSL-3.0"},
	{URL: "www.opensource.org/licenses/ntp", Name: "NTP"},
	{URL: "www.opensource.org/licenses/naumen", Name: "Naumen"},
	{URL: "www.opensource.org/licenses/oclc-2.0", Name: "OCLC-2.0"},
	{URL: "www.opensource.org/licenses/ofl-1.1", Name: "OFL-1.1"},
	{URL: "www.opensource.org/licenses/ogtsl", Name: "OGTSL"},
	{URL: "www.opensource.org/licenses/osl-3.0", Name: "OSL-3.0"},
	{URL: "www.opensource.org/licenses/php-3.0", Name: "PHP-3.0"},
	{URL: "www.opensource.org/licenses/postgresql", Name: "PostgreSQL"},
	{URL: "www.opensource.org/licenses/python-2.0", Name: "Python-2.0"},
	{URL: "www.opensource.org/licenses/qpl-1.0", Name: "QPL-1.0"},
	{URL: "www.opensource.org/licenses/rpl-1.5", Name: "RPL-1.5"},
	{URL: "www.opensource.org/licenses/rpsl-1.0", Name: "RPSL-1.0"},
	{URL: "www.opensource.org/licenses/rscpl", Name: "RSCPL"},
	{URL: "www.opensource.org/licenses/spl-1.0", Name: "SPL-1.0"},
	{URL: "www.opensource.org/licenses/simpl-2.0", Name: "SimPL-2.0"},
	{URL: "www.opensource.org/licenses/sleepycat", Name: "Sleepycat"},
	{URL: "www.opensource.org/licenses/vsl-1.0", Name: "VSL-1.0"},
	{URL: "www.opensource.org/licenses/w3c", Name: "W3C"},
	{URL: "www.opensource.org/licenses/wxwindows", Name: "wxWindows"},
	{URL: "www.opensource.org/licenses/watcom-1.0", Name: "Watcom-1.0"},
	{URL: "www.opensource.org/licenses/zlib", Name: "Zlib"},
	{URL: "www.opensource.org/licenses/afl-3.0", Name: "AFL-3.0"},
	{URL: "www.opensource.org/licenses/artistic-license-2.0", Name: "Artistic-2.0"},
	{URL: "www.opensource.org/licenses/attribution", Name: "AAL"},
	{URL: "www.opensource.org/licenses/cddl1", Name: "CDDL-1.0"},
	{URL: "www.opensource.org/licenses/nokia", Name: "Nokia"},
}
