// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package keymanagerv1

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// KeyManagerClient is the client API for KeyManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type KeyManagerClient interface {
	// Generates a new private key with the given ID. If a key already exists
	// under that ID, it is overwritten and given a different fingerprint. See
	// the PublicKey message for more details on the role of the fingerprint.
	GenerateKey(ctx context.Context, in *GenerateKeyRequest, opts ...grpc.CallOption) (*GenerateKeyResponse, error)
	// Gets the public key information for the private key managed by the
	// plugin with the given ID. If a key with the given ID does not exist,
	// NOT_FOUND is returned.
	GetPublicKey(ctx context.Context, in *GetPublicKeyRequest, opts ...grpc.CallOption) (*GetPublicKeyResponse, error)
	// Gets all public key information for the private keys managed by the
	// plugin.
	GetPublicKeys(ctx context.Context, in *GetPublicKeysRequest, opts ...grpc.CallOption) (*GetPublicKeysResponse, error)
	// Signs data with the private key identified by the given ID. If a key
	// with the given ID does not exist, NOT_FOUND is returned. The response
	// contains the signed data and the fingerprint of the key used to sign the
	// data. See the PublicKey message for more details on the role of the
	// fingerprint.
	SignData(ctx context.Context, in *SignDataRequest, opts ...grpc.CallOption) (*SignDataResponse, error)
}

type keyManagerClient struct {
	cc grpc.ClientConnInterface
}

func NewKeyManagerClient(cc grpc.ClientConnInterface) KeyManagerClient {
	return &keyManagerClient{cc}
}

func (c *keyManagerClient) GenerateKey(ctx context.Context, in *GenerateKeyRequest, opts ...grpc.CallOption) (*GenerateKeyResponse, error) {
	out := new(GenerateKeyResponse)
	err := c.cc.Invoke(ctx, "/spire.plugin.server.keymanager.v1.KeyManager/GenerateKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagerClient) GetPublicKey(ctx context.Context, in *GetPublicKeyRequest, opts ...grpc.CallOption) (*GetPublicKeyResponse, error) {
	out := new(GetPublicKeyResponse)
	err := c.cc.Invoke(ctx, "/spire.plugin.server.keymanager.v1.KeyManager/GetPublicKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagerClient) GetPublicKeys(ctx context.Context, in *GetPublicKeysRequest, opts ...grpc.CallOption) (*GetPublicKeysResponse, error) {
	out := new(GetPublicKeysResponse)
	err := c.cc.Invoke(ctx, "/spire.plugin.server.keymanager.v1.KeyManager/GetPublicKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagerClient) SignData(ctx context.Context, in *SignDataRequest, opts ...grpc.CallOption) (*SignDataResponse, error) {
	out := new(SignDataResponse)
	err := c.cc.Invoke(ctx, "/spire.plugin.server.keymanager.v1.KeyManager/SignData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// KeyManagerServer is the server API for KeyManager service.
// All implementations must embed UnimplementedKeyManagerServer
// for forward compatibility
type KeyManagerServer interface {
	// Generates a new private key with the given ID. If a key already exists
	// under that ID, it is overwritten and given a different fingerprint. See
	// the PublicKey message for more details on the role of the fingerprint.
	GenerateKey(context.Context, *GenerateKeyRequest) (*GenerateKeyResponse, error)
	// Gets the public key information for the private key managed by the
	// plugin with the given ID. If a key with the given ID does not exist,
	// NOT_FOUND is returned.
	GetPublicKey(context.Context, *GetPublicKeyRequest) (*GetPublicKeyResponse, error)
	// Gets all public key information for the private keys managed by the
	// plugin.
	GetPublicKeys(context.Context, *GetPublicKeysRequest) (*GetPublicKeysResponse, error)
	// Signs data with the private key identified by the given ID. If a key
	// with the given ID does not exist, NOT_FOUND is returned. The response
	// contains the signed data and the fingerprint of the key used to sign the
	// data. See the PublicKey message for more details on the role of the
	// fingerprint.
	SignData(context.Context, *SignDataRequest) (*SignDataResponse, error)
	mustEmbedUnimplementedKeyManagerServer()
}

// UnimplementedKeyManagerServer must be embedded to have forward compatible implementations.
type UnimplementedKeyManagerServer struct {
}

func (UnimplementedKeyManagerServer) GenerateKey(context.Context, *GenerateKeyRequest) (*GenerateKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateKey not implemented")
}
func (UnimplementedKeyManagerServer) GetPublicKey(context.Context, *GetPublicKeyRequest) (*GetPublicKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPublicKey not implemented")
}
func (UnimplementedKeyManagerServer) GetPublicKeys(context.Context, *GetPublicKeysRequest) (*GetPublicKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPublicKeys not implemented")
}
func (UnimplementedKeyManagerServer) SignData(context.Context, *SignDataRequest) (*SignDataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SignData not implemented")
}
func (UnimplementedKeyManagerServer) mustEmbedUnimplementedKeyManagerServer() {}

// UnsafeKeyManagerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to KeyManagerServer will
// result in compilation errors.
type UnsafeKeyManagerServer interface {
	mustEmbedUnimplementedKeyManagerServer()
}

func RegisterKeyManagerServer(s grpc.ServiceRegistrar, srv KeyManagerServer) {
	s.RegisterService(&KeyManager_ServiceDesc, srv)
}

func _KeyManager_GenerateKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagerServer).GenerateKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.plugin.server.keymanager.v1.KeyManager/GenerateKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagerServer).GenerateKey(ctx, req.(*GenerateKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManager_GetPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagerServer).GetPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.plugin.server.keymanager.v1.KeyManager/GetPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagerServer).GetPublicKey(ctx, req.(*GetPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManager_GetPublicKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPublicKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagerServer).GetPublicKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.plugin.server.keymanager.v1.KeyManager/GetPublicKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagerServer).GetPublicKeys(ctx, req.(*GetPublicKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManager_SignData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SignDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagerServer).SignData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.plugin.server.keymanager.v1.KeyManager/SignData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagerServer).SignData(ctx, req.(*SignDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// KeyManager_ServiceDesc is the grpc.ServiceDesc for KeyManager service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var KeyManager_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "spire.plugin.server.keymanager.v1.KeyManager",
	HandlerType: (*KeyManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GenerateKey",
			Handler:    _KeyManager_GenerateKey_Handler,
		},
		{
			MethodName: "GetPublicKey",
			Handler:    _KeyManager_GetPublicKey_Handler,
		},
		{
			MethodName: "GetPublicKeys",
			Handler:    _KeyManager_GetPublicKeys_Handler,
		},
		{
			MethodName: "SignData",
			Handler:    _KeyManager_SignData_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "spire/plugin/server/keymanager/v1/keymanager.proto",
}
