/*============================================================================*
 *============================================================================*
 * Component:           plextor-tool-applet
 * Filename:            scsi-functions.h
 *                                                                             
 * Authors:             Georg Huettenegger
 *                                                                             
 * Date of Creation:    Thu Aug 12 17:54:48 1999
 *                                                                             
 * Last Modification:   Thu Aug 12 17:54:48 1999
 *                                                                             
 * Copyright:           Georg Huettenegger                                  
 *                                                                             
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *                                                                             
 *============================================================================*
 *============================================================================*
 */

#ifndef ___SCSI_FUNCTIONS_H
#define ___SCSI_FUNCTIONS_H

#include "gplextor-tool.h"

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Returns a string describing the current speed of the device.
 *                                                                             
 *----------------------------------------------------------------------------*
 */
const char * return_speed_string (int act_speed, int drive_type,
                                  int mmc_drive);

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Performs an inquiry searching for available drives (and storing
 * eventual results in gptad).
 *                                                                             
 *----------------------------------------------------------------------------*
 */
void inquiry_all_drives (GPlextorToolAppletData * gptad);

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Changes the speed of the gptd device to new_speed_selection.
 *                                                                             
 *----------------------------------------------------------------------------*
 */
void change_speed_of_device (const char * new_speed_selection,
                             GPlextorToolData * gptd);

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Changes the speed of the gptd device to new_spindown_selection.
 *                                                                             
 *----------------------------------------------------------------------------*
 */
void change_spindown_of_device (const char * new_spindown_selection,
                                GPlextorToolData * gptd);

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Changes the avoid vibration bit of gptd (to status stored in gptd).
 *                                                                             
 *----------------------------------------------------------------------------*
 */
void change_avoid_vibration_setting (GPlextorToolData * gptd);

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Changes the waiting bit of gptd (to status stored in gptd).
 *                                                                             
 *----------------------------------------------------------------------------*
 */
void change_waiting_for_speed_setting (GPlextorToolData * gptd);

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Changes the speed mode bit of gptd (to status stored in gptd).
 *                                                                             
 *----------------------------------------------------------------------------*
 */
void change_speed_mode_setting (GPlextorToolData * gptd);

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Changes the volume (internal audio out) of gptd (to status stored in gptd).
 *                                                                             
 *----------------------------------------------------------------------------*
 */
void change_volume_setting (GPlextorToolData * gptd);

#endif

/*============================================================================*
 *============================================================================*
 * EOF scsi-functions.h
 *============================================================================*
 *============================================================================*
 */
