//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v4"
	"net/http"
	"net/url"
	"regexp"
)

// PrivateLinkServicesServer is a fake server for instances of the armnetwork.PrivateLinkServicesClient type.
type PrivateLinkServicesServer struct {
	// BeginCheckPrivateLinkServiceVisibility is the fake for method PrivateLinkServicesClient.BeginCheckPrivateLinkServiceVisibility
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCheckPrivateLinkServiceVisibility func(ctx context.Context, location string, parameters armnetwork.CheckPrivateLinkServiceVisibilityRequest, options *armnetwork.PrivateLinkServicesClientBeginCheckPrivateLinkServiceVisibilityOptions) (resp azfake.PollerResponder[armnetwork.PrivateLinkServicesClientCheckPrivateLinkServiceVisibilityResponse], errResp azfake.ErrorResponder)

	// BeginCheckPrivateLinkServiceVisibilityByResourceGroup is the fake for method PrivateLinkServicesClient.BeginCheckPrivateLinkServiceVisibilityByResourceGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCheckPrivateLinkServiceVisibilityByResourceGroup func(ctx context.Context, location string, resourceGroupName string, parameters armnetwork.CheckPrivateLinkServiceVisibilityRequest, options *armnetwork.PrivateLinkServicesClientBeginCheckPrivateLinkServiceVisibilityByResourceGroupOptions) (resp azfake.PollerResponder[armnetwork.PrivateLinkServicesClientCheckPrivateLinkServiceVisibilityByResourceGroupResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method PrivateLinkServicesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, serviceName string, parameters armnetwork.PrivateLinkService, options *armnetwork.PrivateLinkServicesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armnetwork.PrivateLinkServicesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method PrivateLinkServicesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, serviceName string, options *armnetwork.PrivateLinkServicesClientBeginDeleteOptions) (resp azfake.PollerResponder[armnetwork.PrivateLinkServicesClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDeletePrivateEndpointConnection is the fake for method PrivateLinkServicesClient.BeginDeletePrivateEndpointConnection
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeletePrivateEndpointConnection func(ctx context.Context, resourceGroupName string, serviceName string, peConnectionName string, options *armnetwork.PrivateLinkServicesClientBeginDeletePrivateEndpointConnectionOptions) (resp azfake.PollerResponder[armnetwork.PrivateLinkServicesClientDeletePrivateEndpointConnectionResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method PrivateLinkServicesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serviceName string, options *armnetwork.PrivateLinkServicesClientGetOptions) (resp azfake.Responder[armnetwork.PrivateLinkServicesClientGetResponse], errResp azfake.ErrorResponder)

	// GetPrivateEndpointConnection is the fake for method PrivateLinkServicesClient.GetPrivateEndpointConnection
	// HTTP status codes to indicate success: http.StatusOK
	GetPrivateEndpointConnection func(ctx context.Context, resourceGroupName string, serviceName string, peConnectionName string, options *armnetwork.PrivateLinkServicesClientGetPrivateEndpointConnectionOptions) (resp azfake.Responder[armnetwork.PrivateLinkServicesClientGetPrivateEndpointConnectionResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method PrivateLinkServicesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, options *armnetwork.PrivateLinkServicesClientListOptions) (resp azfake.PagerResponder[armnetwork.PrivateLinkServicesClientListResponse])

	// NewListAutoApprovedPrivateLinkServicesPager is the fake for method PrivateLinkServicesClient.NewListAutoApprovedPrivateLinkServicesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAutoApprovedPrivateLinkServicesPager func(location string, options *armnetwork.PrivateLinkServicesClientListAutoApprovedPrivateLinkServicesOptions) (resp azfake.PagerResponder[armnetwork.PrivateLinkServicesClientListAutoApprovedPrivateLinkServicesResponse])

	// NewListAutoApprovedPrivateLinkServicesByResourceGroupPager is the fake for method PrivateLinkServicesClient.NewListAutoApprovedPrivateLinkServicesByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAutoApprovedPrivateLinkServicesByResourceGroupPager func(location string, resourceGroupName string, options *armnetwork.PrivateLinkServicesClientListAutoApprovedPrivateLinkServicesByResourceGroupOptions) (resp azfake.PagerResponder[armnetwork.PrivateLinkServicesClientListAutoApprovedPrivateLinkServicesByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method PrivateLinkServicesClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armnetwork.PrivateLinkServicesClientListBySubscriptionOptions) (resp azfake.PagerResponder[armnetwork.PrivateLinkServicesClientListBySubscriptionResponse])

	// NewListPrivateEndpointConnectionsPager is the fake for method PrivateLinkServicesClient.NewListPrivateEndpointConnectionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPrivateEndpointConnectionsPager func(resourceGroupName string, serviceName string, options *armnetwork.PrivateLinkServicesClientListPrivateEndpointConnectionsOptions) (resp azfake.PagerResponder[armnetwork.PrivateLinkServicesClientListPrivateEndpointConnectionsResponse])

	// UpdatePrivateEndpointConnection is the fake for method PrivateLinkServicesClient.UpdatePrivateEndpointConnection
	// HTTP status codes to indicate success: http.StatusOK
	UpdatePrivateEndpointConnection func(ctx context.Context, resourceGroupName string, serviceName string, peConnectionName string, parameters armnetwork.PrivateEndpointConnection, options *armnetwork.PrivateLinkServicesClientUpdatePrivateEndpointConnectionOptions) (resp azfake.Responder[armnetwork.PrivateLinkServicesClientUpdatePrivateEndpointConnectionResponse], errResp azfake.ErrorResponder)
}

// NewPrivateLinkServicesServerTransport creates a new instance of PrivateLinkServicesServerTransport with the provided implementation.
// The returned PrivateLinkServicesServerTransport instance is connected to an instance of armnetwork.PrivateLinkServicesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPrivateLinkServicesServerTransport(srv *PrivateLinkServicesServer) *PrivateLinkServicesServerTransport {
	return &PrivateLinkServicesServerTransport{
		srv:                                    srv,
		beginCheckPrivateLinkServiceVisibility: newTracker[azfake.PollerResponder[armnetwork.PrivateLinkServicesClientCheckPrivateLinkServiceVisibilityResponse]](),
		beginCheckPrivateLinkServiceVisibilityByResourceGroup: newTracker[azfake.PollerResponder[armnetwork.PrivateLinkServicesClientCheckPrivateLinkServiceVisibilityByResourceGroupResponse]](),
		beginCreateOrUpdate:                         newTracker[azfake.PollerResponder[armnetwork.PrivateLinkServicesClientCreateOrUpdateResponse]](),
		beginDelete:                                 newTracker[azfake.PollerResponder[armnetwork.PrivateLinkServicesClientDeleteResponse]](),
		beginDeletePrivateEndpointConnection:        newTracker[azfake.PollerResponder[armnetwork.PrivateLinkServicesClientDeletePrivateEndpointConnectionResponse]](),
		newListPager:                                newTracker[azfake.PagerResponder[armnetwork.PrivateLinkServicesClientListResponse]](),
		newListAutoApprovedPrivateLinkServicesPager: newTracker[azfake.PagerResponder[armnetwork.PrivateLinkServicesClientListAutoApprovedPrivateLinkServicesResponse]](),
		newListAutoApprovedPrivateLinkServicesByResourceGroupPager: newTracker[azfake.PagerResponder[armnetwork.PrivateLinkServicesClientListAutoApprovedPrivateLinkServicesByResourceGroupResponse]](),
		newListBySubscriptionPager:                                 newTracker[azfake.PagerResponder[armnetwork.PrivateLinkServicesClientListBySubscriptionResponse]](),
		newListPrivateEndpointConnectionsPager:                     newTracker[azfake.PagerResponder[armnetwork.PrivateLinkServicesClientListPrivateEndpointConnectionsResponse]](),
	}
}

// PrivateLinkServicesServerTransport connects instances of armnetwork.PrivateLinkServicesClient to instances of PrivateLinkServicesServer.
// Don't use this type directly, use NewPrivateLinkServicesServerTransport instead.
type PrivateLinkServicesServerTransport struct {
	srv                                                        *PrivateLinkServicesServer
	beginCheckPrivateLinkServiceVisibility                     *tracker[azfake.PollerResponder[armnetwork.PrivateLinkServicesClientCheckPrivateLinkServiceVisibilityResponse]]
	beginCheckPrivateLinkServiceVisibilityByResourceGroup      *tracker[azfake.PollerResponder[armnetwork.PrivateLinkServicesClientCheckPrivateLinkServiceVisibilityByResourceGroupResponse]]
	beginCreateOrUpdate                                        *tracker[azfake.PollerResponder[armnetwork.PrivateLinkServicesClientCreateOrUpdateResponse]]
	beginDelete                                                *tracker[azfake.PollerResponder[armnetwork.PrivateLinkServicesClientDeleteResponse]]
	beginDeletePrivateEndpointConnection                       *tracker[azfake.PollerResponder[armnetwork.PrivateLinkServicesClientDeletePrivateEndpointConnectionResponse]]
	newListPager                                               *tracker[azfake.PagerResponder[armnetwork.PrivateLinkServicesClientListResponse]]
	newListAutoApprovedPrivateLinkServicesPager                *tracker[azfake.PagerResponder[armnetwork.PrivateLinkServicesClientListAutoApprovedPrivateLinkServicesResponse]]
	newListAutoApprovedPrivateLinkServicesByResourceGroupPager *tracker[azfake.PagerResponder[armnetwork.PrivateLinkServicesClientListAutoApprovedPrivateLinkServicesByResourceGroupResponse]]
	newListBySubscriptionPager                                 *tracker[azfake.PagerResponder[armnetwork.PrivateLinkServicesClientListBySubscriptionResponse]]
	newListPrivateEndpointConnectionsPager                     *tracker[azfake.PagerResponder[armnetwork.PrivateLinkServicesClientListPrivateEndpointConnectionsResponse]]
}

// Do implements the policy.Transporter interface for PrivateLinkServicesServerTransport.
func (p *PrivateLinkServicesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PrivateLinkServicesClient.BeginCheckPrivateLinkServiceVisibility":
		resp, err = p.dispatchBeginCheckPrivateLinkServiceVisibility(req)
	case "PrivateLinkServicesClient.BeginCheckPrivateLinkServiceVisibilityByResourceGroup":
		resp, err = p.dispatchBeginCheckPrivateLinkServiceVisibilityByResourceGroup(req)
	case "PrivateLinkServicesClient.BeginCreateOrUpdate":
		resp, err = p.dispatchBeginCreateOrUpdate(req)
	case "PrivateLinkServicesClient.BeginDelete":
		resp, err = p.dispatchBeginDelete(req)
	case "PrivateLinkServicesClient.BeginDeletePrivateEndpointConnection":
		resp, err = p.dispatchBeginDeletePrivateEndpointConnection(req)
	case "PrivateLinkServicesClient.Get":
		resp, err = p.dispatchGet(req)
	case "PrivateLinkServicesClient.GetPrivateEndpointConnection":
		resp, err = p.dispatchGetPrivateEndpointConnection(req)
	case "PrivateLinkServicesClient.NewListPager":
		resp, err = p.dispatchNewListPager(req)
	case "PrivateLinkServicesClient.NewListAutoApprovedPrivateLinkServicesPager":
		resp, err = p.dispatchNewListAutoApprovedPrivateLinkServicesPager(req)
	case "PrivateLinkServicesClient.NewListAutoApprovedPrivateLinkServicesByResourceGroupPager":
		resp, err = p.dispatchNewListAutoApprovedPrivateLinkServicesByResourceGroupPager(req)
	case "PrivateLinkServicesClient.NewListBySubscriptionPager":
		resp, err = p.dispatchNewListBySubscriptionPager(req)
	case "PrivateLinkServicesClient.NewListPrivateEndpointConnectionsPager":
		resp, err = p.dispatchNewListPrivateEndpointConnectionsPager(req)
	case "PrivateLinkServicesClient.UpdatePrivateEndpointConnection":
		resp, err = p.dispatchUpdatePrivateEndpointConnection(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PrivateLinkServicesServerTransport) dispatchBeginCheckPrivateLinkServiceVisibility(req *http.Request) (*http.Response, error) {
	if p.srv.BeginCheckPrivateLinkServiceVisibility == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCheckPrivateLinkServiceVisibility not implemented")}
	}
	beginCheckPrivateLinkServiceVisibility := p.beginCheckPrivateLinkServiceVisibility.get(req)
	if beginCheckPrivateLinkServiceVisibility == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/checkPrivateLinkServiceVisibility`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.CheckPrivateLinkServiceVisibilityRequest](req)
		if err != nil {
			return nil, err
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginCheckPrivateLinkServiceVisibility(req.Context(), locationParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCheckPrivateLinkServiceVisibility = &respr
		p.beginCheckPrivateLinkServiceVisibility.add(req, beginCheckPrivateLinkServiceVisibility)
	}

	resp, err := server.PollerResponderNext(beginCheckPrivateLinkServiceVisibility, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		p.beginCheckPrivateLinkServiceVisibility.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCheckPrivateLinkServiceVisibility) {
		p.beginCheckPrivateLinkServiceVisibility.remove(req)
	}

	return resp, nil
}

func (p *PrivateLinkServicesServerTransport) dispatchBeginCheckPrivateLinkServiceVisibilityByResourceGroup(req *http.Request) (*http.Response, error) {
	if p.srv.BeginCheckPrivateLinkServiceVisibilityByResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCheckPrivateLinkServiceVisibilityByResourceGroup not implemented")}
	}
	beginCheckPrivateLinkServiceVisibilityByResourceGroup := p.beginCheckPrivateLinkServiceVisibilityByResourceGroup.get(req)
	if beginCheckPrivateLinkServiceVisibilityByResourceGroup == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/checkPrivateLinkServiceVisibility`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.CheckPrivateLinkServiceVisibilityRequest](req)
		if err != nil {
			return nil, err
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginCheckPrivateLinkServiceVisibilityByResourceGroup(req.Context(), locationParam, resourceGroupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCheckPrivateLinkServiceVisibilityByResourceGroup = &respr
		p.beginCheckPrivateLinkServiceVisibilityByResourceGroup.add(req, beginCheckPrivateLinkServiceVisibilityByResourceGroup)
	}

	resp, err := server.PollerResponderNext(beginCheckPrivateLinkServiceVisibilityByResourceGroup, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		p.beginCheckPrivateLinkServiceVisibilityByResourceGroup.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCheckPrivateLinkServiceVisibilityByResourceGroup) {
		p.beginCheckPrivateLinkServiceVisibilityByResourceGroup.remove(req)
	}

	return resp, nil
}

func (p *PrivateLinkServicesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := p.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/privateLinkServices/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.PrivateLinkService](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, serviceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		p.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		p.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		p.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (p *PrivateLinkServicesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if p.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := p.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/privateLinkServices/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginDelete(req.Context(), resourceGroupNameParam, serviceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		p.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		p.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		p.beginDelete.remove(req)
	}

	return resp, nil
}

func (p *PrivateLinkServicesServerTransport) dispatchBeginDeletePrivateEndpointConnection(req *http.Request) (*http.Response, error) {
	if p.srv.BeginDeletePrivateEndpointConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeletePrivateEndpointConnection not implemented")}
	}
	beginDeletePrivateEndpointConnection := p.beginDeletePrivateEndpointConnection.get(req)
	if beginDeletePrivateEndpointConnection == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/privateLinkServices/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections/(?P<peConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		peConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("peConnectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginDeletePrivateEndpointConnection(req.Context(), resourceGroupNameParam, serviceNameParam, peConnectionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeletePrivateEndpointConnection = &respr
		p.beginDeletePrivateEndpointConnection.add(req, beginDeletePrivateEndpointConnection)
	}

	resp, err := server.PollerResponderNext(beginDeletePrivateEndpointConnection, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		p.beginDeletePrivateEndpointConnection.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeletePrivateEndpointConnection) {
		p.beginDeletePrivateEndpointConnection.remove(req)
	}

	return resp, nil
}

func (p *PrivateLinkServicesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/privateLinkServices/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	var options *armnetwork.PrivateLinkServicesClientGetOptions
	if expandParam != nil {
		options = &armnetwork.PrivateLinkServicesClientGetOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := p.srv.Get(req.Context(), resourceGroupNameParam, serviceNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrivateLinkService, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateLinkServicesServerTransport) dispatchGetPrivateEndpointConnection(req *http.Request) (*http.Response, error) {
	if p.srv.GetPrivateEndpointConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPrivateEndpointConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/privateLinkServices/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections/(?P<peConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	peConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("peConnectionName")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	var options *armnetwork.PrivateLinkServicesClientGetPrivateEndpointConnectionOptions
	if expandParam != nil {
		options = &armnetwork.PrivateLinkServicesClientGetPrivateEndpointConnectionOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := p.srv.GetPrivateEndpointConnection(req.Context(), resourceGroupNameParam, serviceNameParam, peConnectionNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrivateEndpointConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateLinkServicesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := p.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/privateLinkServices`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListPager(resourceGroupNameParam, nil)
		newListPager = &resp
		p.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armnetwork.PrivateLinkServicesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		p.newListPager.remove(req)
	}
	return resp, nil
}

func (p *PrivateLinkServicesServerTransport) dispatchNewListAutoApprovedPrivateLinkServicesPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListAutoApprovedPrivateLinkServicesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAutoApprovedPrivateLinkServicesPager not implemented")}
	}
	newListAutoApprovedPrivateLinkServicesPager := p.newListAutoApprovedPrivateLinkServicesPager.get(req)
	if newListAutoApprovedPrivateLinkServicesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/autoApprovedPrivateLinkServices`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListAutoApprovedPrivateLinkServicesPager(locationParam, nil)
		newListAutoApprovedPrivateLinkServicesPager = &resp
		p.newListAutoApprovedPrivateLinkServicesPager.add(req, newListAutoApprovedPrivateLinkServicesPager)
		server.PagerResponderInjectNextLinks(newListAutoApprovedPrivateLinkServicesPager, req, func(page *armnetwork.PrivateLinkServicesClientListAutoApprovedPrivateLinkServicesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAutoApprovedPrivateLinkServicesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListAutoApprovedPrivateLinkServicesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAutoApprovedPrivateLinkServicesPager) {
		p.newListAutoApprovedPrivateLinkServicesPager.remove(req)
	}
	return resp, nil
}

func (p *PrivateLinkServicesServerTransport) dispatchNewListAutoApprovedPrivateLinkServicesByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListAutoApprovedPrivateLinkServicesByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAutoApprovedPrivateLinkServicesByResourceGroupPager not implemented")}
	}
	newListAutoApprovedPrivateLinkServicesByResourceGroupPager := p.newListAutoApprovedPrivateLinkServicesByResourceGroupPager.get(req)
	if newListAutoApprovedPrivateLinkServicesByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/autoApprovedPrivateLinkServices`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListAutoApprovedPrivateLinkServicesByResourceGroupPager(locationParam, resourceGroupNameParam, nil)
		newListAutoApprovedPrivateLinkServicesByResourceGroupPager = &resp
		p.newListAutoApprovedPrivateLinkServicesByResourceGroupPager.add(req, newListAutoApprovedPrivateLinkServicesByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListAutoApprovedPrivateLinkServicesByResourceGroupPager, req, func(page *armnetwork.PrivateLinkServicesClientListAutoApprovedPrivateLinkServicesByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAutoApprovedPrivateLinkServicesByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListAutoApprovedPrivateLinkServicesByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAutoApprovedPrivateLinkServicesByResourceGroupPager) {
		p.newListAutoApprovedPrivateLinkServicesByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (p *PrivateLinkServicesServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := p.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/privateLinkServices`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := p.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		p.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armnetwork.PrivateLinkServicesClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		p.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (p *PrivateLinkServicesServerTransport) dispatchNewListPrivateEndpointConnectionsPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListPrivateEndpointConnectionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPrivateEndpointConnectionsPager not implemented")}
	}
	newListPrivateEndpointConnectionsPager := p.newListPrivateEndpointConnectionsPager.get(req)
	if newListPrivateEndpointConnectionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/privateLinkServices/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListPrivateEndpointConnectionsPager(resourceGroupNameParam, serviceNameParam, nil)
		newListPrivateEndpointConnectionsPager = &resp
		p.newListPrivateEndpointConnectionsPager.add(req, newListPrivateEndpointConnectionsPager)
		server.PagerResponderInjectNextLinks(newListPrivateEndpointConnectionsPager, req, func(page *armnetwork.PrivateLinkServicesClientListPrivateEndpointConnectionsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPrivateEndpointConnectionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListPrivateEndpointConnectionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPrivateEndpointConnectionsPager) {
		p.newListPrivateEndpointConnectionsPager.remove(req)
	}
	return resp, nil
}

func (p *PrivateLinkServicesServerTransport) dispatchUpdatePrivateEndpointConnection(req *http.Request) (*http.Response, error) {
	if p.srv.UpdatePrivateEndpointConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdatePrivateEndpointConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/privateLinkServices/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections/(?P<peConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armnetwork.PrivateEndpointConnection](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	peConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("peConnectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.UpdatePrivateEndpointConnection(req.Context(), resourceGroupNameParam, serviceNameParam, peConnectionNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrivateEndpointConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
