//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetwork_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v4"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VpnServerConfigurationGet.json
func ExampleVPNServerConfigurationsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVPNServerConfigurationsClient().Get(ctx, "rg1", "vpnServerConfiguration1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VPNServerConfiguration = armnetwork.VPNServerConfiguration{
	// 	Name: to.Ptr("vpnServerConfiguration1"),
	// 	Type: to.Ptr("Microsoft.Network/vpnServerConfigurations"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 	},
	// 	Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 	Properties: &armnetwork.VPNServerConfigurationProperties{
	// 		ConfigurationPolicyGroups: []*armnetwork.VPNServerConfigurationPolicyGroup{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup1"),
	// 				Name: to.Ptr("policyGroup1"),
	// 				Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 				Properties: &armnetwork.VPNServerConfigurationPolicyGroupProperties{
	// 					IsDefault: to.Ptr(true),
	// 					P2SConnectionConfigurations: []*armnetwork.SubResource{
	// 						{
	// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/p2sVpnGateways/p2sVpnGateway1/p2sConnectionConfigurations/P2SConnectionConfig1"),
	// 					}},
	// 					PolicyMembers: []*armnetwork.VPNServerConfigurationPolicyGroupMember{
	// 						{
	// 							Name: to.Ptr("policy1"),
	// 							AttributeType: to.Ptr(armnetwork.VPNPolicyMemberAttributeTypeRadiusAzureGroupID),
	// 							AttributeValue: to.Ptr("6ad1bd08"),
	// 					}},
	// 					Priority: to.Ptr[int32](0),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup2"),
	// 				Name: to.Ptr("policyGroup2"),
	// 				Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 				Properties: &armnetwork.VPNServerConfigurationPolicyGroupProperties{
	// 					IsDefault: to.Ptr(true),
	// 					PolicyMembers: []*armnetwork.VPNServerConfigurationPolicyGroupMember{
	// 						{
	// 							Name: to.Ptr("policy2"),
	// 							AttributeType: to.Ptr(armnetwork.VPNPolicyMemberAttributeTypeCertificateGroupID),
	// 							AttributeValue: to.Ptr("red.com"),
	// 					}},
	// 					Priority: to.Ptr[int32](0),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 				},
	// 		}},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		RadiusClientRootCertificates: []*armnetwork.VPNServerConfigRadiusClientRootCertificate{
	// 			{
	// 				Name: to.Ptr("vpnServerConfigRadiusClientRootCert1"),
	// 				Thumbprint: to.Ptr("83FFBFC8848B5A5836C94D0112367E16148A286F"),
	// 		}},
	// 		RadiusServerRootCertificates: []*armnetwork.VPNServerConfigRadiusServerRootCertificate{
	// 			{
	// 				Name: to.Ptr("vpnServerConfigRadiusServerRootCer1"),
	// 				PublicCertData: to.Ptr("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM"),
	// 		}},
	// 		RadiusServers: []*armnetwork.RadiusServer{
	// 			{
	// 				RadiusServerAddress: to.Ptr("10.0.0.0"),
	// 				RadiusServerScore: to.Ptr[int64](25),
	// 		}},
	// 		VPNAuthenticationTypes: []*armnetwork.VPNAuthenticationType{
	// 			to.Ptr(armnetwork.VPNAuthenticationTypeCertificate)},
	// 			VPNClientIPSecPolicies: []*armnetwork.IPSecPolicy{
	// 				{
	// 					DhGroup: to.Ptr(armnetwork.DhGroupDHGroup14),
	// 					IkeEncryption: to.Ptr(armnetwork.IkeEncryptionAES256),
	// 					IkeIntegrity: to.Ptr(armnetwork.IkeIntegritySHA384),
	// 					IPSecEncryption: to.Ptr(armnetwork.IPSecEncryptionAES256),
	// 					IPSecIntegrity: to.Ptr(armnetwork.IPSecIntegritySHA256),
	// 					PfsGroup: to.Ptr(armnetwork.PfsGroupPFS14),
	// 					SaDataSizeKilobytes: to.Ptr[int32](429497),
	// 					SaLifeTimeSeconds: to.Ptr[int32](86472),
	// 			}},
	// 			VPNClientRevokedCertificates: []*armnetwork.VPNServerConfigVPNClientRevokedCertificate{
	// 				{
	// 					Name: to.Ptr("vpnServerConfigVpnClientRevokedCert1"),
	// 					Thumbprint: to.Ptr("83FFBFC8848B5A5836C94D0112367E16148A286F"),
	// 			}},
	// 			VPNClientRootCertificates: []*armnetwork.VPNServerConfigVPNClientRootCertificate{
	// 				{
	// 					Name: to.Ptr("vpnServerConfigVpnClientRootCert1"),
	// 					PublicCertData: to.Ptr("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN"),
	// 			}},
	// 			VPNProtocols: []*armnetwork.VPNGatewayTunnelingProtocol{
	// 				to.Ptr(armnetwork.VPNGatewayTunnelingProtocolIkeV2)},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VpnServerConfigurationPut.json
func ExampleVPNServerConfigurationsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVPNServerConfigurationsClient().BeginCreateOrUpdate(ctx, "rg1", "vpnServerConfiguration1", armnetwork.VPNServerConfiguration{
		Location: to.Ptr("West US"),
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
		},
		Properties: &armnetwork.VPNServerConfigurationProperties{
			ConfigurationPolicyGroups: []*armnetwork.VPNServerConfigurationPolicyGroup{
				{
					ID:   to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup1"),
					Name: to.Ptr("policyGroup1"),
					Properties: &armnetwork.VPNServerConfigurationPolicyGroupProperties{
						IsDefault: to.Ptr(true),
						PolicyMembers: []*armnetwork.VPNServerConfigurationPolicyGroupMember{
							{
								Name:           to.Ptr("policy1"),
								AttributeType:  to.Ptr(armnetwork.VPNPolicyMemberAttributeTypeRadiusAzureGroupID),
								AttributeValue: to.Ptr("6ad1bd08"),
							}},
						Priority: to.Ptr[int32](0),
					},
				},
				{
					ID:   to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup2"),
					Name: to.Ptr("policyGroup2"),
					Properties: &armnetwork.VPNServerConfigurationPolicyGroupProperties{
						IsDefault: to.Ptr(true),
						PolicyMembers: []*armnetwork.VPNServerConfigurationPolicyGroupMember{
							{
								Name:           to.Ptr("policy2"),
								AttributeType:  to.Ptr(armnetwork.VPNPolicyMemberAttributeTypeCertificateGroupID),
								AttributeValue: to.Ptr("red.com"),
							}},
						Priority: to.Ptr[int32](0),
					},
				}},
			RadiusClientRootCertificates: []*armnetwork.VPNServerConfigRadiusClientRootCertificate{
				{
					Name:       to.Ptr("vpnServerConfigRadiusClientRootCert1"),
					Thumbprint: to.Ptr("83FFBFC8848B5A5836C94D0112367E16148A286F"),
				}},
			RadiusServerRootCertificates: []*armnetwork.VPNServerConfigRadiusServerRootCertificate{
				{
					Name:           to.Ptr("vpnServerConfigRadiusServerRootCer1"),
					PublicCertData: to.Ptr("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM"),
				}},
			RadiusServers: []*armnetwork.RadiusServer{
				{
					RadiusServerAddress: to.Ptr("10.0.0.0"),
					RadiusServerScore:   to.Ptr[int64](25),
					RadiusServerSecret:  to.Ptr("radiusServerSecret"),
				}},
			VPNClientIPSecPolicies: []*armnetwork.IPSecPolicy{
				{
					DhGroup:             to.Ptr(armnetwork.DhGroupDHGroup14),
					IkeEncryption:       to.Ptr(armnetwork.IkeEncryptionAES256),
					IkeIntegrity:        to.Ptr(armnetwork.IkeIntegritySHA384),
					IPSecEncryption:     to.Ptr(armnetwork.IPSecEncryptionAES256),
					IPSecIntegrity:      to.Ptr(armnetwork.IPSecIntegritySHA256),
					PfsGroup:            to.Ptr(armnetwork.PfsGroupPFS14),
					SaDataSizeKilobytes: to.Ptr[int32](429497),
					SaLifeTimeSeconds:   to.Ptr[int32](86472),
				}},
			VPNClientRevokedCertificates: []*armnetwork.VPNServerConfigVPNClientRevokedCertificate{
				{
					Name:       to.Ptr("vpnServerConfigVpnClientRevokedCert1"),
					Thumbprint: to.Ptr("83FFBFC8848B5A5836C94D0112367E16148A286F"),
				}},
			VPNClientRootCertificates: []*armnetwork.VPNServerConfigVPNClientRootCertificate{
				{
					Name:           to.Ptr("vpnServerConfigVpnClientRootCert1"),
					PublicCertData: to.Ptr("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN"),
				}},
			VPNProtocols: []*armnetwork.VPNGatewayTunnelingProtocol{
				to.Ptr(armnetwork.VPNGatewayTunnelingProtocolIkeV2)},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VPNServerConfiguration = armnetwork.VPNServerConfiguration{
	// 	Name: to.Ptr("vpnServerConfiguration1"),
	// 	Type: to.Ptr("Microsoft.Network/vpnServerConfigurations"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 	},
	// 	Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 	Properties: &armnetwork.VPNServerConfigurationProperties{
	// 		ConfigurationPolicyGroups: []*armnetwork.VPNServerConfigurationPolicyGroup{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup1"),
	// 				Name: to.Ptr("policyGroup1"),
	// 				Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 				Properties: &armnetwork.VPNServerConfigurationPolicyGroupProperties{
	// 					IsDefault: to.Ptr(true),
	// 					P2SConnectionConfigurations: []*armnetwork.SubResource{
	// 						{
	// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/p2sVpnGateways/p2sVpnGateway1/p2sConnectionConfigurations/P2SConnectionConfig1"),
	// 					}},
	// 					PolicyMembers: []*armnetwork.VPNServerConfigurationPolicyGroupMember{
	// 						{
	// 							Name: to.Ptr("policy1"),
	// 							AttributeType: to.Ptr(armnetwork.VPNPolicyMemberAttributeTypeRadiusAzureGroupID),
	// 							AttributeValue: to.Ptr("6ad1bd08"),
	// 					}},
	// 					Priority: to.Ptr[int32](0),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup2"),
	// 				Name: to.Ptr("policyGroup2"),
	// 				Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 				Properties: &armnetwork.VPNServerConfigurationPolicyGroupProperties{
	// 					IsDefault: to.Ptr(true),
	// 					PolicyMembers: []*armnetwork.VPNServerConfigurationPolicyGroupMember{
	// 						{
	// 							Name: to.Ptr("policy2"),
	// 							AttributeType: to.Ptr(armnetwork.VPNPolicyMemberAttributeTypeCertificateGroupID),
	// 							AttributeValue: to.Ptr("red.com"),
	// 					}},
	// 					Priority: to.Ptr[int32](0),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 				},
	// 		}},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		RadiusClientRootCertificates: []*armnetwork.VPNServerConfigRadiusClientRootCertificate{
	// 			{
	// 				Name: to.Ptr("vpnServerConfigRadiusClientRootCert1"),
	// 				Thumbprint: to.Ptr("83FFBFC8848B5A5836C94D0112367E16148A286F"),
	// 		}},
	// 		RadiusServerRootCertificates: []*armnetwork.VPNServerConfigRadiusServerRootCertificate{
	// 			{
	// 				Name: to.Ptr("vpnServerConfigRadiusServerRootCer1"),
	// 				PublicCertData: to.Ptr("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM"),
	// 		}},
	// 		RadiusServers: []*armnetwork.RadiusServer{
	// 			{
	// 				RadiusServerAddress: to.Ptr("10.0.0.0"),
	// 				RadiusServerScore: to.Ptr[int64](25),
	// 		}},
	// 		VPNAuthenticationTypes: []*armnetwork.VPNAuthenticationType{
	// 			to.Ptr(armnetwork.VPNAuthenticationTypeCertificate)},
	// 			VPNClientIPSecPolicies: []*armnetwork.IPSecPolicy{
	// 				{
	// 					DhGroup: to.Ptr(armnetwork.DhGroupDHGroup14),
	// 					IkeEncryption: to.Ptr(armnetwork.IkeEncryptionAES256),
	// 					IkeIntegrity: to.Ptr(armnetwork.IkeIntegritySHA384),
	// 					IPSecEncryption: to.Ptr(armnetwork.IPSecEncryptionAES256),
	// 					IPSecIntegrity: to.Ptr(armnetwork.IPSecIntegritySHA256),
	// 					PfsGroup: to.Ptr(armnetwork.PfsGroupPFS14),
	// 					SaDataSizeKilobytes: to.Ptr[int32](429497),
	// 					SaLifeTimeSeconds: to.Ptr[int32](86472),
	// 			}},
	// 			VPNClientRevokedCertificates: []*armnetwork.VPNServerConfigVPNClientRevokedCertificate{
	// 				{
	// 					Name: to.Ptr("vpnServerConfigVpnClientRevokedCert1"),
	// 					Thumbprint: to.Ptr("83FFBFC8848B5A5836C94D0112367E16148A286F"),
	// 			}},
	// 			VPNClientRootCertificates: []*armnetwork.VPNServerConfigVPNClientRootCertificate{
	// 				{
	// 					Name: to.Ptr("vpnServerConfigVpnClientRootCert1"),
	// 					PublicCertData: to.Ptr("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN"),
	// 			}},
	// 			VPNProtocols: []*armnetwork.VPNGatewayTunnelingProtocol{
	// 				to.Ptr(armnetwork.VPNGatewayTunnelingProtocolIkeV2)},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VpnServerConfigurationUpdateTags.json
func ExampleVPNServerConfigurationsClient_UpdateTags() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVPNServerConfigurationsClient().UpdateTags(ctx, "rg1", "vpnServerConfiguration1", armnetwork.TagsObject{
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
			"key2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VPNServerConfiguration = armnetwork.VPNServerConfiguration{
	// 	Name: to.Ptr("vpnServerConfiguration1"),
	// 	Type: to.Ptr("Microsoft.Network/vpnServerConfigurations"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 	Properties: &armnetwork.VPNServerConfigurationProperties{
	// 		ConfigurationPolicyGroups: []*armnetwork.VPNServerConfigurationPolicyGroup{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup1"),
	// 				Name: to.Ptr("policyGroup1"),
	// 				Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 				Properties: &armnetwork.VPNServerConfigurationPolicyGroupProperties{
	// 					IsDefault: to.Ptr(true),
	// 					P2SConnectionConfigurations: []*armnetwork.SubResource{
	// 						{
	// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/p2sVpnGateways/p2sVpnGateway1/p2sConnectionConfigurations/P2SConnectionConfig1"),
	// 					}},
	// 					PolicyMembers: []*armnetwork.VPNServerConfigurationPolicyGroupMember{
	// 						{
	// 							Name: to.Ptr("policy1"),
	// 							AttributeType: to.Ptr(armnetwork.VPNPolicyMemberAttributeTypeRadiusAzureGroupID),
	// 							AttributeValue: to.Ptr("6ad1bd08"),
	// 					}},
	// 					Priority: to.Ptr[int32](0),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup2"),
	// 				Name: to.Ptr("policyGroup2"),
	// 				Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 				Properties: &armnetwork.VPNServerConfigurationPolicyGroupProperties{
	// 					IsDefault: to.Ptr(true),
	// 					PolicyMembers: []*armnetwork.VPNServerConfigurationPolicyGroupMember{
	// 						{
	// 							Name: to.Ptr("policy2"),
	// 							AttributeType: to.Ptr(armnetwork.VPNPolicyMemberAttributeTypeCertificateGroupID),
	// 							AttributeValue: to.Ptr("red.com"),
	// 					}},
	// 					Priority: to.Ptr[int32](0),
	// 				},
	// 		}},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		RadiusClientRootCertificates: []*armnetwork.VPNServerConfigRadiusClientRootCertificate{
	// 			{
	// 				Name: to.Ptr("vpnServerConfigRadiusClientRootCert1"),
	// 				Thumbprint: to.Ptr("83FFBFC8848B5A5836C94D0112367E16148A286F"),
	// 		}},
	// 		RadiusServerAddress: to.Ptr("8.9.9.9"),
	// 		RadiusServerRootCertificates: []*armnetwork.VPNServerConfigRadiusServerRootCertificate{
	// 			{
	// 				Name: to.Ptr("vpnServerConfigRadiusServerRootCer1"),
	// 				PublicCertData: to.Ptr("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM"),
	// 		}},
	// 		RadiusServerSecret: to.Ptr("<password>"),
	// 		VPNClientIPSecPolicies: []*armnetwork.IPSecPolicy{
	// 			{
	// 				DhGroup: to.Ptr(armnetwork.DhGroupDHGroup14),
	// 				IkeEncryption: to.Ptr(armnetwork.IkeEncryptionAES256),
	// 				IkeIntegrity: to.Ptr(armnetwork.IkeIntegritySHA384),
	// 				IPSecEncryption: to.Ptr(armnetwork.IPSecEncryptionAES256),
	// 				IPSecIntegrity: to.Ptr(armnetwork.IPSecIntegritySHA256),
	// 				PfsGroup: to.Ptr(armnetwork.PfsGroupPFS14),
	// 				SaDataSizeKilobytes: to.Ptr[int32](429497),
	// 				SaLifeTimeSeconds: to.Ptr[int32](86472),
	// 		}},
	// 		VPNClientRevokedCertificates: []*armnetwork.VPNServerConfigVPNClientRevokedCertificate{
	// 			{
	// 				Name: to.Ptr("vpnServerConfigVpnClientRevokedCert1"),
	// 				Thumbprint: to.Ptr("83FFBFC8848B5A5836C94D0112367E16148A286F"),
	// 		}},
	// 		VPNClientRootCertificates: []*armnetwork.VPNServerConfigVPNClientRootCertificate{
	// 			{
	// 				Name: to.Ptr("vpnServerConfigVpnClientRootCert1"),
	// 				PublicCertData: to.Ptr("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN"),
	// 		}},
	// 		VPNProtocols: []*armnetwork.VPNGatewayTunnelingProtocol{
	// 			to.Ptr(armnetwork.VPNGatewayTunnelingProtocolIkeV2)},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VpnServerConfigurationDelete.json
func ExampleVPNServerConfigurationsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVPNServerConfigurationsClient().BeginDelete(ctx, "rg1", "vpnServerConfiguration1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VpnServerConfigurationListByResourceGroup.json
func ExampleVPNServerConfigurationsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVPNServerConfigurationsClient().NewListByResourceGroupPager("rg1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ListVPNServerConfigurationsResult = armnetwork.ListVPNServerConfigurationsResult{
		// 	Value: []*armnetwork.VPNServerConfiguration{
		// 		{
		// 			Name: to.Ptr("vpnServerConfiguration1"),
		// 			Type: to.Ptr("Microsoft.Network/vpnServerConfigurations"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1"),
		// 			Location: to.Ptr("West US"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 			},
		// 			Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 			Properties: &armnetwork.VPNServerConfigurationProperties{
		// 				ConfigurationPolicyGroups: []*armnetwork.VPNServerConfigurationPolicyGroup{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup1"),
		// 						Name: to.Ptr("policyGroup1"),
		// 						Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 						Properties: &armnetwork.VPNServerConfigurationPolicyGroupProperties{
		// 							IsDefault: to.Ptr(true),
		// 							P2SConnectionConfigurations: []*armnetwork.SubResource{
		// 								{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/p2sVpnGateways/p2sVpnGateway1/p2sConnectionConfigurations/P2SConnectionConfig1"),
		// 							}},
		// 							PolicyMembers: []*armnetwork.VPNServerConfigurationPolicyGroupMember{
		// 								{
		// 									Name: to.Ptr("policy1"),
		// 									AttributeType: to.Ptr(armnetwork.VPNPolicyMemberAttributeTypeRadiusAzureGroupID),
		// 									AttributeValue: to.Ptr("6ad1bd08"),
		// 							}},
		// 							Priority: to.Ptr[int32](0),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup2"),
		// 						Name: to.Ptr("policyGroup2"),
		// 						Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 						Properties: &armnetwork.VPNServerConfigurationPolicyGroupProperties{
		// 							IsDefault: to.Ptr(true),
		// 							PolicyMembers: []*armnetwork.VPNServerConfigurationPolicyGroupMember{
		// 								{
		// 									Name: to.Ptr("policy2"),
		// 									AttributeType: to.Ptr(armnetwork.VPNPolicyMemberAttributeTypeCertificateGroupID),
		// 									AttributeValue: to.Ptr("red.com"),
		// 							}},
		// 							Priority: to.Ptr[int32](0),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 						},
		// 				}},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				RadiusClientRootCertificates: []*armnetwork.VPNServerConfigRadiusClientRootCertificate{
		// 					{
		// 						Name: to.Ptr("vpnServerConfigRadiusClientRootCert1"),
		// 						Thumbprint: to.Ptr("83FFBFC8848B5A5836C94D0112367E16148A286F"),
		// 				}},
		// 				RadiusServerAddress: to.Ptr("8.9.9.9"),
		// 				RadiusServerRootCertificates: []*armnetwork.VPNServerConfigRadiusServerRootCertificate{
		// 					{
		// 						Name: to.Ptr("vpnServerConfigRadiusServerRootCer1"),
		// 						PublicCertData: to.Ptr("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM"),
		// 				}},
		// 				RadiusServerSecret: to.Ptr("<password>"),
		// 				VPNAuthenticationTypes: []*armnetwork.VPNAuthenticationType{
		// 					to.Ptr(armnetwork.VPNAuthenticationTypeCertificate)},
		// 					VPNClientIPSecPolicies: []*armnetwork.IPSecPolicy{
		// 						{
		// 							DhGroup: to.Ptr(armnetwork.DhGroupDHGroup14),
		// 							IkeEncryption: to.Ptr(armnetwork.IkeEncryptionAES256),
		// 							IkeIntegrity: to.Ptr(armnetwork.IkeIntegritySHA384),
		// 							IPSecEncryption: to.Ptr(armnetwork.IPSecEncryptionAES256),
		// 							IPSecIntegrity: to.Ptr(armnetwork.IPSecIntegritySHA256),
		// 							PfsGroup: to.Ptr(armnetwork.PfsGroupPFS14),
		// 							SaDataSizeKilobytes: to.Ptr[int32](429497),
		// 							SaLifeTimeSeconds: to.Ptr[int32](86472),
		// 					}},
		// 					VPNClientRevokedCertificates: []*armnetwork.VPNServerConfigVPNClientRevokedCertificate{
		// 						{
		// 							Name: to.Ptr("vpnServerConfigVpnClientRevokedCert1"),
		// 							Thumbprint: to.Ptr("83FFBFC8848B5A5836C94D0112367E16148A286F"),
		// 					}},
		// 					VPNClientRootCertificates: []*armnetwork.VPNServerConfigVPNClientRootCertificate{
		// 						{
		// 							Name: to.Ptr("vpnServerConfigVpnClientRootCert1"),
		// 							PublicCertData: to.Ptr("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN"),
		// 					}},
		// 					VPNProtocols: []*armnetwork.VPNGatewayTunnelingProtocol{
		// 						to.Ptr(armnetwork.VPNGatewayTunnelingProtocolIkeV2)},
		// 					},
		// 				},
		// 				{
		// 					Name: to.Ptr("vpnServerConfiguration2"),
		// 					Type: to.Ptr("Microsoft.Network/vpnServerConfigurations"),
		// 					ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration2"),
		// 					Location: to.Ptr("West US"),
		// 					Tags: map[string]*string{
		// 						"key1": to.Ptr("value1"),
		// 					},
		// 					Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 					Properties: &armnetwork.VPNServerConfigurationProperties{
		// 						ConfigurationPolicyGroups: []*armnetwork.VPNServerConfigurationPolicyGroup{
		// 							{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup1"),
		// 								Name: to.Ptr("policyGroup1"),
		// 								Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 								Properties: &armnetwork.VPNServerConfigurationPolicyGroupProperties{
		// 									IsDefault: to.Ptr(true),
		// 									P2SConnectionConfigurations: []*armnetwork.SubResource{
		// 										{
		// 											ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/p2sVpnGateways/p2sVpnGateway1/p2sConnectionConfigurations/P2SConnectionConfig1"),
		// 									}},
		// 									PolicyMembers: []*armnetwork.VPNServerConfigurationPolicyGroupMember{
		// 										{
		// 											Name: to.Ptr("policy1"),
		// 											AttributeType: to.Ptr(armnetwork.VPNPolicyMemberAttributeTypeRadiusAzureGroupID),
		// 											AttributeValue: to.Ptr("6ad1bd08"),
		// 									}},
		// 									Priority: to.Ptr[int32](0),
		// 									ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 								},
		// 							},
		// 							{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup2"),
		// 								Name: to.Ptr("policyGroup2"),
		// 								Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 								Properties: &armnetwork.VPNServerConfigurationPolicyGroupProperties{
		// 									IsDefault: to.Ptr(true),
		// 									PolicyMembers: []*armnetwork.VPNServerConfigurationPolicyGroupMember{
		// 										{
		// 											Name: to.Ptr("policy2"),
		// 											AttributeType: to.Ptr(armnetwork.VPNPolicyMemberAttributeTypeCertificateGroupID),
		// 											AttributeValue: to.Ptr("red.com"),
		// 									}},
		// 									Priority: to.Ptr[int32](0),
		// 									ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 								},
		// 						}},
		// 						ProvisioningState: to.Ptr("Succeeded"),
		// 						RadiusClientRootCertificates: []*armnetwork.VPNServerConfigRadiusClientRootCertificate{
		// 							{
		// 								Name: to.Ptr("vpnServerConfigRadiusClientRootCert1"),
		// 								Thumbprint: to.Ptr("83FFBFC8848B5A5836C94D0112367E16148A286F"),
		// 						}},
		// 						RadiusServerAddress: to.Ptr("8.9.9.9"),
		// 						RadiusServerRootCertificates: []*armnetwork.VPNServerConfigRadiusServerRootCertificate{
		// 							{
		// 								Name: to.Ptr("vpnServerConfigRadiusServerRootCer1"),
		// 								PublicCertData: to.Ptr("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM"),
		// 						}},
		// 						RadiusServerSecret: to.Ptr("<password>"),
		// 						VPNAuthenticationTypes: []*armnetwork.VPNAuthenticationType{
		// 							to.Ptr(armnetwork.VPNAuthenticationTypeCertificate)},
		// 							VPNClientIPSecPolicies: []*armnetwork.IPSecPolicy{
		// 								{
		// 									DhGroup: to.Ptr(armnetwork.DhGroupDHGroup14),
		// 									IkeEncryption: to.Ptr(armnetwork.IkeEncryptionAES256),
		// 									IkeIntegrity: to.Ptr(armnetwork.IkeIntegritySHA384),
		// 									IPSecEncryption: to.Ptr(armnetwork.IPSecEncryptionAES256),
		// 									IPSecIntegrity: to.Ptr(armnetwork.IPSecIntegritySHA256),
		// 									PfsGroup: to.Ptr(armnetwork.PfsGroupPFS14),
		// 									SaDataSizeKilobytes: to.Ptr[int32](429497),
		// 									SaLifeTimeSeconds: to.Ptr[int32](86472),
		// 							}},
		// 							VPNClientRevokedCertificates: []*armnetwork.VPNServerConfigVPNClientRevokedCertificate{
		// 								{
		// 									Name: to.Ptr("vpnServerConfigVpnClientRevokedCert1"),
		// 									Thumbprint: to.Ptr("83FFBFC8848B5A5836C94D0112367E16148A286F"),
		// 							}},
		// 							VPNClientRootCertificates: []*armnetwork.VPNServerConfigVPNClientRootCertificate{
		// 								{
		// 									Name: to.Ptr("vpnServerConfigVpnClientRootCert1"),
		// 									PublicCertData: to.Ptr("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN"),
		// 							}},
		// 							VPNProtocols: []*armnetwork.VPNGatewayTunnelingProtocol{
		// 								to.Ptr(armnetwork.VPNGatewayTunnelingProtocolIkeV2)},
		// 							},
		// 					}},
		// 				}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VpnServerConfigurationList.json
func ExampleVPNServerConfigurationsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVPNServerConfigurationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ListVPNServerConfigurationsResult = armnetwork.ListVPNServerConfigurationsResult{
		// 	Value: []*armnetwork.VPNServerConfiguration{
		// 		{
		// 			Name: to.Ptr("vpnServerConfiguration1"),
		// 			Type: to.Ptr("Microsoft.Network/vpnServerConfigurations"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1"),
		// 			Location: to.Ptr("West US"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 			},
		// 			Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 			Properties: &armnetwork.VPNServerConfigurationProperties{
		// 				ConfigurationPolicyGroups: []*armnetwork.VPNServerConfigurationPolicyGroup{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup1"),
		// 						Name: to.Ptr("policyGroup1"),
		// 						Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 						Properties: &armnetwork.VPNServerConfigurationPolicyGroupProperties{
		// 							IsDefault: to.Ptr(true),
		// 							P2SConnectionConfigurations: []*armnetwork.SubResource{
		// 								{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/p2sVpnGateways/p2sVpnGateway1/p2sConnectionConfigurations/P2SConnectionConfig1"),
		// 							}},
		// 							PolicyMembers: []*armnetwork.VPNServerConfigurationPolicyGroupMember{
		// 								{
		// 									Name: to.Ptr("policy1"),
		// 									AttributeType: to.Ptr(armnetwork.VPNPolicyMemberAttributeTypeRadiusAzureGroupID),
		// 									AttributeValue: to.Ptr("6ad1bd08"),
		// 							}},
		// 							Priority: to.Ptr[int32](0),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup2"),
		// 						Name: to.Ptr("policyGroup2"),
		// 						Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 						Properties: &armnetwork.VPNServerConfigurationPolicyGroupProperties{
		// 							IsDefault: to.Ptr(true),
		// 							PolicyMembers: []*armnetwork.VPNServerConfigurationPolicyGroupMember{
		// 								{
		// 									Name: to.Ptr("policy2"),
		// 									AttributeType: to.Ptr(armnetwork.VPNPolicyMemberAttributeTypeCertificateGroupID),
		// 									AttributeValue: to.Ptr("red.com"),
		// 							}},
		// 							Priority: to.Ptr[int32](0),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 						},
		// 				}},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				RadiusClientRootCertificates: []*armnetwork.VPNServerConfigRadiusClientRootCertificate{
		// 					{
		// 						Name: to.Ptr("vpnServerConfigRadiusClientRootCert1"),
		// 						Thumbprint: to.Ptr("83FFBFC8848B5A5836C94D0112367E16148A286F"),
		// 				}},
		// 				RadiusServerAddress: to.Ptr("8.9.9.9"),
		// 				RadiusServerRootCertificates: []*armnetwork.VPNServerConfigRadiusServerRootCertificate{
		// 					{
		// 						Name: to.Ptr("vpnServerConfigRadiusServerRootCer1"),
		// 						PublicCertData: to.Ptr("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM"),
		// 				}},
		// 				RadiusServerSecret: to.Ptr("<password>"),
		// 				VPNAuthenticationTypes: []*armnetwork.VPNAuthenticationType{
		// 					to.Ptr(armnetwork.VPNAuthenticationTypeCertificate)},
		// 					VPNClientIPSecPolicies: []*armnetwork.IPSecPolicy{
		// 						{
		// 							DhGroup: to.Ptr(armnetwork.DhGroupDHGroup14),
		// 							IkeEncryption: to.Ptr(armnetwork.IkeEncryptionAES256),
		// 							IkeIntegrity: to.Ptr(armnetwork.IkeIntegritySHA384),
		// 							IPSecEncryption: to.Ptr(armnetwork.IPSecEncryptionAES256),
		// 							IPSecIntegrity: to.Ptr(armnetwork.IPSecIntegritySHA256),
		// 							PfsGroup: to.Ptr(armnetwork.PfsGroupPFS14),
		// 							SaDataSizeKilobytes: to.Ptr[int32](429497),
		// 							SaLifeTimeSeconds: to.Ptr[int32](86472),
		// 					}},
		// 					VPNClientRevokedCertificates: []*armnetwork.VPNServerConfigVPNClientRevokedCertificate{
		// 						{
		// 							Name: to.Ptr("vpnServerConfigVpnClientRevokedCert1"),
		// 							Thumbprint: to.Ptr("83FFBFC8848B5A5836C94D0112367E16148A286F"),
		// 					}},
		// 					VPNClientRootCertificates: []*armnetwork.VPNServerConfigVPNClientRootCertificate{
		// 						{
		// 							Name: to.Ptr("vpnServerConfigVpnClientRootCert1"),
		// 							PublicCertData: to.Ptr("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN"),
		// 					}},
		// 					VPNProtocols: []*armnetwork.VPNGatewayTunnelingProtocol{
		// 						to.Ptr(armnetwork.VPNGatewayTunnelingProtocolIkeV2)},
		// 					},
		// 				},
		// 				{
		// 					Name: to.Ptr("vpnServerConfiguration2"),
		// 					Type: to.Ptr("Microsoft.Network/vpnServerConfigurations"),
		// 					ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration2"),
		// 					Location: to.Ptr("East US"),
		// 					Tags: map[string]*string{
		// 						"key1": to.Ptr("value1"),
		// 					},
		// 					Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 					Properties: &armnetwork.VPNServerConfigurationProperties{
		// 						ConfigurationPolicyGroups: []*armnetwork.VPNServerConfigurationPolicyGroup{
		// 							{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup1"),
		// 								Name: to.Ptr("policyGroup1"),
		// 								Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 								Properties: &armnetwork.VPNServerConfigurationPolicyGroupProperties{
		// 									IsDefault: to.Ptr(true),
		// 									P2SConnectionConfigurations: []*armnetwork.SubResource{
		// 										{
		// 											ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/p2sVpnGateways/p2sVpnGateway1/p2sConnectionConfigurations/P2SConnectionConfig1"),
		// 									}},
		// 									PolicyMembers: []*armnetwork.VPNServerConfigurationPolicyGroupMember{
		// 										{
		// 											Name: to.Ptr("policy1"),
		// 											AttributeType: to.Ptr(armnetwork.VPNPolicyMemberAttributeTypeRadiusAzureGroupID),
		// 											AttributeValue: to.Ptr("6ad1bd08"),
		// 									}},
		// 									Priority: to.Ptr[int32](0),
		// 									ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 								},
		// 							},
		// 							{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup2"),
		// 								Name: to.Ptr("policyGroup2"),
		// 								Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 								Properties: &armnetwork.VPNServerConfigurationPolicyGroupProperties{
		// 									IsDefault: to.Ptr(true),
		// 									PolicyMembers: []*armnetwork.VPNServerConfigurationPolicyGroupMember{
		// 										{
		// 											Name: to.Ptr("policy2"),
		// 											AttributeType: to.Ptr(armnetwork.VPNPolicyMemberAttributeTypeCertificateGroupID),
		// 											AttributeValue: to.Ptr("red.com"),
		// 									}},
		// 									Priority: to.Ptr[int32](0),
		// 									ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 								},
		// 						}},
		// 						ProvisioningState: to.Ptr("Succeeded"),
		// 						RadiusClientRootCertificates: []*armnetwork.VPNServerConfigRadiusClientRootCertificate{
		// 							{
		// 								Name: to.Ptr("vpnServerConfigRadiusClientRootCert1"),
		// 								Thumbprint: to.Ptr("83FFBFC8848B5A5836C94D0112367E16148A286F"),
		// 						}},
		// 						RadiusServerRootCertificates: []*armnetwork.VPNServerConfigRadiusServerRootCertificate{
		// 							{
		// 								Name: to.Ptr("vpnServerConfigRadiusServerRootCer1"),
		// 								PublicCertData: to.Ptr("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM"),
		// 						}},
		// 						RadiusServers: []*armnetwork.RadiusServer{
		// 							{
		// 								RadiusServerAddress: to.Ptr("10.0.0.0"),
		// 								RadiusServerScore: to.Ptr[int64](25),
		// 						}},
		// 						VPNAuthenticationTypes: []*armnetwork.VPNAuthenticationType{
		// 							to.Ptr(armnetwork.VPNAuthenticationTypeCertificate)},
		// 							VPNClientIPSecPolicies: []*armnetwork.IPSecPolicy{
		// 								{
		// 									DhGroup: to.Ptr(armnetwork.DhGroupDHGroup14),
		// 									IkeEncryption: to.Ptr(armnetwork.IkeEncryptionAES256),
		// 									IkeIntegrity: to.Ptr(armnetwork.IkeIntegritySHA384),
		// 									IPSecEncryption: to.Ptr(armnetwork.IPSecEncryptionAES256),
		// 									IPSecIntegrity: to.Ptr(armnetwork.IPSecIntegritySHA256),
		// 									PfsGroup: to.Ptr(armnetwork.PfsGroupPFS14),
		// 									SaDataSizeKilobytes: to.Ptr[int32](429497),
		// 									SaLifeTimeSeconds: to.Ptr[int32](86472),
		// 							}},
		// 							VPNClientRevokedCertificates: []*armnetwork.VPNServerConfigVPNClientRevokedCertificate{
		// 								{
		// 									Name: to.Ptr("vpnServerConfigVpnClientRevokedCert1"),
		// 									Thumbprint: to.Ptr("83FFBFC8848B5A5836C94D0112367E16148A286F"),
		// 							}},
		// 							VPNClientRootCertificates: []*armnetwork.VPNServerConfigVPNClientRootCertificate{
		// 								{
		// 									Name: to.Ptr("vpnServerConfigVpnClientRootCert1"),
		// 									PublicCertData: to.Ptr("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN"),
		// 							}},
		// 							VPNProtocols: []*armnetwork.VPNGatewayTunnelingProtocol{
		// 								to.Ptr(armnetwork.VPNGatewayTunnelingProtocolIkeV2)},
		// 							},
		// 					}},
		// 				}
	}
}
