/*
 * Decompiled with CFR 0.152.
 */
package eu.geekplace.jnr.linux;

import eu.geekplace.jnr.Linux$;
import eu.geekplace.jnr.time.Itimerspec;
import eu.geekplace.jnr.time.Itimerspec$;
import eu.geekplace.jnr.time.Timespec;
import eu.geekplace.jnr.time.Timespec$;
import java.time.Instant;
import java.time.OffsetDateTime;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.scala.Logging;
import org.apache.logging.log4j.spi.ExtendedLogger;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class RealtimeAlarm
implements AutoCloseable,
Logging {
    private ExtendedLogger logger;
    private final int timerfd;
    private boolean fdValid;

    public RealtimeAlarm() {
        Logging.$init$(this);
        int flags = Linux$.MODULE$.TFD_CLOEXEC() | Linux$.MODULE$.TFD_NONBLOCK();
        int clock = Linux$.MODULE$.CLOCK_REALTIME_ALARM();
        ExtendedLogger Logger_this = this.logger();
        if (Logger_this.isEnabled(Level.DEBUG)) {
            Logger_this.log(Level.DEBUG, "Creating timerfd with clock {} and flags {}".toString(), (Object[])Arrays$.MODULE$.seqToArray(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToInteger(clock), Integer.toBinaryString(flags)}), Object.class));
        }
        this.timerfd = Linux$.MODULE$.libc().timerfd_create(clock, flags);
        if (this.timerfd() < 0) {
            throw new Exception(new StringBuilder(29).append("Could not create timerfd: ").append(Linux$.MODULE$.getErrnoInfoString()).append(" (").append(this.timerfd()).append(")").toString());
        }
        ExtendedLogger Logger_this2 = this.logger();
        if (Logger_this2.isEnabled(Level.DEBUG)) {
            Logger_this2.log(Level.DEBUG, "Created timerfd {}".toString(), (Object)BoxesRunTime.boxToInteger(this.timerfd()));
        }
        this.fdValid = true;
        Statics.releaseFence();
    }

    @Override
    public ExtendedLogger logger() {
        return this.logger;
    }

    @Override
    public void org$apache$logging$log4j$scala$Logging$_setter_$logger_$eq(ExtendedLogger x$0) {
        this.logger = x$0;
    }

    public int timerfd() {
        return this.timerfd;
    }

    public boolean fdValid() {
        return this.fdValid;
    }

    public void fdValid_$eq(boolean x$1) {
        this.fdValid = x$1;
    }

    public boolean setAlarm(OffsetDateTime when) {
        return this.setAlarm(when.toInstant());
    }

    public boolean setAlarm(Instant when) {
        int res;
        if (!this.fdValid()) {
            throw new Exception("Timerfd was already closed");
        }
        Timespec alarmValue = Timespec$.MODULE$.apply(when);
        int flags = Linux$.MODULE$.TFD_TIMER_ABSTIME();
        Timespec alarmInterval = Timespec$.MODULE$.zero();
        Itimerspec itimerspec = Itimerspec$.MODULE$.apply(alarmInterval, alarmValue);
        ExtendedLogger Logger_this = this.logger();
        if (Logger_this.isEnabled(Level.DEBUG)) {
            Logger_this.log(Level.DEBUG, "Setting timerfd {} with flags {} to {} for {}".toString(), (Object[])Arrays$.MODULE$.seqToArray(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToInteger(this.timerfd()), BoxesRunTime.boxToInteger(flags), itimerspec, when}), Object.class));
        }
        if ((res = Linux$.MODULE$.libc().timerfd_settime(this.timerfd(), flags, itimerspec, null)) < 0) {
            throw new Exception(new StringBuilder(27).append("Failed to set timerfd ").append(this.timerfd()).append(": ").append(Linux$.MODULE$.getErrnoInfoString()).append(" (").append(res).append(")").toString());
        }
        return true;
    }

    public Itimerspec getAlarm() {
        Itimerspec itimerspec = Itimerspec$.MODULE$.apply(Itimerspec$.MODULE$.apply$default$1(), Itimerspec$.MODULE$.apply$default$2());
        int res = Linux$.MODULE$.libc().timerfd_gettime(this.timerfd(), itimerspec);
        if (res < 0) {
            throw new Exception(new StringBuilder(32).append("Failed to get timerfd ").append(this.timerfd()).append(" time: ").append(Linux$.MODULE$.getErrnoInfoString()).append(" (").append(res).append(")").toString());
        }
        return itimerspec;
    }

    @Override
    public void close() {
        if (this.fdValid()) {
            int res;
            this.fdValid_$eq(false);
            ExtendedLogger Logger_this = this.logger();
            if (Logger_this.isEnabled(Level.DEBUG)) {
                Logger_this.log(Level.DEBUG, "Closing timerfd {}".toString(), (Object)BoxesRunTime.boxToInteger(this.timerfd()));
            }
            if ((res = Linux$.MODULE$.posix().close(this.timerfd())) < 0) {
                throw new Exception(new StringBuilder(29).append("Failed to close timerfd ").append(this.timerfd()).append(": ").append(Linux$.MODULE$.getErrnoInfoString()).append(" (").append(res).append(")").toString());
            }
            return;
        }
    }
}

