/*
 * Decompiled with CFR 0.152.
 */
package eu.geekplace.sandmann;

import eu.geekplace.Time$;
import eu.geekplace.jnr.Linux$;
import eu.geekplace.sandmann.IdleCheck;
import eu.geekplace.sandmann.Logind$InhibitLockKind$;
import eu.geekplace.sandmann.Logind$SessionClass$;
import eu.geekplace.sandmann.Sandmann;
import java.io.Serializable;
import java.time.Instant;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.scala.Logger$;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.freedesktop.dbus.FileDescriptor;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.types.UInt64;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.login1.ListInhibitorsStruct;
import org.freedesktop.login1.ListSessionsStruct;
import org.freedesktop.login1.Manager;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.reflect.Enum;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0$mcV$sp;

public class Logind
extends IdleCheck
implements AutoCloseable {
    private final DBusConnection sessionConnection;
    private final Manager manager;
    private final scala.collection.mutable.Map<DelayableLock, FileDescriptor> inhibitors;
    private final scala.collection.mutable.Map<DelayableLock, AutoCloseable> signalHandles;

    public Logind(DBusConnection sessionConnection, Sandmann sandmann) {
        this.sessionConnection = sessionConnection;
        super(sandmann);
        this.manager = sessionConnection.getRemoteObject("org.freedesktop.login1", "/org/freedesktop/login1", Manager.class);
        this.inhibitors = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.signalHandles = (scala.collection.mutable.Map)Map$.MODULE$.empty();
    }

    public DBusConnection sessionConnection() {
        return this.sessionConnection;
    }

    private Sandmann sandmann$accessor() {
        return super.sandmann();
    }

    public Manager manager() {
        return this.manager;
    }

    public int getUserSessionCount() {
        return ((SeqOps)this.getSessionProperties().filter((Function1<Session, boolean> & Serializable)_$2 -> {
            SessionClass sessionClass = _$2.sessionClass();
            SessionClass sessionClass2 = Logind$SessionClass$.User;
            return !(sessionClass != null ? !sessionClass.equals(sessionClass2) : sessionClass2 != null);
        })).size();
    }

    public Buffer<Session> getSessionProperties() {
        Buffer<ListSessionsStruct> sessions = CollectionConverters$.MODULE$.ListHasAsScala(this.manager().ListSessions()).asScala();
        return (Buffer)((IterableOps)sessions.map((Function1<ListSessionsStruct, Tuple3> & Serializable)session -> {
            String busPath = session.getSessionObjectPath().toString();
            scala.collection.immutable.Map properties = CollectionConverters$.MODULE$.MapHasAsScala(this.sessionConnection().getRemoteObject("org.freedesktop.login1", busPath, Properties.class).GetAll("org.freedesktop.login1.Session")).asScala().toMap($less$colon$less$.MODULE$.refl());
            return Tuple3$.MODULE$.apply(session, busPath, properties);
        })).map((Function1<Tuple3, Session> & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                ListSessionsStruct session = (ListSessionsStruct)tuple3._1();
                String busPath = (String)tuple3._2();
                scala.collection.immutable.Map properties = (scala.collection.immutable.Map)tuple3._3();
                return new Session(session, properties);
            }
            throw new MatchError(tuple3);
        });
    }

    public System getSystemProperties() {
        scala.collection.immutable.Map<String, Variant<?>> properties = CollectionConverters$.MODULE$.MapHasAsScala(this.sessionConnection().getRemoteObject("org.freedesktop.login1", "/org/freedesktop/login1", Properties.class).GetAll("org.freedesktop.login1.Manager")).asScala().toMap($less$colon$less$.MODULE$.refl());
        return new System(properties);
    }

    public void suspendSystem() {
        this.manager().Suspend(false);
    }

    public void hibernateSystem() {
        this.manager().Hibernate(false);
    }

    public void suspendThenHibernateSystem() {
        this.manager().SuspendThenHibernate(false);
    }

    public void shutdownSystem() {
        this.manager().PowerOff(false);
    }

    public List<ListInhibitorsStruct> getBlockingInhibitors(InhibitLockKind kind) {
        return ((List)this.getInhibitors().filter((Function1<ListInhibitorsStruct, boolean> & Serializable)_$3 -> {
            String string2 = _$3.getMode();
            String string3 = "block";
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        })).filter((Function1<ListInhibitorsStruct, boolean> & Serializable)_$4 -> _$4.getWhat().contains(kind.name()));
    }

    public List<ListInhibitorsStruct> getInhibitors() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.manager().ListInhibitors()).asScala().toList();
    }

    @Override
    public Future<IdleCheck.Result> checkIdle(ExecutionContext ec) {
        return Future$.MODULE$.apply(this::checkIdle$$anonfun$1, ec);
    }

    public void addDelayAction(Function0<BoxedUnit> action, Function0<BoxedUnit> leaveAction, DelayableLock kind) {
        AutoCloseable autoCloseable;
        Class clazz;
        Function0<Option> & Serializable inhibitor = (Function0<Option> & Serializable)() -> this.inhibitors.get(kind);
        if (inhibitor.apply().isDefined()) {
            throw new Exception(new StringBuilder(25).append(kind.name()).append(" delay action already set").toString());
        }
        JFunction0$mcV$sp takeInhibitor = () -> {
            if (((Option)inhibitor.apply()).isEmpty()) {
                FileDescriptor fd = this.manager().Inhibit(kind.name(), "Sandmann", new StringBuilder(23).append("Perform actions before ").append(kind.name()).toString(), "delay");
                this.inhibitors.update(kind, fd);
                return;
            }
        };
        DelayableLock delayableLock = kind;
        InhibitLockKind inhibitLockKind = Logind$InhibitLockKind$.Sleep;
        DelayableLock delayableLock2 = delayableLock;
        if (!(inhibitLockKind != null ? !inhibitLockKind.equals(delayableLock2) : delayableLock2 != null)) {
            clazz = Manager.PrepareForSleep.class;
        } else {
            InhibitLockKind inhibitLockKind2 = Logind$InhibitLockKind$.Shutdown;
            DelayableLock delayableLock3 = delayableLock;
            if (!(inhibitLockKind2 != null ? !inhibitLockKind2.equals(delayableLock3) : delayableLock3 != null)) {
                clazz = Manager.PrepareForShutdown.class;
            } else {
                throw new MatchError(delayableLock);
            }
        }
        Class<Manager.PrepareForSleep> signalClass = clazz;
        DBusSigHandler<DBusSignal> signalHandler = prepare -> {
            boolean bl;
            DBusSignal dBusSignal = prepare;
            if (dBusSignal instanceof Manager.PrepareForSleep) {
                Manager.PrepareForSleep p = (Manager.PrepareForSleep)dBusSignal;
                bl = p.getStart();
            } else if (dBusSignal instanceof Manager.PrepareForShutdown) {
                Manager.PrepareForShutdown p = (Manager.PrepareForShutdown)dBusSignal;
                bl = p.getStart();
            } else {
                throw new MatchError(dBusSignal);
            }
            boolean start = bl;
            ExtendedLogger Logger_this = this.logger();
            if (Logger_this.isEnabled(Level.INFO)) {
                Logger_this.log(Level.INFO, "Received {} signal: start={}".toString(), (Object[])Arrays$.MODULE$.seqToArray(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{kind.name(), BoxesRunTime.boxToBoolean(start)}), Object.class));
            }
            if (start) {
                action.apply$mcV$sp();
                ((Option)inhibitor.apply()).map((Function1<FileDescriptor, int> & Serializable)_$8 -> _$8.getIntFileDescriptor()).map((Function1<Object, Option> & Serializable)fd -> this.$anonfun$6$$anonfun$2(kind, BoxesRunTime.unboxToInt(fd)));
                return;
            }
            takeInhibitor.apply$mcV$sp();
            leaveAction.apply$mcV$sp();
        };
        DelayableLock delayableLock4 = kind;
        InhibitLockKind inhibitLockKind3 = Logind$InhibitLockKind$.Sleep;
        DelayableLock delayableLock5 = delayableLock4;
        if (!(inhibitLockKind3 != null ? !inhibitLockKind3.equals(delayableLock5) : delayableLock5 != null)) {
            autoCloseable = this.sessionConnection().addSigHandler(Manager.PrepareForSleep.class, signalHandler);
        } else {
            InhibitLockKind inhibitLockKind4 = Logind$InhibitLockKind$.Shutdown;
            DelayableLock delayableLock6 = delayableLock4;
            if (!(inhibitLockKind4 != null ? !inhibitLockKind4.equals(delayableLock6) : delayableLock6 != null)) {
                autoCloseable = this.sessionConnection().addSigHandler(Manager.PrepareForShutdown.class, signalHandler);
            } else {
                throw new MatchError(delayableLock4);
            }
        }
        AutoCloseable signalHandle = autoCloseable;
        this.signalHandles.update(kind, signalHandle);
        takeInhibitor.apply$mcV$sp();
    }

    @Override
    public void close() {
        ((IterableOnceOps)this.inhibitors.values().map((Function1<FileDescriptor, int> & Serializable)_$9 -> _$9.getIntFileDescriptor())).foreach(fd -> {
            int res = Linux$.MODULE$.posix().close(fd);
            if (res < 0) {
                ExtendedLogger Logger_this = this.logger();
                if (Logger_this.isEnabled(Level.WARN)) {
                    Logger_this.log(Level.WARN, "Failed to close inhibitor fd: {} ({})".toString(), (Object[])Arrays$.MODULE$.seqToArray(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{Linux$.MODULE$.getErrnoInfoString(), BoxesRunTime.boxToInteger(res)}), Object.class));
                    return;
                }
                return;
            }
        });
        this.inhibitors.clear();
        this.signalHandles.values().foreach(_$10 -> _$10.close());
        this.signalHandles.clear();
    }

    private final IdleCheck.Result checkIdle$$anonfun$1() {
        IdleCheck.Result res;
        block6: {
            Buffer activeSessions;
            block8: {
                Tuple2 tuple2;
                Buffer<Session> sessions;
                block7: {
                    IdleCheck.Result result;
                    System system = this.getSystemProperties();
                    if (system.idleHint()) {
                        ExtendedLogger Logger_this = this.logger();
                        if (Logger_this.isEnabled(Level.DEBUG)) {
                            Logger_this.log(Level.DEBUG, "Logind reports system idle, returning Active\nSystem: {}".toString(), (Object)system);
                        }
                        result = new IdleCheck.IdleSince(system.idleSinceHint());
                    } else {
                        ExtendedLogger Logger_this = this.logger();
                        if (Logger_this.isEnabled(Level.DEBUG)) {
                            Logger_this.log(Level.DEBUG, "Logind reports system not idle, returning Active\nSystem: {}".toString(), (Object)system);
                        }
                        result = res = new IdleCheck.Active();
                    }
                    if (!this.debug()) break block6;
                    sessions = this.getSessionProperties();
                    if (!sessions.isEmpty()) break block7;
                    ExtendedLogger Logger_this = this.logger();
                    if (!Logger_this.isEnabled(Level.DEBUG)) break block6;
                    Logger$.MODULE$.logMessage$extension(Logger_this, Level.DEBUG, null, "Logind reports no user sessions".toString(), null);
                    break block6;
                }
                ExtendedLogger Logger_this = this.logger();
                if (Logger_this.isEnabled(Level.DEBUG)) {
                    Logger_this.log(Level.DEBUG, "Logind reports the following sessions: {}".toString(), (Object)sessions.mkString("\n- "));
                }
                if ((tuple2 = ((IterableOps)sessions.filter((Function1<Session, boolean> & Serializable)_$5 -> _$5.sessionClass().canIdle())).partition((Function1<Session, boolean> & Serializable)_$6 -> _$6.idleHint())) == null) {
                    throw new MatchError(tuple2);
                }
                Buffer idleSessions = (Buffer)tuple2._1();
                Buffer activeSessions2 = (Buffer)tuple2._2();
                Tuple2<Buffer, Buffer> tuple22 = Tuple2$.MODULE$.apply(idleSessions, activeSessions2);
                Buffer idleSessions2 = tuple22._1();
                activeSessions = tuple22._2();
                if (!activeSessions.isEmpty()) break block8;
                Session youngestIdleSession = (Session)((IterableOps)((SeqOps)idleSessions2.sortBy((Function1<Session, Instant> & Serializable)_$7 -> _$7.idleSinceHint(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).reverse()).head();
                ExtendedLogger Logger_this2 = this.logger();
                if (!Logger_this2.isEnabled(Level.DEBUG)) break block6;
                Logger_this2.log(Level.DEBUG, "Logind reports no active sessions, returning IdleSince.\nYoungest idle session: {}".toString(), (Object)youngestIdleSession);
                break block6;
            }
            ExtendedLogger Logger_this = this.logger();
            if (!Logger_this.isEnabled(Level.DEBUG)) break block6;
            Logger_this.log(Level.DEBUG, "Logind reports active sessions, returning Active\nActive sessions: {}".toString(), (Object)activeSessions.mkString("\n -"));
        }
        return res;
    }

    private final /* synthetic */ Option $anonfun$6$$anonfun$2(DelayableLock kind$5, int fd) {
        block0: {
            ExtendedLogger Logger_this;
            int res = Linux$.MODULE$.posix().close(fd);
            if (res >= 0 || !(Logger_this = this.logger()).isEnabled(Level.WARN)) break block0;
            Logger_this.log(Level.WARN, "Failed to close inhibitor fd {}: {} ({})".toString(), (Object[])Arrays$.MODULE$.seqToArray(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToInteger(fd), Linux$.MODULE$.getErrnoInfoString(), BoxesRunTime.boxToInteger(res)}), Object.class));
        }
        return this.inhibitors.remove(kind$5);
    }

    public static interface DelayableLock {
        public String name();
    }

    public static class Idleable {
        private final Map<String, Variant<?>> properties;
        private final boolean idleHint;
        private final Instant idleSinceHint;

        public Idleable(Map<String, Variant<?>> properties) {
            this.properties = properties;
            this.idleHint = BoxesRunTime.unboxToBoolean(((Variant)properties.apply("IdleHint")).getValue());
            long idleSinceHintUsecs = ((UInt64)((Variant)properties.apply("IdleSinceHint")).getValue()).value().longValueExact();
            this.idleSinceHint = Time$.MODULE$.realtimeUsecsToInstant(idleSinceHintUsecs);
        }

        public Map<String, Variant<?>> properties() {
            return this.properties;
        }

        public boolean idleHint() {
            return this.idleHint;
        }

        public Instant idleSinceHint() {
            return this.idleSinceHint;
        }
    }

    public static abstract class InhibitLockKind
    implements Product,
    Enum {
        private final String name;

        public static InhibitLockKind fromOrdinal(int n) {
            return Logind$InhibitLockKind$.MODULE$.fromOrdinal(n);
        }

        public static InhibitLockKind valueOf(String string2) {
            return Logind$InhibitLockKind$.MODULE$.valueOf(string2);
        }

        public static InhibitLockKind[] values() {
            return Logind$InhibitLockKind$.MODULE$.values();
        }

        public InhibitLockKind() {
            this.name = name;
        }

        public String name() {
            return this.name;
        }
    }

    public static class Session
    extends Idleable {
        private final ListSessionsStruct session;
        private final SessionClass sessionClass;

        public Session(ListSessionsStruct session, Map<String, Variant<?>> properties) {
            this.session = session;
            super(properties);
            String classString = (String)((Variant)properties.apply("Class")).getValue();
            this.sessionClass = Logind$SessionClass$.MODULE$.apply(classString);
        }

        private Map<String, Variant<?>> properties$accessor() {
            return super.properties();
        }

        public SessionClass sessionClass() {
            return this.sessionClass;
        }

        public String toString() {
            return new StringBuilder(15).append(this.session.getSessionId()).append(" u:").append(this.session.getUserName()).append(" s:").append(this.session.getSeatId()).append(" i:").append(this.idleHint()).append(" (").append(this.idleSinceHint()).append(") p:").append(this.properties$accessor()).toString();
        }
    }

    public static abstract class SessionClass
    implements Product,
    Enum {
        private final String name;
        private final boolean canIdle;

        public static SessionClass apply(String string2) {
            return Logind$SessionClass$.MODULE$.apply(string2);
        }

        public static SessionClass fromOrdinal(int n) {
            return Logind$SessionClass$.MODULE$.fromOrdinal(n);
        }

        public static scala.collection.immutable.Map<String, SessionClass> map() {
            return Logind$SessionClass$.MODULE$.map();
        }

        public static SessionClass valueOf(String string2) {
            return Logind$SessionClass$.MODULE$.valueOf(string2);
        }

        public static SessionClass[] values() {
            return Logind$SessionClass$.MODULE$.values();
        }

        public static boolean $lessinit$greater$default$2() {
            return Logind$SessionClass$.MODULE$.$lessinit$greater$default$2();
        }

        public SessionClass() {
            this.name = name;
            this.canIdle = canIdle;
        }

        public String name() {
            return this.name;
        }

        public boolean canIdle() {
            return this.canIdle;
        }
    }

    public static class System
    extends Idleable {
        public System(Map<String, Variant<?>> properties) {
            super(properties);
        }

        private Map<String, Variant<?>> properties$accessor() {
            return super.properties();
        }

        public String toString() {
            return new StringBuilder(15).append("System i:").append(this.idleHint()).append(" (").append(this.idleSinceHint()).append(") p:").append(this.properties$accessor()).toString();
        }
    }
}

