// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/osconfig/v1beta/patch_deployments.proto

package osconfig

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	datetime "google.golang.org/genproto/googleapis/type/datetime"
	dayofweek "google.golang.org/genproto/googleapis/type/dayofweek"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Specifies the frequency of the recurring patch deployments.
type RecurringSchedule_Frequency int32

const (
	// Invalid. A frequency must be specified.
	RecurringSchedule_FREQUENCY_UNSPECIFIED RecurringSchedule_Frequency = 0
	// Indicates that the frequency should be expressed in terms of
	// weeks.
	RecurringSchedule_WEEKLY RecurringSchedule_Frequency = 1
	// Indicates that the frequency should be expressed in terms of
	// months.
	RecurringSchedule_MONTHLY RecurringSchedule_Frequency = 2
)

var RecurringSchedule_Frequency_name = map[int32]string{
	0: "FREQUENCY_UNSPECIFIED",
	1: "WEEKLY",
	2: "MONTHLY",
}

var RecurringSchedule_Frequency_value = map[string]int32{
	"FREQUENCY_UNSPECIFIED": 0,
	"WEEKLY":                1,
	"MONTHLY":               2,
}

func (x RecurringSchedule_Frequency) String() string {
	return proto.EnumName(RecurringSchedule_Frequency_name, int32(x))
}

func (RecurringSchedule_Frequency) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_71fcfd7bb7d29e80, []int{2, 0}
}

// Patch deployments are configurations that individual patch jobs use to
// complete a patch. These configurations include instance filter, package
// repository settings, and a schedule. For more information about creating and
// managing patch deployments, see [Scheduling patch
// jobs](/compute/docs/os-patch-management/schedule-patch-jobs).
type PatchDeployment struct {
	// Unique name for the patch deployment resource in a project. The patch
	// deployment name is in the form:
	// `projects/{project_id}/patchDeployments/{patch_deployment_id}`.
	// This field is ignored when you create a new patch deployment.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Description of the patch deployment. Length of the description is limited
	// to 1024 characters.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Required. VM instances to patch.
	InstanceFilter *PatchInstanceFilter `protobuf:"bytes,3,opt,name=instance_filter,json=instanceFilter,proto3" json:"instance_filter,omitempty"`
	// Optional. Patch configuration that is applied.
	PatchConfig *PatchConfig `protobuf:"bytes,4,opt,name=patch_config,json=patchConfig,proto3" json:"patch_config,omitempty"`
	// Optional. Duration of the patch. After the duration ends, the patch times out.
	Duration *duration.Duration `protobuf:"bytes,5,opt,name=duration,proto3" json:"duration,omitempty"`
	// Schedule for the patch.
	//
	// Types that are valid to be assigned to Schedule:
	//	*PatchDeployment_OneTimeSchedule
	//	*PatchDeployment_RecurringSchedule
	Schedule isPatchDeployment_Schedule `protobuf_oneof:"schedule"`
	// Output only. Time the patch deployment was created. Timestamp is in
	// <a href="https://www.ietf.org/rfc/rfc3339.txt" target="_blank">RFC3339</a>
	// text format.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time the patch deployment was last updated. Timestamp is in
	// <a href="https://www.ietf.org/rfc/rfc3339.txt" target="_blank">RFC3339</a>
	// text format.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The last time a patch job was started by this deployment.
	// Timestamp is in
	// <a href="https://www.ietf.org/rfc/rfc3339.txt" target="_blank">RFC3339</a>
	// text format.
	LastExecuteTime      *timestamp.Timestamp `protobuf:"bytes,10,opt,name=last_execute_time,json=lastExecuteTime,proto3" json:"last_execute_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PatchDeployment) Reset()         { *m = PatchDeployment{} }
func (m *PatchDeployment) String() string { return proto.CompactTextString(m) }
func (*PatchDeployment) ProtoMessage()    {}
func (*PatchDeployment) Descriptor() ([]byte, []int) {
	return fileDescriptor_71fcfd7bb7d29e80, []int{0}
}

func (m *PatchDeployment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PatchDeployment.Unmarshal(m, b)
}
func (m *PatchDeployment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PatchDeployment.Marshal(b, m, deterministic)
}
func (m *PatchDeployment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PatchDeployment.Merge(m, src)
}
func (m *PatchDeployment) XXX_Size() int {
	return xxx_messageInfo_PatchDeployment.Size(m)
}
func (m *PatchDeployment) XXX_DiscardUnknown() {
	xxx_messageInfo_PatchDeployment.DiscardUnknown(m)
}

var xxx_messageInfo_PatchDeployment proto.InternalMessageInfo

func (m *PatchDeployment) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PatchDeployment) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *PatchDeployment) GetInstanceFilter() *PatchInstanceFilter {
	if m != nil {
		return m.InstanceFilter
	}
	return nil
}

func (m *PatchDeployment) GetPatchConfig() *PatchConfig {
	if m != nil {
		return m.PatchConfig
	}
	return nil
}

func (m *PatchDeployment) GetDuration() *duration.Duration {
	if m != nil {
		return m.Duration
	}
	return nil
}

type isPatchDeployment_Schedule interface {
	isPatchDeployment_Schedule()
}

type PatchDeployment_OneTimeSchedule struct {
	OneTimeSchedule *OneTimeSchedule `protobuf:"bytes,6,opt,name=one_time_schedule,json=oneTimeSchedule,proto3,oneof"`
}

type PatchDeployment_RecurringSchedule struct {
	RecurringSchedule *RecurringSchedule `protobuf:"bytes,7,opt,name=recurring_schedule,json=recurringSchedule,proto3,oneof"`
}

func (*PatchDeployment_OneTimeSchedule) isPatchDeployment_Schedule() {}

func (*PatchDeployment_RecurringSchedule) isPatchDeployment_Schedule() {}

func (m *PatchDeployment) GetSchedule() isPatchDeployment_Schedule {
	if m != nil {
		return m.Schedule
	}
	return nil
}

func (m *PatchDeployment) GetOneTimeSchedule() *OneTimeSchedule {
	if x, ok := m.GetSchedule().(*PatchDeployment_OneTimeSchedule); ok {
		return x.OneTimeSchedule
	}
	return nil
}

func (m *PatchDeployment) GetRecurringSchedule() *RecurringSchedule {
	if x, ok := m.GetSchedule().(*PatchDeployment_RecurringSchedule); ok {
		return x.RecurringSchedule
	}
	return nil
}

func (m *PatchDeployment) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *PatchDeployment) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *PatchDeployment) GetLastExecuteTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastExecuteTime
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PatchDeployment) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PatchDeployment_OneTimeSchedule)(nil),
		(*PatchDeployment_RecurringSchedule)(nil),
	}
}

// Sets the time for a one time patch deployment. Timestamp is in
// <a href="https://www.ietf.org/rfc/rfc3339.txt" target="_blank">RFC3339</a>
// text format.
type OneTimeSchedule struct {
	// Required. The desired patch job execution time.
	ExecuteTime          *timestamp.Timestamp `protobuf:"bytes,1,opt,name=execute_time,json=executeTime,proto3" json:"execute_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *OneTimeSchedule) Reset()         { *m = OneTimeSchedule{} }
func (m *OneTimeSchedule) String() string { return proto.CompactTextString(m) }
func (*OneTimeSchedule) ProtoMessage()    {}
func (*OneTimeSchedule) Descriptor() ([]byte, []int) {
	return fileDescriptor_71fcfd7bb7d29e80, []int{1}
}

func (m *OneTimeSchedule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OneTimeSchedule.Unmarshal(m, b)
}
func (m *OneTimeSchedule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OneTimeSchedule.Marshal(b, m, deterministic)
}
func (m *OneTimeSchedule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OneTimeSchedule.Merge(m, src)
}
func (m *OneTimeSchedule) XXX_Size() int {
	return xxx_messageInfo_OneTimeSchedule.Size(m)
}
func (m *OneTimeSchedule) XXX_DiscardUnknown() {
	xxx_messageInfo_OneTimeSchedule.DiscardUnknown(m)
}

var xxx_messageInfo_OneTimeSchedule proto.InternalMessageInfo

func (m *OneTimeSchedule) GetExecuteTime() *timestamp.Timestamp {
	if m != nil {
		return m.ExecuteTime
	}
	return nil
}

// Sets the time for recurring patch deployments.
type RecurringSchedule struct {
	// Required. Defines the time zone that `time_of_day` is relative to.
	// The rules for daylight saving time are determined by the chosen time zone.
	TimeZone *datetime.TimeZone `protobuf:"bytes,1,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// Optional. The time that the recurring schedule becomes effective.
	// Defaults to `create_time` of the patch deployment.
	StartTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Optional. The end time at which a recurring patch deployment schedule is no longer
	// active.
	EndTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Required. Time of the day to run a recurring deployment.
	TimeOfDay *timeofday.TimeOfDay `protobuf:"bytes,4,opt,name=time_of_day,json=timeOfDay,proto3" json:"time_of_day,omitempty"`
	// Required. The frequency unit of this recurring schedule.
	Frequency RecurringSchedule_Frequency `protobuf:"varint,5,opt,name=frequency,proto3,enum=google.cloud.osconfig.v1beta.RecurringSchedule_Frequency" json:"frequency,omitempty"`
	// Configurations for this recurring schedule.
	// Configurations must match frequency.
	//
	// Types that are valid to be assigned to ScheduleConfig:
	//	*RecurringSchedule_Weekly
	//	*RecurringSchedule_Monthly
	ScheduleConfig isRecurringSchedule_ScheduleConfig `protobuf_oneof:"schedule_config"`
	// Output only. The time the last patch job ran successfully.
	LastExecuteTime *timestamp.Timestamp `protobuf:"bytes,9,opt,name=last_execute_time,json=lastExecuteTime,proto3" json:"last_execute_time,omitempty"`
	// Output only. The time the next patch job is scheduled to run.
	NextExecuteTime      *timestamp.Timestamp `protobuf:"bytes,10,opt,name=next_execute_time,json=nextExecuteTime,proto3" json:"next_execute_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *RecurringSchedule) Reset()         { *m = RecurringSchedule{} }
func (m *RecurringSchedule) String() string { return proto.CompactTextString(m) }
func (*RecurringSchedule) ProtoMessage()    {}
func (*RecurringSchedule) Descriptor() ([]byte, []int) {
	return fileDescriptor_71fcfd7bb7d29e80, []int{2}
}

func (m *RecurringSchedule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RecurringSchedule.Unmarshal(m, b)
}
func (m *RecurringSchedule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RecurringSchedule.Marshal(b, m, deterministic)
}
func (m *RecurringSchedule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecurringSchedule.Merge(m, src)
}
func (m *RecurringSchedule) XXX_Size() int {
	return xxx_messageInfo_RecurringSchedule.Size(m)
}
func (m *RecurringSchedule) XXX_DiscardUnknown() {
	xxx_messageInfo_RecurringSchedule.DiscardUnknown(m)
}

var xxx_messageInfo_RecurringSchedule proto.InternalMessageInfo

func (m *RecurringSchedule) GetTimeZone() *datetime.TimeZone {
	if m != nil {
		return m.TimeZone
	}
	return nil
}

func (m *RecurringSchedule) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *RecurringSchedule) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *RecurringSchedule) GetTimeOfDay() *timeofday.TimeOfDay {
	if m != nil {
		return m.TimeOfDay
	}
	return nil
}

func (m *RecurringSchedule) GetFrequency() RecurringSchedule_Frequency {
	if m != nil {
		return m.Frequency
	}
	return RecurringSchedule_FREQUENCY_UNSPECIFIED
}

type isRecurringSchedule_ScheduleConfig interface {
	isRecurringSchedule_ScheduleConfig()
}

type RecurringSchedule_Weekly struct {
	Weekly *WeeklySchedule `protobuf:"bytes,6,opt,name=weekly,proto3,oneof"`
}

type RecurringSchedule_Monthly struct {
	Monthly *MonthlySchedule `protobuf:"bytes,7,opt,name=monthly,proto3,oneof"`
}

func (*RecurringSchedule_Weekly) isRecurringSchedule_ScheduleConfig() {}

func (*RecurringSchedule_Monthly) isRecurringSchedule_ScheduleConfig() {}

func (m *RecurringSchedule) GetScheduleConfig() isRecurringSchedule_ScheduleConfig {
	if m != nil {
		return m.ScheduleConfig
	}
	return nil
}

func (m *RecurringSchedule) GetWeekly() *WeeklySchedule {
	if x, ok := m.GetScheduleConfig().(*RecurringSchedule_Weekly); ok {
		return x.Weekly
	}
	return nil
}

func (m *RecurringSchedule) GetMonthly() *MonthlySchedule {
	if x, ok := m.GetScheduleConfig().(*RecurringSchedule_Monthly); ok {
		return x.Monthly
	}
	return nil
}

func (m *RecurringSchedule) GetLastExecuteTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastExecuteTime
	}
	return nil
}

func (m *RecurringSchedule) GetNextExecuteTime() *timestamp.Timestamp {
	if m != nil {
		return m.NextExecuteTime
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*RecurringSchedule) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*RecurringSchedule_Weekly)(nil),
		(*RecurringSchedule_Monthly)(nil),
	}
}

// Represents a weekly schedule.
type WeeklySchedule struct {
	// Required. Day of the week.
	DayOfWeek            dayofweek.DayOfWeek `protobuf:"varint,1,opt,name=day_of_week,json=dayOfWeek,proto3,enum=google.type.DayOfWeek" json:"day_of_week,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *WeeklySchedule) Reset()         { *m = WeeklySchedule{} }
func (m *WeeklySchedule) String() string { return proto.CompactTextString(m) }
func (*WeeklySchedule) ProtoMessage()    {}
func (*WeeklySchedule) Descriptor() ([]byte, []int) {
	return fileDescriptor_71fcfd7bb7d29e80, []int{3}
}

func (m *WeeklySchedule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WeeklySchedule.Unmarshal(m, b)
}
func (m *WeeklySchedule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WeeklySchedule.Marshal(b, m, deterministic)
}
func (m *WeeklySchedule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WeeklySchedule.Merge(m, src)
}
func (m *WeeklySchedule) XXX_Size() int {
	return xxx_messageInfo_WeeklySchedule.Size(m)
}
func (m *WeeklySchedule) XXX_DiscardUnknown() {
	xxx_messageInfo_WeeklySchedule.DiscardUnknown(m)
}

var xxx_messageInfo_WeeklySchedule proto.InternalMessageInfo

func (m *WeeklySchedule) GetDayOfWeek() dayofweek.DayOfWeek {
	if m != nil {
		return m.DayOfWeek
	}
	return dayofweek.DayOfWeek_DAY_OF_WEEK_UNSPECIFIED
}

// Represents a monthly schedule. An example of a valid monthly schedule is
// "on the third Tuesday of the month" or "on the 15th of the month".
type MonthlySchedule struct {
	// One day in a month.
	//
	// Types that are valid to be assigned to DayOfMonth:
	//	*MonthlySchedule_WeekDayOfMonth
	//	*MonthlySchedule_MonthDay
	DayOfMonth           isMonthlySchedule_DayOfMonth `protobuf_oneof:"day_of_month"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *MonthlySchedule) Reset()         { *m = MonthlySchedule{} }
func (m *MonthlySchedule) String() string { return proto.CompactTextString(m) }
func (*MonthlySchedule) ProtoMessage()    {}
func (*MonthlySchedule) Descriptor() ([]byte, []int) {
	return fileDescriptor_71fcfd7bb7d29e80, []int{4}
}

func (m *MonthlySchedule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MonthlySchedule.Unmarshal(m, b)
}
func (m *MonthlySchedule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MonthlySchedule.Marshal(b, m, deterministic)
}
func (m *MonthlySchedule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MonthlySchedule.Merge(m, src)
}
func (m *MonthlySchedule) XXX_Size() int {
	return xxx_messageInfo_MonthlySchedule.Size(m)
}
func (m *MonthlySchedule) XXX_DiscardUnknown() {
	xxx_messageInfo_MonthlySchedule.DiscardUnknown(m)
}

var xxx_messageInfo_MonthlySchedule proto.InternalMessageInfo

type isMonthlySchedule_DayOfMonth interface {
	isMonthlySchedule_DayOfMonth()
}

type MonthlySchedule_WeekDayOfMonth struct {
	WeekDayOfMonth *WeekDayOfMonth `protobuf:"bytes,1,opt,name=week_day_of_month,json=weekDayOfMonth,proto3,oneof"`
}

type MonthlySchedule_MonthDay struct {
	MonthDay int32 `protobuf:"varint,2,opt,name=month_day,json=monthDay,proto3,oneof"`
}

func (*MonthlySchedule_WeekDayOfMonth) isMonthlySchedule_DayOfMonth() {}

func (*MonthlySchedule_MonthDay) isMonthlySchedule_DayOfMonth() {}

func (m *MonthlySchedule) GetDayOfMonth() isMonthlySchedule_DayOfMonth {
	if m != nil {
		return m.DayOfMonth
	}
	return nil
}

func (m *MonthlySchedule) GetWeekDayOfMonth() *WeekDayOfMonth {
	if x, ok := m.GetDayOfMonth().(*MonthlySchedule_WeekDayOfMonth); ok {
		return x.WeekDayOfMonth
	}
	return nil
}

func (m *MonthlySchedule) GetMonthDay() int32 {
	if x, ok := m.GetDayOfMonth().(*MonthlySchedule_MonthDay); ok {
		return x.MonthDay
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*MonthlySchedule) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*MonthlySchedule_WeekDayOfMonth)(nil),
		(*MonthlySchedule_MonthDay)(nil),
	}
}

// Represents one week day in a month. An example is "the 4th Sunday".
type WeekDayOfMonth struct {
	// Required. Week number in a month. 1-4 indicates the 1st to 4th week of the month. -1
	// indicates the last week of the month.
	WeekOrdinal int32 `protobuf:"varint,1,opt,name=week_ordinal,json=weekOrdinal,proto3" json:"week_ordinal,omitempty"`
	// Required. A day of the week.
	DayOfWeek            dayofweek.DayOfWeek `protobuf:"varint,2,opt,name=day_of_week,json=dayOfWeek,proto3,enum=google.type.DayOfWeek" json:"day_of_week,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *WeekDayOfMonth) Reset()         { *m = WeekDayOfMonth{} }
func (m *WeekDayOfMonth) String() string { return proto.CompactTextString(m) }
func (*WeekDayOfMonth) ProtoMessage()    {}
func (*WeekDayOfMonth) Descriptor() ([]byte, []int) {
	return fileDescriptor_71fcfd7bb7d29e80, []int{5}
}

func (m *WeekDayOfMonth) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WeekDayOfMonth.Unmarshal(m, b)
}
func (m *WeekDayOfMonth) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WeekDayOfMonth.Marshal(b, m, deterministic)
}
func (m *WeekDayOfMonth) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WeekDayOfMonth.Merge(m, src)
}
func (m *WeekDayOfMonth) XXX_Size() int {
	return xxx_messageInfo_WeekDayOfMonth.Size(m)
}
func (m *WeekDayOfMonth) XXX_DiscardUnknown() {
	xxx_messageInfo_WeekDayOfMonth.DiscardUnknown(m)
}

var xxx_messageInfo_WeekDayOfMonth proto.InternalMessageInfo

func (m *WeekDayOfMonth) GetWeekOrdinal() int32 {
	if m != nil {
		return m.WeekOrdinal
	}
	return 0
}

func (m *WeekDayOfMonth) GetDayOfWeek() dayofweek.DayOfWeek {
	if m != nil {
		return m.DayOfWeek
	}
	return dayofweek.DayOfWeek_DAY_OF_WEEK_UNSPECIFIED
}

// A request message for creating a patch deployment.
type CreatePatchDeploymentRequest struct {
	// Required. The project to apply this patch deployment to in the form `projects/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. A name for the patch deployment in the project. When creating a name
	// the following rules apply:
	// * Must contain only lowercase letters, numbers, and hyphens.
	// * Must start with a letter.
	// * Must be between 1-63 characters.
	// * Must end with a number or a letter.
	// * Must be unique within the project.
	PatchDeploymentId string `protobuf:"bytes,2,opt,name=patch_deployment_id,json=patchDeploymentId,proto3" json:"patch_deployment_id,omitempty"`
	// Required. The patch deployment to create.
	PatchDeployment      *PatchDeployment `protobuf:"bytes,3,opt,name=patch_deployment,json=patchDeployment,proto3" json:"patch_deployment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *CreatePatchDeploymentRequest) Reset()         { *m = CreatePatchDeploymentRequest{} }
func (m *CreatePatchDeploymentRequest) String() string { return proto.CompactTextString(m) }
func (*CreatePatchDeploymentRequest) ProtoMessage()    {}
func (*CreatePatchDeploymentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_71fcfd7bb7d29e80, []int{6}
}

func (m *CreatePatchDeploymentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreatePatchDeploymentRequest.Unmarshal(m, b)
}
func (m *CreatePatchDeploymentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreatePatchDeploymentRequest.Marshal(b, m, deterministic)
}
func (m *CreatePatchDeploymentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreatePatchDeploymentRequest.Merge(m, src)
}
func (m *CreatePatchDeploymentRequest) XXX_Size() int {
	return xxx_messageInfo_CreatePatchDeploymentRequest.Size(m)
}
func (m *CreatePatchDeploymentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreatePatchDeploymentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreatePatchDeploymentRequest proto.InternalMessageInfo

func (m *CreatePatchDeploymentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreatePatchDeploymentRequest) GetPatchDeploymentId() string {
	if m != nil {
		return m.PatchDeploymentId
	}
	return ""
}

func (m *CreatePatchDeploymentRequest) GetPatchDeployment() *PatchDeployment {
	if m != nil {
		return m.PatchDeployment
	}
	return nil
}

// A request message for retrieving a patch deployment.
type GetPatchDeploymentRequest struct {
	// Required. The resource name of the patch deployment in the form
	// `projects/*/patchDeployments/*`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetPatchDeploymentRequest) Reset()         { *m = GetPatchDeploymentRequest{} }
func (m *GetPatchDeploymentRequest) String() string { return proto.CompactTextString(m) }
func (*GetPatchDeploymentRequest) ProtoMessage()    {}
func (*GetPatchDeploymentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_71fcfd7bb7d29e80, []int{7}
}

func (m *GetPatchDeploymentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetPatchDeploymentRequest.Unmarshal(m, b)
}
func (m *GetPatchDeploymentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetPatchDeploymentRequest.Marshal(b, m, deterministic)
}
func (m *GetPatchDeploymentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetPatchDeploymentRequest.Merge(m, src)
}
func (m *GetPatchDeploymentRequest) XXX_Size() int {
	return xxx_messageInfo_GetPatchDeploymentRequest.Size(m)
}
func (m *GetPatchDeploymentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetPatchDeploymentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetPatchDeploymentRequest proto.InternalMessageInfo

func (m *GetPatchDeploymentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request message for listing patch deployments.
type ListPatchDeploymentsRequest struct {
	// Required. The resource name of the parent in the form `projects/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of patch deployments to return. Default is 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A pagination token returned from a previous call to ListPatchDeployments
	// that indicates where this listing should continue from.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListPatchDeploymentsRequest) Reset()         { *m = ListPatchDeploymentsRequest{} }
func (m *ListPatchDeploymentsRequest) String() string { return proto.CompactTextString(m) }
func (*ListPatchDeploymentsRequest) ProtoMessage()    {}
func (*ListPatchDeploymentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_71fcfd7bb7d29e80, []int{8}
}

func (m *ListPatchDeploymentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPatchDeploymentsRequest.Unmarshal(m, b)
}
func (m *ListPatchDeploymentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPatchDeploymentsRequest.Marshal(b, m, deterministic)
}
func (m *ListPatchDeploymentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPatchDeploymentsRequest.Merge(m, src)
}
func (m *ListPatchDeploymentsRequest) XXX_Size() int {
	return xxx_messageInfo_ListPatchDeploymentsRequest.Size(m)
}
func (m *ListPatchDeploymentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPatchDeploymentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListPatchDeploymentsRequest proto.InternalMessageInfo

func (m *ListPatchDeploymentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListPatchDeploymentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListPatchDeploymentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// A response message for listing patch deployments.
type ListPatchDeploymentsResponse struct {
	// The list of patch deployments.
	PatchDeployments []*PatchDeployment `protobuf:"bytes,1,rep,name=patch_deployments,json=patchDeployments,proto3" json:"patch_deployments,omitempty"`
	// A pagination token that can be used to get the next page of patch
	// deployments.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListPatchDeploymentsResponse) Reset()         { *m = ListPatchDeploymentsResponse{} }
func (m *ListPatchDeploymentsResponse) String() string { return proto.CompactTextString(m) }
func (*ListPatchDeploymentsResponse) ProtoMessage()    {}
func (*ListPatchDeploymentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_71fcfd7bb7d29e80, []int{9}
}

func (m *ListPatchDeploymentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPatchDeploymentsResponse.Unmarshal(m, b)
}
func (m *ListPatchDeploymentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPatchDeploymentsResponse.Marshal(b, m, deterministic)
}
func (m *ListPatchDeploymentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPatchDeploymentsResponse.Merge(m, src)
}
func (m *ListPatchDeploymentsResponse) XXX_Size() int {
	return xxx_messageInfo_ListPatchDeploymentsResponse.Size(m)
}
func (m *ListPatchDeploymentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPatchDeploymentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListPatchDeploymentsResponse proto.InternalMessageInfo

func (m *ListPatchDeploymentsResponse) GetPatchDeployments() []*PatchDeployment {
	if m != nil {
		return m.PatchDeployments
	}
	return nil
}

func (m *ListPatchDeploymentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request message for deleting a patch deployment.
type DeletePatchDeploymentRequest struct {
	// Required. The resource name of the patch deployment in the form
	// `projects/*/patchDeployments/*`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeletePatchDeploymentRequest) Reset()         { *m = DeletePatchDeploymentRequest{} }
func (m *DeletePatchDeploymentRequest) String() string { return proto.CompactTextString(m) }
func (*DeletePatchDeploymentRequest) ProtoMessage()    {}
func (*DeletePatchDeploymentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_71fcfd7bb7d29e80, []int{10}
}

func (m *DeletePatchDeploymentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeletePatchDeploymentRequest.Unmarshal(m, b)
}
func (m *DeletePatchDeploymentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeletePatchDeploymentRequest.Marshal(b, m, deterministic)
}
func (m *DeletePatchDeploymentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeletePatchDeploymentRequest.Merge(m, src)
}
func (m *DeletePatchDeploymentRequest) XXX_Size() int {
	return xxx_messageInfo_DeletePatchDeploymentRequest.Size(m)
}
func (m *DeletePatchDeploymentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeletePatchDeploymentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeletePatchDeploymentRequest proto.InternalMessageInfo

func (m *DeletePatchDeploymentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.osconfig.v1beta.RecurringSchedule_Frequency", RecurringSchedule_Frequency_name, RecurringSchedule_Frequency_value)
	proto.RegisterType((*PatchDeployment)(nil), "google.cloud.osconfig.v1beta.PatchDeployment")
	proto.RegisterType((*OneTimeSchedule)(nil), "google.cloud.osconfig.v1beta.OneTimeSchedule")
	proto.RegisterType((*RecurringSchedule)(nil), "google.cloud.osconfig.v1beta.RecurringSchedule")
	proto.RegisterType((*WeeklySchedule)(nil), "google.cloud.osconfig.v1beta.WeeklySchedule")
	proto.RegisterType((*MonthlySchedule)(nil), "google.cloud.osconfig.v1beta.MonthlySchedule")
	proto.RegisterType((*WeekDayOfMonth)(nil), "google.cloud.osconfig.v1beta.WeekDayOfMonth")
	proto.RegisterType((*CreatePatchDeploymentRequest)(nil), "google.cloud.osconfig.v1beta.CreatePatchDeploymentRequest")
	proto.RegisterType((*GetPatchDeploymentRequest)(nil), "google.cloud.osconfig.v1beta.GetPatchDeploymentRequest")
	proto.RegisterType((*ListPatchDeploymentsRequest)(nil), "google.cloud.osconfig.v1beta.ListPatchDeploymentsRequest")
	proto.RegisterType((*ListPatchDeploymentsResponse)(nil), "google.cloud.osconfig.v1beta.ListPatchDeploymentsResponse")
	proto.RegisterType((*DeletePatchDeploymentRequest)(nil), "google.cloud.osconfig.v1beta.DeletePatchDeploymentRequest")
}

func init() {
	proto.RegisterFile("google/cloud/osconfig/v1beta/patch_deployments.proto", fileDescriptor_71fcfd7bb7d29e80)
}

var fileDescriptor_71fcfd7bb7d29e80 = []byte{
	// 1079 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0xf9, 0x6e, 0xdb, 0xc6,
	0x13, 0x0e, 0xe5, 0xd8, 0x96, 0x46, 0xfe, 0xe9, 0xd8, 0x1f, 0xd2, 0xca, 0x8e, 0xd1, 0x18, 0x04,
	0x1a, 0xa4, 0x40, 0x2d, 0x21, 0x07, 0x10, 0x34, 0x01, 0x7a, 0xc8, 0x92, 0x1b, 0xc3, 0x67, 0x68,
	0x1b, 0x81, 0x8d, 0xb6, 0xec, 0x9a, 0x1c, 0xc9, 0x6c, 0xa8, 0x5d, 0x96, 0x5c, 0x25, 0xa1, 0xff,
	0xea, 0xb3, 0x14, 0xe8, 0xf3, 0xf4, 0x15, 0x8a, 0x3e, 0x40, 0x9f, 0xa1, 0xd8, 0x83, 0x3a, 0xe8,
	0xa3, 0x72, 0xfe, 0x13, 0x67, 0xe6, 0xfb, 0x66, 0xf6, 0x9b, 0x99, 0xd5, 0xc2, 0xb3, 0x3e, 0xe7,
	0xfd, 0x10, 0x5b, 0x5e, 0xc8, 0x87, 0x7e, 0x8b, 0x27, 0x1e, 0x67, 0xbd, 0xa0, 0xdf, 0x7a, 0xf7,
	0xf8, 0x0c, 0x05, 0x6d, 0x45, 0x54, 0x78, 0xe7, 0xae, 0x8f, 0x51, 0xc8, 0xd3, 0x01, 0x32, 0x91,
	0x34, 0xa3, 0x98, 0x0b, 0x4e, 0x56, 0x35, 0xaa, 0xa9, 0x50, 0xcd, 0x0c, 0xd5, 0xd4, 0xa8, 0x95,
	0x07, 0x86, 0x93, 0x46, 0x41, 0xab, 0x17, 0x60, 0xe8, 0xbb, 0x67, 0x78, 0x4e, 0xdf, 0x05, 0x3c,
	0xd6, 0xf0, 0x95, 0xe5, 0x89, 0x80, 0x18, 0x13, 0x3e, 0x8c, 0x3d, 0x34, 0xae, 0xf5, 0x19, 0xea,
	0xf9, 0x85, 0x9f, 0x99, 0x42, 0x56, 0x3e, 0x33, 0xe1, 0xea, 0xeb, 0x6c, 0xd8, 0x6b, 0xf9, 0xc3,
	0x98, 0x8a, 0x80, 0x33, 0xe3, 0x7f, 0x90, 0xf7, 0x8b, 0x60, 0x80, 0x89, 0xa0, 0x83, 0xc8, 0x04,
	0xac, 0x98, 0x00, 0x91, 0x46, 0xd8, 0xf2, 0xa9, 0x40, 0x19, 0x60, 0x7c, 0xf7, 0xa7, 0x7d, 0x29,
	0xef, 0xbd, 0x47, 0x7c, 0x7b, 0x95, 0x53, 0x82, 0x78, 0xcf, 0xa7, 0xa9, 0x76, 0xda, 0x7f, 0xcf,
	0x43, 0xf5, 0x40, 0xd6, 0xda, 0x19, 0x49, 0x47, 0x08, 0xdc, 0x65, 0x74, 0x80, 0x0d, 0x6b, 0xcd,
	0x7a, 0x54, 0x72, 0xd4, 0x6f, 0xf2, 0x39, 0x94, 0x7d, 0x4c, 0xbc, 0x38, 0x88, 0x64, 0xcd, 0x8d,
	0x82, 0x74, 0xb5, 0xe7, 0xfe, 0xfa, 0xce, 0x72, 0x26, 0xed, 0xc4, 0x85, 0x6a, 0xc0, 0x12, 0x41,
	0x99, 0x87, 0x6e, 0x2f, 0x08, 0x05, 0xc6, 0x8d, 0xb9, 0x35, 0xeb, 0x51, 0xf9, 0xc9, 0xe3, 0xe6,
	0x4d, 0x8d, 0x68, 0xaa, 0x12, 0xb6, 0x0c, 0x72, 0x53, 0x01, 0x25, 0x7b, 0xc1, 0xa9, 0x04, 0x53,
	0x46, 0xf2, 0x1a, 0x96, 0xb4, 0xb4, 0x1a, 0xdf, 0xb8, 0xab, 0xd8, 0xbf, 0x98, 0x81, 0x7d, 0x43,
	0x99, 0x4c, 0xcd, 0xd1, 0xd8, 0x42, 0x5e, 0x40, 0x31, 0xeb, 0x45, 0x63, 0x5e, 0xd1, 0x2d, 0x67,
	0x74, 0x59, 0x33, 0x9a, 0x1d, 0x13, 0xa0, 0xe1, 0xa3, 0x78, 0xf2, 0x33, 0xd4, 0x39, 0x43, 0x57,
	0xaa, 0xea, 0x26, 0xde, 0x39, 0xfa, 0xc3, 0x10, 0x1b, 0x0b, 0x8a, 0x64, 0xfd, 0xe6, 0x9a, 0xf6,
	0x19, 0x1e, 0x05, 0x03, 0x3c, 0x34, 0x20, 0x75, 0xda, 0x57, 0x77, 0x9c, 0x2a, 0x9f, 0xb6, 0x13,
	0x04, 0x12, 0xa3, 0x37, 0x8c, 0xe3, 0x80, 0xf5, 0xc7, 0x29, 0x16, 0x55, 0x8a, 0xd6, 0xcd, 0x29,
	0x9c, 0x0c, 0x97, 0x4f, 0x52, 0x8f, 0xf3, 0x1e, 0xf2, 0x2d, 0x94, 0xbd, 0x18, 0xa9, 0xd0, 0x67,
	0x69, 0x14, 0x15, 0xff, 0xca, 0x25, 0x1d, 0x8e, 0xb2, 0xa1, 0x94, 0x54, 0x73, 0x0e, 0x68, 0x8c,
	0xb4, 0x4a, 0x86, 0x61, 0xe4, 0x8f, 0x18, 0x4a, 0x33, 0x32, 0x68, 0x8c, 0x62, 0xd8, 0x86, 0x7a,
	0x48, 0x13, 0xe1, 0xe2, 0x07, 0xf4, 0x86, 0x19, 0x0f, 0xcc, 0xc6, 0x53, 0x95, 0xc8, 0xae, 0x06,
	0x4a, 0x57, 0x1b, 0xa0, 0x98, 0xa9, 0x65, 0x1f, 0x43, 0x35, 0x27, 0x37, 0x69, 0xc3, 0xd2, 0x54,
	0x1a, 0x6b, 0x96, 0x34, 0x05, 0xa7, 0x8c, 0xe3, 0x14, 0xf6, 0x3f, 0xf3, 0x50, 0xbf, 0xa4, 0x31,
	0x79, 0x0e, 0x25, 0x35, 0x0e, 0x17, 0x9c, 0x65, 0xb4, 0xf7, 0x32, 0x5a, 0xb9, 0x82, 0x8a, 0xf2,
	0x94, 0x33, 0xdd, 0x0d, 0xa7, 0x28, 0xcc, 0x27, 0xf9, 0x1a, 0x20, 0x11, 0x34, 0x16, 0xba, 0xa0,
	0xc2, 0x2c, 0x05, 0x59, 0x4e, 0x49, 0x41, 0x94, 0x7c, 0x2f, 0xa0, 0x88, 0xcc, 0xd7, 0xe8, 0xb9,
	0xd9, 0xd0, 0x8b, 0xc8, 0x7c, 0x85, 0x7d, 0x09, 0x65, 0x55, 0x34, 0xef, 0xb9, 0x3e, 0x4d, 0xcd,
	0x56, 0x7d, 0x72, 0xa9, 0xec, 0xfd, 0x5e, 0x87, 0xa6, 0xba, 0x6e, 0x75, 0x48, 0xf5, 0x4d, 0x7e,
	0x80, 0x52, 0x2f, 0xc6, 0x5f, 0x87, 0xc8, 0xbc, 0x54, 0x6d, 0x50, 0xe5, 0xc9, 0x57, 0xb7, 0x9c,
	0xcc, 0xe6, 0x66, 0x46, 0x60, 0xd8, 0x47, 0x84, 0x64, 0x1b, 0x16, 0xe4, 0x65, 0x16, 0xa6, 0x66,
	0xaf, 0xbe, 0xbc, 0x99, 0xfa, 0x8d, 0x8a, 0xcd, 0x4f, 0xbc, 0xa1, 0x20, 0x7b, 0xb0, 0x38, 0xe0,
	0x4c, 0x9c, 0x87, 0xa9, 0x59, 0xa1, 0xff, 0xd8, 0xd2, 0x5d, 0x1d, 0x9c, 0xa7, 0xcb, 0x48, 0xae,
	0x1e, 0xd9, 0xd2, 0xc7, 0x8d, 0xac, 0x24, 0x63, 0xf8, 0xe1, 0x23, 0xe7, 0x5f, 0x22, 0x27, 0xc8,
	0xec, 0x6f, 0xa0, 0x34, 0xd2, 0x94, 0x2c, 0xc3, 0xbd, 0x4d, 0xa7, 0xfb, 0xfa, 0xb8, 0xbb, 0xb7,
	0x71, 0xe2, 0x1e, 0xef, 0x1d, 0x1e, 0x74, 0x37, 0xb6, 0x36, 0xb7, 0xba, 0x9d, 0xda, 0x1d, 0x02,
	0xb0, 0xf0, 0xa6, 0xdb, 0xdd, 0xde, 0x39, 0xa9, 0x59, 0xa4, 0x0c, 0x8b, 0xbb, 0xfb, 0x7b, 0x47,
	0xaf, 0x76, 0x4e, 0x6a, 0x85, 0x76, 0x1d, 0xaa, 0xd9, 0x02, 0x99, 0xcb, 0xd6, 0xde, 0x85, 0xca,
	0xb4, 0xbc, 0x72, 0x6e, 0x7c, 0x9a, 0xca, 0xb1, 0x91, 0x02, 0xab, 0x71, 0xaf, 0xe4, 0xe6, 0xa6,
	0x43, 0xd3, 0xfd, 0x9e, 0x84, 0x99, 0xce, 0xfa, 0xd9, 0xb7, 0xfd, 0x87, 0x05, 0xd5, 0x9c, 0xc0,
	0xe4, 0x27, 0xa8, 0x4b, 0x26, 0xd7, 0xb0, 0x2a, 0x9d, 0xcd, 0x16, 0xcd, 0xd0, 0x78, 0x95, 0x4b,
	0x51, 0x66, 0x9d, 0xaa, 0xbc, 0x9f, 0x32, 0x13, 0x1b, 0x4a, 0x8a, 0x53, 0x8d, 0xb9, 0xdc, 0xb1,
	0xf9, 0x2c, 0xb2, 0xa8, 0xec, 0x72, 0xbe, 0x2b, 0xb0, 0x34, 0x99, 0xde, 0x1e, 0xea, 0x63, 0x4f,
	0xb0, 0x3c, 0x84, 0x25, 0x55, 0x25, 0x8f, 0xfd, 0x80, 0xd1, 0x50, 0x15, 0x38, 0x6f, 0x6e, 0x08,
	0xe9, 0xd8, 0xd7, 0xf6, 0xbc, 0x3c, 0x85, 0x5b, 0xc9, 0xf3, 0xa7, 0x05, 0xab, 0x1b, 0xea, 0x7e,
	0xcd, 0xfd, 0x41, 0x3b, 0xb2, 0xad, 0x89, 0x20, 0xf7, 0x61, 0x21, 0xa2, 0x31, 0x32, 0xa1, 0xff,
	0xa9, 0x35, 0x81, 0x31, 0x91, 0xa7, 0xf0, 0xff, 0xfc, 0x9b, 0xc8, 0x0d, 0xfc, 0xf1, 0x1f, 0x77,
	0xc1, 0xa9, 0x47, 0xd3, 0xb4, 0x5b, 0x3e, 0xf9, 0x11, 0x6a, 0x79, 0x90, 0xb9, 0x4a, 0xd6, 0x67,
	0xf8, 0x87, 0x1d, 0x53, 0xe9, 0x04, 0xd5, 0x5c, 0x02, 0xfb, 0x19, 0x2c, 0x7f, 0x8f, 0xe2, 0x9a,
	0xd3, 0x7c, 0x3a, 0xf9, 0xea, 0xd0, 0x04, 0xca, 0x60, 0xff, 0x66, 0xc1, 0xfd, 0x9d, 0x20, 0xc9,
	0xe3, 0x92, 0x99, 0x64, 0x58, 0x83, 0x52, 0x44, 0xfb, 0xe8, 0x26, 0xc1, 0x05, 0x8e, 0xfb, 0x6d,
	0x39, 0x45, 0x69, 0x3d, 0x0c, 0x2e, 0x90, 0xd8, 0x00, 0x2a, 0x42, 0xf0, 0xb7, 0xc8, 0xd4, 0x69,
	0xcd, 0xc3, 0x46, 0x01, 0x8f, 0xa4, 0xd5, 0xfe, 0xdd, 0x82, 0xd5, 0xab, 0x4b, 0x48, 0x22, 0xce,
	0x12, 0x24, 0xa7, 0x50, 0xbf, 0xf4, 0x02, 0x6d, 0x58, 0x6b, 0x73, 0xb7, 0x56, 0xce, 0xa9, 0xe5,
	0x44, 0x4b, 0xc8, 0x43, 0x50, 0xcb, 0xed, 0x4e, 0x54, 0xa9, 0xba, 0xe8, 0xfc, 0x4f, 0x9a, 0x0f,
	0x46, 0x45, 0x3e, 0x87, 0xd5, 0x0e, 0x86, 0x78, 0xed, 0xb8, 0x5c, 0x27, 0x70, 0xfb, 0x02, 0xd6,
	0x3c, 0x3e, 0xb8, 0xb1, 0xcc, 0x76, 0x2d, 0x7f, 0xf4, 0xd3, 0x8e, 0x89, 0xef, 0xf3, 0x90, 0xb2,
	0x7e, 0x93, 0xc7, 0xfd, 0x56, 0x1f, 0x99, 0xba, 0x9f, 0x5a, 0xda, 0x45, 0xa3, 0x20, 0xb9, 0xfa,
	0x79, 0xfc, 0x32, 0xfb, 0x3e, 0x5b, 0x50, 0x80, 0xa7, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0x2b,
	0xdc, 0x56, 0xe7, 0xde, 0x0b, 0x00, 0x00,
}
