#ifndef _XINEINPUT_H_
#define _XINEINPUT_H_

/***************************************************************************
 *   Copyright (C) 2007 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include "input.h"

#include <string>
#define XINE_ENABLE_EXPERIMENTAL_FEATURES
#include <xine.h>

class XineInput : public Input
{
	public:
		XineInput( std::string mrl, unsigned long timeLimitMS=NoLimit );
		virtual ~XineInput();

		bool setStreamMRL( std::string mrl );

		virtual unsigned int getBlockAlign();

	protected:

		virtual bool _getPCMChunk( unsigned char* data, unsigned long limit, unsigned long &read );

		virtual bool _open();
		virtual bool _close();

		std::string m_mrl;
		xine_stream_t* m_stream;
		xine_audio_frame_t m_frame;

		bool m_hasMoreFrames;
		unsigned long m_framePos;
		unsigned long m_frameSize;
		unsigned int m_blockAlign;
};

#endif

