/* bgiSnp.h was originally generated by the autoSql program, which also 
 * generated bgiSnp.c and bgiSnp.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef BGISNP_H
#define BGISNP_H

#define BGISNP_NUM_COLS 19

struct bgiSnp
/* Beijing Genomics Institute SNP information as bed 4 + */
    {
    struct bgiSnp *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* BGI SNP name: snp.superctg.ctg.pos.type.strainID */
    char snpType[2];	/* S (substitution), I (insertion), or D (deletion) */
    unsigned readStart;	/* Start position in alternate allele read */
    unsigned readEnd;	/* End position in alternate allele read */
    unsigned qualChr;	/* Quality score in reference assembly */
    unsigned qualReads;	/* Quality score in alternate allele read */
    char *snpSeq;	/* 'X->Y' or indel sequence */
    char *readName;	/* Name of alternate allele read */
    char readDir[2];	/* Direction of read relative to reference */
    char inBroiler[5];	/* SNP found in Broiler strain? yes, no or n/a if not covered */
    char inLayer[5];	/* SNP found in Layer strain? yes, no or n/a if not covered */
    char inSilkie[5];	/* SNP found in Silkie strain? yes, no or n/a if not covered */
    char *primerL;	/* Left primer sequence */
    char *primerR;	/* Right primer sequence */
    char questionM[2];	/* L for dubious indels, H for other indels and SNPs */
    char *extra;	/* Additional information */
    };

void bgiSnpStaticLoad(char **row, struct bgiSnp *ret);
/* Load a row from bgiSnp table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct bgiSnp *bgiSnpLoad(char **row);
/* Load a bgiSnp from row fetched with select * from bgiSnp
 * from database.  Dispose of this with bgiSnpFree(). */

struct bgiSnp *bgiSnpLoadAll(char *fileName);
/* Load all bgiSnp from whitespace-separated file.
 * Dispose of this with bgiSnpFreeList(). */

struct bgiSnp *bgiSnpLoadAllByChar(char *fileName, char chopper);
/* Load all bgiSnp from chopper separated file.
 * Dispose of this with bgiSnpFreeList(). */

#define bgiSnpLoadAllByTab(a) bgiSnpLoadAllByChar(a, '\t');
/* Load all bgiSnp from tab separated file.
 * Dispose of this with bgiSnpFreeList(). */

struct bgiSnp *bgiSnpCommaIn(char **pS, struct bgiSnp *ret);
/* Create a bgiSnp out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bgiSnp */

void bgiSnpFree(struct bgiSnp **pEl);
/* Free a single dynamically allocated bgiSnp such as created
 * with bgiSnpLoad(). */

void bgiSnpFreeList(struct bgiSnp **pList);
/* Free a list of dynamically allocated bgiSnp's */

void bgiSnpOutput(struct bgiSnp *el, FILE *f, char sep, char lastSep);
/* Print out bgiSnp.  Separate fields with sep. Follow last field with lastSep. */

#define bgiSnpTabOut(el,f) bgiSnpOutput(el,f,'\t','\n');
/* Print out bgiSnp as a line in a tab-separated file. */

#define bgiSnpCommaOut(el,f) bgiSnpOutput(el,f,',',',');
/* Print out bgiSnp as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* BGISNP_H */

