#!/bin/csh -ef
# DO NOT EDIT this file in any installed-bin location --
# edit kent/src/hg/snp/hapmapLd/runHaploviewPhased.csh instead.

# $Id: runHaploviewPhased.csh,v 1.1 2007/10/29 23:48:21 angie Exp $

# Haploview cluster-run job script -- inputs come from the output of 
# PHASE, and are smaller than the genotype output but with no info loss.

if ( $#argv < 3 || $#argv > 4 ) then
    echo "usage: $0 </path/phaseBase> </path/java> </path/Haploview.jar> [<javaMaxMem>]"
    echo "       $0 /san/etc/chr1.etc.b36_fwd /usr/java/jre1.5.0_12/bin/java /san/etc/Haploview.jar 4G"
    exit 1
endif
set phaseBase = $1
set java = $2
set jar = $3
set memFlag = ""
if ( $#argv >= 4 ) then
    set memFlag = "-Xmx$4"
endif
set phaseDir    = $phaseBase:h
set phaseData   = $phaseBase.phase.gz
set phaseSample = ${phaseBase}_sample.txt.gz
set phaseLegend = ${phaseBase}_legend.txt.gz
set c = `echo $phaseBase:t | perl -wpe 's/^genotypes_chr([0-9MXY]+)_.*/$1/ || die "Cant parse chrom out of phaseBase '$phaseBase:t'";'`

mkdir -p /scratch/tmp
set tmpDir = `mktemp -d -p /scratch/tmp runHaploviewPhased.XXXXXX`
pushd $tmpDir
ln -s $phaseData .
$java -d64 $memFlag \
  -jar $jar \
  -phasedhmpdata $phaseData:t -phasedhmpsample $phaseSample \
  -phasedhmplegend $phaseLegend \
  -chromosome $c \
  -dprime -check -maxdistance 250 \
  -nogui -gzip

gzip   -f $phaseData:t.{LD,CHECK}
mv     -f $phaseData:t.LD.gz    $phaseDir/$phaseBase:t.LD.gz 
mv     -f $phaseData:t.CHECK.gz $phaseDir/$phaseBase:t.CHECK.gz 
popd
rm -r $tmpDir
