/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.ideafactory;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.DragDetectEvent;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.util.Properties;
import org.xmind.ui.internal.ideafactory.AddIdeaGroupCommand;
import org.xmind.ui.internal.ideafactory.IdeaFactoryMessages;
import org.xmind.ui.internal.ideafactory.IdeaFactoryViewer;
import org.xmind.ui.internal.ideafactory.IdeaUtils;
import org.xmind.ui.internal.ideafactory.ReorderIdeaGroupsCommand;
import org.xmind.ui.mindmap.IMindMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdeaFactoryBody
implements ICoreEventListener {
    private List<IdeaFactoryViewer> ideaFactoryViewers = new ArrayList<IdeaFactoryViewer>();
    private IMindMap mindmap;
    private Control control;
    private ICoreEventRegister register;
    private Control content;
    private IGraphicalEditor sourceEditor;
    private int ideaFontHeight;
    private int sourceIndex = -1;
    private int insertIndex = -1;
    private List<Control> insertFeedbacks = new ArrayList<Control>();
    private Control insertFeedback = null;
    private boolean dragging = false;
    private Properties properties;

    public IdeaFactoryBody(Properties properties) {
        this.properties = properties;
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(composite.getParent().getBackground());
        GridLayout outerLayout = new GridLayout(1, false);
        outerLayout.marginWidth = 10;
        outerLayout.marginHeight = 0;
        outerLayout.horizontalSpacing = 0;
        outerLayout.verticalSpacing = 0;
        composite.setLayout((Layout)outerLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.control = composite;
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IdeaFactoryBody.this.unregisterCoreEvent();
                IdeaFactoryBody.this.properties.set("ideaFactoryViewers", null);
            }
        });
        return this.control;
    }

    private Control createContent(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 256);
        sc.setBackground(sc.getParent().getBackground());
        sc.setLayoutData((Object)new GridData(4, 4, true, true));
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        this.addHorizontalScrollSupport(sc);
        final Composite content = new Composite((Composite)sc, 0);
        content.setBackground(content.getParent().getBackground());
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 0;
        content.setLayout((Layout)layout);
        sc.setContent((Control)content);
        sc.getHorizontalBar().setIncrement(17);
        sc.setShowFocusedControl(true);
        sc.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                content.pack();
            }
        });
        this.createIdeaFactoryViewers(content);
        layout.numColumns = this.ideaFactoryViewers.size();
        int minWidth = layout.marginWidth + layout.marginLeft + layout.marginRight + layout.horizontalSpacing * (this.ideaFactoryViewers.size() - 1);
        for (IdeaFactoryViewer ideafactoryViewer : this.ideaFactoryViewers) {
            Composite composite_0 = ideafactoryViewer.getComposite();
            if (!(composite_0.getLayoutData() instanceof GridData)) continue;
            minWidth += ((GridData)composite_0.getLayoutData()).minimumWidth;
        }
        sc.setMinWidth(minWidth);
        sc.setMinHeight(-1);
        return sc;
    }

    private void addHorizontalScrollSupport(final ScrolledComposite sc) {
        if (Util.isWindows()) {
            sc.addListener(38, new Listener(){

                public void handleEvent(Event event) {
                    if (!sc.isDisposed()) {
                        int offset = event.count;
                        offset = -((int)(Math.sqrt(Math.abs(offset)) * (double)offset));
                        Point origin = sc.getOrigin();
                        sc.setOrigin(origin.x + offset, origin.y);
                    }
                }
            });
        }
    }

    private void createIdeaFactoryViewers(Composite content) {
        int noGroupViewerCount;
        List<ITopicExtensionElement> groups = this.getIdeaFactoryGroups();
        ITopic topic = this.mindmap.getSheet().getRootTopic();
        boolean showNoGroupViewer = IdeaUtils.getNoGroupIdeas(topic).size() > 0;
        int n = noGroupViewerCount = showNoGroupViewer ? 1 : 0;
        if (groups.size() + noGroupViewerCount > 1) {
            for (ITopicExtensionElement groupExtension : groups) {
                IdeaFactoryViewer ideafactoryViewer = new IdeaFactoryViewer(content, true);
                ideafactoryViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
                ideafactoryViewer.setInput(groupExtension);
                this.ideaFactoryViewers.add(ideafactoryViewer);
            }
            if (showNoGroupViewer) {
                IdeaFactoryViewer ideafactoryViewer = new IdeaFactoryViewer(content, true);
                ideafactoryViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
                ideafactoryViewer.setCreatedGroupName(this.getCreatedGroupName());
                ideafactoryViewer.setInput(topic);
                this.ideaFactoryViewers.add(ideafactoryViewer);
            }
        } else {
            IdeaFactoryViewer ideafactoryViewer = new IdeaFactoryViewer(content, false);
            ideafactoryViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            ITopicExtensionElement input = null;
            if (groups.size() == 1) {
                input = groups.get(0);
            } else if (showNoGroupViewer) {
                input = topic;
                ideafactoryViewer.setCreatedGroupName(this.getCreatedGroupName());
            }
            ideafactoryViewer.setInput(input);
            this.ideaFactoryViewers.add(ideafactoryViewer);
        }
        this.updateFontSize();
        this.addTitleDragSupport();
        this.updateProperties();
    }

    private void updateProperties() {
        this.properties.set("ideaFactoryViewers", new ArrayList<IdeaFactoryViewer>(this.ideaFactoryViewers));
    }

    private void addTitleDragSupport() {
        this.insertFeedbacks.clear();
        if (this.ideaFactoryViewers.size() <= 1) {
            return;
        }
        int i = 0;
        while (i < this.ideaFactoryViewers.size()) {
            this.insertFeedbacks.add((Control)this.ideaFactoryViewers.get(i).getLeftInsertFeedback());
            if (i == this.ideaFactoryViewers.size() - 1) {
                this.insertFeedbacks.add((Control)this.ideaFactoryViewers.get(i).getRightInsertFeedback());
            }
            ++i;
        }
        i = 0;
        while (i < this.ideaFactoryViewers.size()) {
            IdeaFactoryViewer viewer = this.ideaFactoryViewers.get(i);
            final Label groupTitle = viewer.getGroupTitle();
            final int index = i;
            if (groupTitle != null) {
                groupTitle.addDragDetectListener(new DragDetectListener(){

                    public void dragDetected(DragDetectEvent e) {
                        IdeaFactoryBody.this.sourceIndex = index;
                        IdeaFactoryBody.this.dragging = true;
                        IdeaFactoryBody.this.track(((Control)e.widget).toDisplay(e.x, e.y));
                        groupTitle.getShell().setCursor(groupTitle.getDisplay().getSystemCursor(21));
                    }
                });
                groupTitle.getParent().addDragDetectListener(new DragDetectListener(){

                    public void dragDetected(DragDetectEvent e) {
                        IdeaFactoryBody.this.sourceIndex = index;
                        IdeaFactoryBody.this.dragging = true;
                        IdeaFactoryBody.this.track(((Control)e.widget).toDisplay(e.x, e.y));
                        groupTitle.getShell().setCursor(groupTitle.getDisplay().getSystemCursor(21));
                    }
                });
                final Listener mouseMoveFilter = new Listener(){

                    public void handleEvent(Event e) {
                        if (!groupTitle.isDisposed() && IdeaFactoryBody.this.dragging) {
                            IdeaFactoryBody.this.track(((Control)e.widget).toDisplay(e.x, e.y));
                        }
                    }
                };
                groupTitle.getDisplay().addFilter(5, mouseMoveFilter);
                final Listener mouseUpFilter = new Listener(){

                    public void handleEvent(Event event) {
                        if (!groupTitle.isDisposed()) {
                            if (IdeaFactoryBody.this.sourceIndex == -1) {
                                return;
                            }
                            if (IdeaFactoryBody.this.insertFeedback != null) {
                                IdeaFactoryBody.this.insertFeedback.setVisible(false);
                                IdeaFactoryBody.this.insertFeedback = null;
                                IdeaFactoryBody.this.reorderGroup();
                                IdeaFactoryBody.this.insertIndex = -1;
                            }
                            IdeaFactoryBody.this.sourceIndex = -1;
                            IdeaFactoryBody.this.dragging = false;
                            Display.getCurrent().getActiveShell().setCursor(null);
                        }
                    }
                };
                groupTitle.getDisplay().addFilter(4, mouseUpFilter);
                groupTitle.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        groupTitle.getDisplay().removeFilter(5, mouseMoveFilter);
                        groupTitle.getDisplay().removeFilter(4, mouseUpFilter);
                        groupTitle.getDisplay().getActiveShell().setCursor(null);
                    }
                });
            }
            ++i;
        }
    }

    private void track(Point toDisplay) {
        if (!this.control.isDisposed() && this.control.getShell().getBounds().contains(toDisplay)) {
            int i = 0;
            while (i < this.ideaFactoryViewers.size()) {
                IdeaFactoryViewer viewer = this.ideaFactoryViewers.get(i);
                Composite control = viewer.getComposite();
                Rectangle bounds = control.getBounds();
                Point toControl = control.getParent().toControl(toDisplay);
                if (toControl.x >= bounds.x && toControl.x <= bounds.x + bounds.width) {
                    int targetIndex = -1;
                    targetIndex = toControl.x <= bounds.x + (int)(0.6666666666666666 * (double)bounds.width) ? i : i + 1;
                    Control newInsertFeedback = this.insertFeedbacks.get(targetIndex);
                    if (newInsertFeedback != this.insertFeedback) {
                        if (this.insertFeedback != null) {
                            this.insertFeedback.setVisible(false);
                        }
                        this.insertFeedback = newInsertFeedback;
                        this.insertFeedback.setVisible(true);
                        this.insertIndex = targetIndex;
                        return;
                    }
                }
                ++i;
            }
        }
    }

    private void reorderGroup() {
        if (this.sourceIndex == -1 || this.insertIndex == -1 || this.insertIndex == this.sourceIndex || this.insertIndex == this.sourceIndex + 1) {
            return;
        }
        this.checkGroup();
        List<ITopicExtensionElement> groups = this.getIdeaFactoryGroups();
        ITopicExtensionElement sourceElement = this.ideaFactoryViewers.get(this.sourceIndex).getGroupElement();
        if (this.insertIndex < this.sourceIndex) {
            groups.remove(this.sourceIndex);
            groups.add(this.insertIndex, sourceElement);
        } else {
            groups.add(this.insertIndex, sourceElement);
            groups.remove(this.sourceIndex);
        }
        if (this.mindmap != null && this.sourceEditor != null) {
            ICommandStack commandStack = this.sourceEditor.getCommandStack();
            commandStack.execute((Command)new ReorderIdeaGroupsCommand(this.mindmap.getSheet().getRootTopic(), groups));
        }
    }

    private List<ITopicExtensionElement> getIdeaFactoryGroups() {
        ITopicExtensionElement content;
        ITopicExtensionElement groupParentElement;
        ITopic rootTopic;
        ITopicExtension ext;
        if (this.mindmap != null && (ext = (rootTopic = this.mindmap.getSheet().getRootTopic()).getExtension("org.xmind.ui.ideafactory")) != null && (groupParentElement = (ITopicExtensionElement)(content = ext.getContent()).getFirstChild("groups")) != null) {
            List elements = groupParentElement.getChildren("group");
            return elements;
        }
        return new ArrayList<ITopicExtensionElement>();
    }

    public void setInput(IMindMap mindmap) {
        this.mindmap = mindmap;
        this.registerCoreEvent();
        this.update();
    }

    private void update() {
        this.control.setRedraw(false);
        if (this.content != null) {
            this.content.dispose();
        }
        this.ideaFactoryViewers.clear();
        this.updateProperties();
        this.content = this.createContent((Composite)this.control);
        ((Composite)this.control).layout();
        this.control.setRedraw(true);
    }

    private void registerCoreEvent() {
        ITopic centralTopic = this.mindmap.getSheet().getRootTopic();
        if (this.register != null) {
            this.register.unregisterAll();
        } else {
            this.register = new CoreEventRegister((ICoreEventListener)this);
        }
        if (centralTopic != null && centralTopic instanceof ICoreEventSource) {
            this.register.setNextSource((ICoreEventSource)centralTopic);
            this.register.register("ideaGroupAdded");
            this.register.register("ideaGroupDeleted");
            this.register.register("ideaGroupReorder");
        }
    }

    private void unregisterCoreEvent() {
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
    }

    public void handleCoreEvent(CoreEvent event) {
        if (this.content == null || this.content.isDisposed()) {
            return;
        }
        Point origin = ((ScrolledComposite)this.content).getOrigin();
        this.update();
        if ("ideaGroupAdded".equals(event.getType())) {
            ITopicExtensionElement group = (ITopicExtensionElement)event.getTarget();
            for (IdeaFactoryViewer viewer : this.ideaFactoryViewers) {
                if (viewer.getGroupElement() != group) continue;
                ((ScrolledComposite)this.content).showControl((Control)viewer.getComposite());
                viewer.startEditingGroupTitle();
            }
        } else if ("ideaGroupDeleted".equals(event.getType())) {
            ScrolledComposite sc = (ScrolledComposite)this.content;
            int maxValue = sc.getHorizontalBar().getMaximum();
            if (origin.x > maxValue) {
                origin.x = maxValue;
            }
            ((ScrolledComposite)this.content).setOrigin(origin);
        }
    }

    public void createIdeaGroup() {
        if (this.mindmap != null && this.sourceEditor != null) {
            ICommandStack commandStack = this.sourceEditor.getCommandStack();
            this.checkGroup();
            if (this.getIdeaFactoryGroups().size() != 0) {
                String groupName = this.getCreatedGroupName();
                commandStack.execute((Command)new AddIdeaGroupCommand(this.mindmap.getSheet().getRootTopic(), groupName));
            } else {
                String group1Name = NLS.bind((String)IdeaFactoryMessages.IdeaFactoryBody_Group_Name, (Object)1);
                String group2Name = NLS.bind((String)IdeaFactoryMessages.IdeaFactoryBody_Group_Name, (Object)2);
                CompoundCommand cc = new CompoundCommand(new Command[]{new AddIdeaGroupCommand(this.mindmap.getSheet().getRootTopic(), group1Name)});
                cc.append((Command)new AddIdeaGroupCommand(this.mindmap.getSheet().getRootTopic(), group2Name));
                cc.setLabel(IdeaFactoryMessages.AddIdeaGroupCommand_Name);
                commandStack.execute((Command)cc);
            }
        }
    }

    private void checkGroup() {
        for (IdeaFactoryViewer viewer : this.ideaFactoryViewers) {
            viewer.checkGroup();
        }
    }

    private String getCreatedGroupName() {
        int index = this.getIdeaFactoryGroups().size() + 1;
        String name = NLS.bind((String)IdeaFactoryMessages.IdeaFactoryBody_Group_Name, (Object)index);
        while (this.isGroupNameExist(name)) {
            name = NLS.bind((String)IdeaFactoryMessages.IdeaFactoryBody_Group_Name, (Object)(++index));
        }
        return name;
    }

    private boolean isGroupNameExist(String groupName) {
        List<ITopicExtensionElement> groups = this.getIdeaFactoryGroups();
        for (ITopicExtensionElement group : groups) {
            if (!group.getTextContent().equals(groupName)) continue;
            return true;
        }
        return false;
    }

    public Control getControl() {
        return this.control;
    }

    public void setSourceEditor(IGraphicalEditor sourceEditor) {
        this.sourceEditor = sourceEditor;
    }

    public void setIdeasFontSize(int height) {
        if (this.ideaFontHeight != height) {
            this.ideaFontHeight = height;
            this.updateFontSize();
        }
    }

    private void updateFontSize() {
        if (this.ideaFontHeight != 0) {
            for (IdeaFactoryViewer viewer : this.ideaFactoryViewers) {
                viewer.setIdeasFontSize(this.ideaFontHeight);
            }
        }
    }
}

