/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.normalization.java.impl;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gradle.internal.normalization.java.impl.AnnotationValue;
import org.gradle.internal.normalization.java.impl.Member;

public class AnnotationMember
extends Member
implements Comparable<AnnotationMember> {
    private final SortedSet<AnnotationValue<?>> values = new TreeSet();
    private final boolean visible;

    public AnnotationMember(String name, boolean visible) {
        super(name);
        this.visible = visible;
    }

    public SortedSet<AnnotationValue<?>> getValues() {
        return ImmutableSortedSet.copyOf(this.values);
    }

    public void addValue(AnnotationValue<?> value) {
        this.values.add(value);
    }

    public void addValues(Collection<AnnotationValue<?>> values) {
        this.values.addAll(values);
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected ComparisonChain compare(AnnotationMember o) {
        return super.compare(o).compareFalseFirst(this.visible, o.visible);
    }

    @Override
    public int compareTo(AnnotationMember o) {
        return this.compare(o).result();
    }
}

