#!/usr/bin/false
# $Header: /code/convert/cvsroot/infrastructure/diradm/src/diradm.misc.sh.in,v 1.9 2007/03/30 10:47:55 robbat2 Exp $
# vim: ts=4 sts=4 noexpandtab sw=4 ft=sh syntax=sh:
# This contains all of the functions specific to the host sub-system.

print_usage_sub() {
	for func in $* ; do
		case "$func" in
		useradd)
		echo " diradm useradd [-u uid [-o]] [-g group] [-G group,...] [-h hosts]"
		echo "                [-d home] [-s shell] [-c comment] [-m [-k template]]"
		echo "                [-f inactive] [-e expire] [-p passwd] [-E email] [-r|-R] LOGIN"
		;;
		usermod)
		echo " diradm usermod [-u uid [-o]] [-g group] [-G group,...] [-h hosts]"
		echo "                [-d home [-m]] [-s shell] [-c comment] [-l new_name]"
		echo "                [-f inactive] [-e expire] [-p passwd] [-L|-U] [-r|-R]"
		echo "                [-E email] LOGIN"
		;;
		userdel)
		echo " diradm userdel [-r] LOGIN"
		;;
		user*)
		print_usage_sub useradd _ usermod _ userdel
		;;
		groupadd)
		echo " diradm groupadd [-g GID [-o]] GROUP"
		;;
		groupmod)
		echo " diradm groupmod [-g GID [-o]] [-n NEWNAME] GROUP"
		;;
		groupdel)
		echo " diradm groupdel GROUP"
		;;
		group*)
		print_usage_sub groupadd groupmod groupdel
		;;
		chsh)
		echo " diradm chsh [-s login_shell] LOGIN"
		;;
		chfn)
		echo " diradm chfn [-f full_name] [-r room_no] [-w work_ph] [-h home_ph]" 
		echo "             [-o other] LOGIN"
		;;
		chage)
		echo " diradm chage [-m mindays] [-M maxdays] [-d lastday] [-I inactive]"
		echo "              [-E expiredate] [-W warndays] LOGIN"
		echo " diradm chage [-l|-S] LOGIN"
		;;
		ch*)
		print_usage_sub chsh _ chfn _ chage
		;;
		gpasswd)
		echo " diradm gpasswd GROUP"
		echo " diradm gpasswd -a USER GROUP"
		echo " diradm gpasswd -d USER GROUP"
		echo " diradm gpasswd -R GROUP"
		echo " diradm gpasswd -r GROUP"
		echo " diradm gpasswd [-A USER,...] [-M USER,...] GROUP"
		;;
		passwd)
		echo " diradm passwd [-f -s] USER"
		echo " diradm passwd [-x max] [-n min] [-w warn] [-i inact] USER"
		echo " diradm passwd [-l -u -d -S -e] USER"
		;;
		smbhostadd)
		echo " diradm smbhostadd [-r RID] HOST"
		;;
		smbhostdel)
		echo " diradm smbhostdel HOST"
		;;
		smb*)
		print_usage_sub	smbhostadd smbhostdel
		;;
		hostadd)
		echo " diradm hostadd [-i IP,...] [-e MAC,...] [-a ALIAS,...] HOST"
		;;
		hostmod)
		echo " diradm hostmod [-i add-IP,...] [-I del-IP,...] [-e add-MAC,...]"
		echo "                [-E del-MAC,...] [-a add-ALIAS,...]"
		echo "                [-A del-ALIAS,...] [-n NEWNAME] HOST"
		;;
		hostdel)
		echo " diradm hostdel HOST"
		;;
		host*)
		print_usage_sub	hostadd hostdel hostmod
		;;
		amadd)
		echo " diradm amadd [-o mount-options,...] [-O] [-d DESC] "
		echo "              MAPNAME MAPKEY SOURCE"
		;;
		amdel)
		echo " diradm amdel MAPNAME MAPKEY"
		;;
		ammapadd)
		echo " diradm ammapadd MAPNAME"
		;;
		ammapdel)
		echo " diradm ammapdel MAPNAME"
		;;
		am*)
		print_usage_sub	amadd amdel ammapadd ammapdel
		;;
		check)
		echo " diradm check [self|config]   Run tests for: ALL/self/config"
		;;
		version)
		echo " diradm version   Print diradm version number, then exit"
		;;
		help)
		echo " diradm help [command1]...    Print help, then exit"
		;;
		_)
		echo
		;;
		*)
		echo "Unknown command!"
		exit 1
		;;
		esac
	done
}

print_usage() {
	list=''
	[ -n "$*" ] && list="$@"
	echo "Usage: diradm command [options]"
	if [ -z "$list" -o "$list" == "_all" ]; then
		list="user _ group _ ch _ gpasswd _ passwd _ host"
		[ "$ENABLE_SAMBA" == "yes" ] && list="${list} _ smb"
		[ "$ENABLE_AUTOMOUNT" == "yes" ] && list="${list} _ am"
		list="${list} _ check version help _"
	fi
	for i in $list; do
		print_usage_sub ${i}
	done;
}

version() {
	echo "diradm ${VERSION}"
	echo "Copyright (C) 2003 Daniel Himler <dan@hits.at>"
	echo "Copyright (C) 2003-2006 Robin H. Johnson <robbat2@orbis-terrarum.net>"
	echo "Copyright (C) 2003-2004 Patrick Lougheed <pat@tfsb.org>"
	echo "This is free software; see the source for copying conditions.  There is NO"
	echo "warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE."
}

help() {
	[ -z "${modulename}" ] && modulename="help"
	print_usage "${@}"
	exit 0
}

_header() {
	grep '$Header' $0 $libexecdir/*.sh 
	exit 0
}
