# CMake package configuration file for SoXt
#
# Defines the target "SoXt::SoXt"
#
# Add the following lines to your CMakeLists.txt to depend on SoXt
#
#    find_package(SoXt REQUIRED)
#    target_link_libraries(my_target_name SoXt::SoXt)
#
# Additionally you may one of the following variables (or their corresponding
# upper case version) that are also defined.
#
# SoXt_COMPILE_DEFINITIONS
# SoXt_DEFINITIONS
# SoXt_INCLUDE_DIRS
# SoXt_INCLUDE_DIR
# SoXt_LIBRARY
# SoXt_LIBRARIES
# SoXt_LIBRARY_DIRS
# SoXt_LIBRARY_DIR
#
# However, in most cases using the SoXt::SoXt target is sufficient,
# and you won't need these variables.


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was soxt-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib64/cmake/SoXt-1.4.1" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)

find_dependency(Coin REQUIRED)

include("${CMAKE_CURRENT_LIST_DIR}/soxt-export.cmake")

get_property(SoXt_COMPILE_DEFINITIONS TARGET SoXt::SoXt PROPERTY INTERFACE_COMPILE_DEFINITIONS)
foreach(_def ${SoXt_COMPILE_DEFINITIONS})
  list(APPEND SoXt_DEFINITIONS -D${_def})
endforeach()

set(SoXt_VERSION 1.4.1)

get_property(SoXt_INCLUDE_DIRS TARGET SoXt::SoXt PROPERTY INTERFACE_INCLUDE_DIRECTORIES)
set(SoXt_INCLUDE_DIR ${SoXt_INCLUDE_DIRS})
set(SoXt_LIBRARY SoXt::SoXt)
get_property(SoXt_LIBRARIES TARGET SoXt::SoXt PROPERTY INTERFACE_LINK_LIBRARIES)
set(SoXt_LIBRARIES SoXt::SoXt ${SoXt_LIBRARIES})

set_and_check(SoXt_LIBRARY_DIRS "${PACKAGE_PREFIX_DIR}/lib64")
set(SoXt_LIBRARY_DIR ${SoXt_LIBRARY_DIRS})

# For backwards compatibility define upper case versions of output variables
foreach(_var
  SoXt_COMPILE_DEFINITIONS
  SoXt_DEFINITIONS
  SoXt_INCLUDE_DIRS
  SoXt_INCLUDE_DIR
  SoXt_LIBRARY
  SoXt_LIBRARIES
  SoXt_LIBRARY_DIRS
  SoXt_LIBRARY_DIR
  SoXt_VERSION
  )
  string(TOUPPER ${_var} _uppercase_var)
  set(${_uppercase_var} ${${_var}})
endforeach()
