-- -*-Sql-*- mode (to keep my emacs happy)
--
-- API Package Body for Bioentry_Path.
--
-- Scaffold auto-generated by gen-api.pl. gen-api.pl is
-- Copyright 2002-2003 Genomics Institute of the Novartis Research Foundation
-- Copyright 2002-2008 Hilmar Lapp
-- 
--  This file is part of BioSQL.
--
--  BioSQL is free software: you can redistribute it and/or modify it
--  under the terms of the GNU Lesser General Public License as
--  published by the Free Software Foundation, either version 3 of the
--  License, or (at your option) any later version.
--
--  BioSQL is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU Lesser General Public License for more details.
--
--  You should have received a copy of the GNU Lesser General Public License
--  along with BioSQL. If not, see <http://www.gnu.org/licenses/>.
--

CREATE OR REPLACE
PACKAGE BODY EntP IS

EntP_cached	INTEGER DEFAULT NULL;
cache_key		VARCHAR2(1024) DEFAULT NULL;

CURSOR EntP_c (
		EntP_SUBJ_ENT_OID	IN SG_BIOENTRY_PATH.SUBJ_ENT_OID%TYPE,
		EntP_OBJ_ENT_OID	IN SG_BIOENTRY_PATH.OBJ_ENT_OID%TYPE,
		EntP_TRM_OID	IN SG_BIOENTRY_PATH.TRM_OID%TYPE,
		EntP_DISTANCE	IN SG_BIOENTRY_PATH.DISTANCE%TYPE)
RETURN SG_BIOENTRY_PATH%ROWTYPE IS
	SELECT t.* FROM SG_BIOENTRY_PATH t
	WHERE
		t.SUBJ_ENT_OID = EntP_SUBJ_ENT_OID
	AND	t.OBJ_ENT_OID = EntP_OBJ_ENT_OID
	AND	t.TRM_OID = EntP_TRM_OID
	AND	t.DISTANCE = EntP_DISTANCE
	;

FUNCTION get_oid(
		SUBJ_ENT_OID	IN SG_BIOENTRY_PATH.SUBJ_ENT_OID%TYPE,
		TRM_OID	IN SG_BIOENTRY_PATH.TRM_OID%TYPE,
		OBJ_ENT_OID	IN SG_BIOENTRY_PATH.OBJ_ENT_OID%TYPE,
		EntP_DISTANCE	IN SG_BIOENTRY_PATH.DISTANCE%TYPE,
		Trm_NAME	IN SG_TERM.NAME%TYPE DEFAULT NULL,
		ONT_OID	IN SG_TERM.ONT_OID%TYPE DEFAULT NULL,
		ONT_NAME	IN SG_ONTOLOGY.NAME%TYPE DEFAULT NULL,
		Trm_IDENTIFIER	IN SG_TERM.IDENTIFIER%TYPE DEFAULT NULL,
		Subj_Ent_IDENTIFIER	IN SG_BIOENTRY.IDENTIFIER%TYPE DEFAULT NULL,
		Subj_Ent_ACCESSION	IN SG_BIOENTRY.ACCESSION%TYPE DEFAULT NULL,
		Subj_DB_OID	IN SG_BIOENTRY.DB_OID%TYPE DEFAULT NULL,
		Subj_Ent_VERSION	IN SG_BIOENTRY.VERSION%TYPE DEFAULT NULL,
		Obj_Ent_IDENTIFIER	IN SG_BIOENTRY.IDENTIFIER%TYPE DEFAULT NULL,
		Obj_Ent_ACCESSION	IN SG_BIOENTRY.ACCESSION%TYPE DEFAULT NULL,
		Obj_DB_OID	IN SG_BIOENTRY.DB_OID%TYPE DEFAULT NULL,
		Obj_Ent_VERSION	IN SG_BIOENTRY.VERSION%TYPE DEFAULT NULL,
		do_DML		IN NUMBER DEFAULT BSStd.DML_NO)
RETURN INTEGER
IS
	pk	INTEGER DEFAULT NULL;
	EntP_row EntP_c%ROWTYPE;
	SUBJ_ENT_OID_	SG_BIOENTRY.OID%TYPE DEFAULT SUBJ_ENT_OID;
	OBJ_ENT_OID_	SG_BIOENTRY.OID%TYPE DEFAULT OBJ_ENT_OID;
	TRM_OID_	SG_TERM.OID%TYPE DEFAULT TRM_OID;
	key_str	VARCHAR2(1024) DEFAULT EntP_DISTANCE || '|' || Trm_NAME || '|' || ONT_OID || '|' || ONT_NAME || '|' || Trm_IDENTIFIER || '|' || Subj_Ent_IDENTIFIER || '|' || Subj_Ent_ACCESSION || '|' || Subj_DB_OID || '|' || Subj_Ent_VERSION || '|' || Obj_Ent_IDENTIFIER || '|' || Obj_Ent_ACCESSION || '|' || Obj_DB_OID || '|' || Obj_Ent_VERSION;
BEGIN
	-- initialize
	-- look up
	IF pk IS NULL THEN
		IF (key_str = cache_key) THEN
			pk := EntP_cached;
		ELSE
			-- reset cache
			cache_key := NULL;
			EntP_cached := NULL;
                	-- look up SG_TERM
                	IF (TRM_OID_ IS NULL) THEN
                		TRM_OID_ := Trm.get_oid(
                			Trm_NAME => Trm_NAME,
                			ONT_OID => ONT_OID,
                			ONT_NAME => ONT_NAME,
                			Trm_IDENTIFIER => Trm_IDENTIFIER);
                	END IF;
                	-- look up SG_BIOENTRY subject
                	IF (SUBJ_ENT_OID_ IS NULL) THEN
                		SUBJ_ENT_OID_ := Ent.get_oid(
                			Ent_IDENTIFIER => Subj_Ent_IDENTIFIER,
                			Ent_ACCESSION => Subj_Ent_ACCESSION,
                			DB_OID => Subj_DB_OID,
                			Ent_VERSION => Subj_Ent_VERSION);
                	END IF;
                	-- look up SG_BIOENTRY object
                	IF (OBJ_ENT_OID_ IS NULL) THEN
                		OBJ_ENT_OID_ := Ent.get_oid(
                			Ent_IDENTIFIER => Obj_Ent_IDENTIFIER,
                			Ent_ACCESSION => Obj_Ent_ACCESSION,
                			DB_OID => Obj_DB_OID,
                			Ent_VERSION => Obj_Ent_VERSION);
                	END IF;
			-- do the look up
			FOR EntP_row IN EntP_c(SUBJ_ENT_OID_, OBJ_ENT_OID_, TRM_OID_, EntP_DISTANCE) LOOP
		        	pk := 1;
				-- cache result
			    	cache_key := key_str;
			    	EntP_cached := pk;
			END LOOP;
		END IF;
	END IF;
	-- insert/update if requested
	IF (pk IS NULL) AND 
	   ((do_DML = BSStd.DML_I) OR (do_DML = BSStd.DML_UI)) THEN
	    	-- look up foreign keys if not provided:
		-- look up SG_TERM successful?
		IF (TRM_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Trm <' || Trm_NAME || '|' || ONT_OID || '|' || ONT_NAME || '|' || Trm_IDENTIFIER || '>');
		END IF;
		-- look up SG_BIOENTRY subject successful
		IF (SUBJ_ENT_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Ent <' || Subj_Ent_IDENTIFIER || '|' || Subj_Ent_ACCESSION || '|' || Subj_DB_OID || '|' || Subj_Ent_VERSION || '>');
		END IF;
		-- look up SG_BIOENTRY object successful?
		IF (OBJ_ENT_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Ent <' || Obj_Ent_IDENTIFIER || '|' || Obj_Ent_ACCESSION || '|' || Obj_DB_OID || '|' || Obj_Ent_VERSION || '>');
		END IF;
	    	-- insert the record and obtain the primary key
	    	pk := do_insert(
		        SUBJ_ENT_OID => SUBJ_ENT_OID_,
			TRM_OID => TRM_OID_,
			OBJ_ENT_OID => OBJ_ENT_OID_,
			DISTANCE => EntP_DISTANCE);
	END IF; -- no update here
	-- return TRUE or FALSE (NULL)
	RETURN pk;
END;

FUNCTION do_insert(
		SUBJ_ENT_OID	IN SG_BIOENTRY_PATH.SUBJ_ENT_OID%TYPE,
		TRM_OID	IN SG_BIOENTRY_PATH.TRM_OID%TYPE,
		OBJ_ENT_OID	IN SG_BIOENTRY_PATH.OBJ_ENT_OID%TYPE,
		DISTANCE	IN SG_BIOENTRY_PATH.DISTANCE%TYPE)
RETURN INTEGER
IS
BEGIN
	-- insert the record
	INSERT INTO SG_BIOENTRY_PATH (
		SUBJ_ENT_OID,
		TRM_OID,
		OBJ_ENT_OID,
		DISTANCE)
	VALUES (
		SUBJ_ENT_OID,
		TRM_OID,
		OBJ_ENT_OID,
		DISTANCE)
	;
	-- return TRUE
	RETURN 1;
END;

END EntP;
/

