-- -*-Sql-*- mode (to keep my emacs happy)
--
-- API Package Body for Bioentry_Ref_Assoc.
--
-- Scaffold auto-generated by gen-api.pl. gen-api.pl is
-- Copyright 2002-2003 Genomics Institute of the Novartis Research Foundation
-- Copyright 2002-2008 Hilmar Lapp
-- 
--  This file is part of BioSQL.
--
--  BioSQL is free software: you can redistribute it and/or modify it
--  under the terms of the GNU Lesser General Public License as
--  published by the Free Software Foundation, either version 3 of the
--  License, or (at your option) any later version.
--
--  BioSQL is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU Lesser General Public License for more details.
--
--  You should have received a copy of the GNU Lesser General Public License
--  along with BioSQL. If not, see <http://www.gnu.org/licenses/>.
--

CREATE OR REPLACE
PACKAGE BODY EntRefA IS

CURSOR EntRefA_c (
		EntRefA_ENT_OID	IN SG_BIOENTRY_REF_ASSOC.ENT_OID%TYPE,
		EntRefA_REF_OID	IN SG_BIOENTRY_REF_ASSOC.REF_OID%TYPE,
		EntRefA_RANK	IN SG_BIOENTRY_REF_ASSOC.RANK%TYPE)
RETURN SG_BIOENTRY_REF_ASSOC%ROWTYPE IS
	SELECT t.* FROM SG_BIOENTRY_REF_ASSOC t
	WHERE
		t.Ent_Oid = EntRefA_ENT_OID
	AND	t.Ref_Oid = EntRefA_REF_OID
	AND	t.Rank    = EntRefA_RANK
	;

FUNCTION get_oid(
		ENT_OID	IN SG_BIOENTRY_REF_ASSOC.ENT_OID%TYPE DEFAULT NULL,
		REF_OID	IN SG_BIOENTRY_REF_ASSOC.REF_OID%TYPE DEFAULT NULL,
		EntRefA_RANK	IN SG_BIOENTRY_REF_ASSOC.RANK%TYPE DEFAULT NULL,
		EntRefA_END_POS	IN SG_BIOENTRY_REF_ASSOC.END_POS%TYPE DEFAULT NULL,
		EntRefA_START_POS	IN SG_BIOENTRY_REF_ASSOC.START_POS%TYPE DEFAULT NULL,
		DBX_OID	IN SG_REFERENCE.DBX_OID%TYPE DEFAULT NULL,
		Ref_CRC	IN SG_REFERENCE.CRC%TYPE DEFAULT NULL,
		Ent_IDENTIFIER	IN SG_BIOENTRY.IDENTIFIER%TYPE DEFAULT NULL,
		Ent_ACCESSION	IN SG_BIOENTRY.ACCESSION%TYPE DEFAULT NULL,
		Ent_DB_OID	IN SG_BIOENTRY.DB_OID%TYPE DEFAULT NULL,
		Ent_VERSION	IN SG_BIOENTRY.VERSION%TYPE DEFAULT NULL,
		DB_OID		IN SG_BIOENTRY.DB_OID%TYPE DEFAULT NULL,
		DB_NAME		IN SG_BIODATABASE.NAME%TYPE DEFAULT NULL,
		DB_ACRONYM	IN SG_BIODATABASE.ACRONYM%TYPE DEFAULT NULL,
		do_DML		IN NUMBER DEFAULT BSStd.DML_NO)
RETURN INTEGER
IS
	pk	INTEGER DEFAULT NULL;
	EntRefA_row EntRefA_c%ROWTYPE;
	REF_OID_	SG_REFERENCE.OID%TYPE DEFAULT REF_OID;
	ENT_OID_	SG_BIOENTRY.OID%TYPE DEFAULT ENT_OID;
BEGIN
	-- look up SG_REFERENCE
	IF (REF_OID_ IS NULL) THEN
		REF_OID_ := LRef.get_oid(
				DBX_OID => DBX_OID,
				Ref_CRC => Ref_CRC);
	END IF;
	-- look up SG_BIOENTRY
	IF (ENT_OID_ IS NULL) THEN
		ENT_OID_ := Ent.get_oid(
				Ent_ACCESSION => Ent_ACCESSION,
				Ent_VERSION => Ent_VERSION,
				Ent_IDENTIFIER => Ent_IDENTIFIER,
				DB_OID => DB_OID,
				DB_NAME => DB_NAME,
				DB_ACRONYM => DB_ACRONYM);
	END IF;
	-- look up
	FOR EntRefA_row IN EntRefA_c (Ent_Oid_, Ref_Oid_, EntRefA_Rank) LOOP
	        pk := 1;
	END LOOP;
	-- insert/update if requested
	IF (pk IS NULL) AND 
	   ((do_DML = BSStd.DML_I) OR (do_DML = BSStd.DML_UI)) THEN
	    	-- look up foreign keys if not provided:
		-- look up SG_REFERENCE successful?
		IF (REF_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Ref <' || DBX_OID || '|' || Ref_CRC || '>');
		END IF;
		-- look up SG_BIOENTRY successful?
		IF (ENT_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Ent <' || Ent_ACCESSION || '|' || Ent_VERSION || '|' || DB_OID || '|' || Ent_IDENTIFIER || '>');
		END IF;
	    	-- insert the record and obtain the primary key
	    	pk := do_insert(
			ENT_OID => ENT_OID_,
		        REF_OID => REF_OID_,
			RANK => EntRefA_RANK,
			END_POS => EntRefA_END_POS,
			START_POS => EntRefA_START_POS);
	ELSIF (do_DML = BSStd.DML_U) OR (do_DML = BSStd.DML_UI) THEN
	        -- update the record (note that not provided FKs will not
		-- be changed nor looked up)
		do_update(
			EntRefA_ENT_OID	=> ENT_OID_,
		        EntRefA_REF_OID => REF_OID_,
			EntRefA_RANK => EntRefA_RANK,
			EntRefA_END_POS => EntRefA_END_POS,
			EntRefA_START_POS => EntRefA_START_POS);
	END IF;
	-- return the primary key
	RETURN pk;
END;

FUNCTION do_insert(
		ENT_OID	IN SG_BIOENTRY_REF_ASSOC.ENT_OID%TYPE,
		REF_OID	IN SG_BIOENTRY_REF_ASSOC.REF_OID%TYPE,
		RANK	IN SG_BIOENTRY_REF_ASSOC.RANK%TYPE,
		END_POS	IN SG_BIOENTRY_REF_ASSOC.END_POS%TYPE,
		START_POS	IN SG_BIOENTRY_REF_ASSOC.START_POS%TYPE)
RETURN INTEGER
IS
BEGIN
	-- insert the record
	INSERT INTO SG_BIOENTRY_REF_ASSOC (
		ENT_OID,
		REF_OID,
		RANK,
		END_POS,
		START_POS)
	VALUES (ENT_OID,
		REF_OID,
		RANK,
		END_POS,
		START_POS)
	;
	-- return TRUE
	RETURN 1;
END;

PROCEDURE do_update(
		EntRefA_ENT_OID	IN SG_BIOENTRY_REF_ASSOC.ENT_OID%TYPE,
		EntRefA_REF_OID	IN SG_BIOENTRY_REF_ASSOC.REF_OID%TYPE,
		EntRefA_RANK	IN SG_BIOENTRY_REF_ASSOC.RANK%TYPE,
		EntRefA_END_POS	IN SG_BIOENTRY_REF_ASSOC.END_POS%TYPE,
		EntRefA_START_POS	IN SG_BIOENTRY_REF_ASSOC.START_POS%TYPE)
IS
BEGIN
	-- update the record (and leave attributes passed as NULL untouched)
	UPDATE SG_BIOENTRY_REF_ASSOC
	SET
		END_POS = NVL(EntRefA_END_POS, END_POS),
		START_POS = NVL(EntRefA_START_POS, START_POS)
	WHERE ENT_OID = EntRefA_ENT_OID
	AND   REF_OID = EntRefA_REF_OID
	AND   RANK    = EntRefA_RANK
	;
END;

END EntRefA;
/

