-- -*-Sql-*- mode (to keep my emacs happy)
--
-- API Package Body for Seqfeature_Path.
--
-- Scaffold auto-generated by gen-api.pl. gen-api.pl is
-- Copyright 2002-2003 Genomics Institute of the Novartis Research Foundation
-- Copyright 2002-2008 Hilmar Lapp
-- 
--  This file is part of BioSQL.
--
--  BioSQL is free software: you can redistribute it and/or modify it
--  under the terms of the GNU Lesser General Public License as
--  published by the Free Software Foundation, either version 3 of the
--  License, or (at your option) any later version.
--
--  BioSQL is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU Lesser General Public License for more details.
--
--  You should have received a copy of the GNU Lesser General Public License
--  along with BioSQL. If not, see <http://www.gnu.org/licenses/>.
--

CREATE OR REPLACE
PACKAGE BODY FeaP IS

FeaP_cached	INTEGER DEFAULT NULL;
cache_key		VARCHAR2(1024) DEFAULT NULL;

CURSOR FeaP_c (
		FeaP_SUBJ_FEA_OID	IN SG_SEQFEATURE_PATH.SUBJ_FEA_OID%TYPE,
		FeaP_OBJ_FEA_OID	IN SG_SEQFEATURE_PATH.OBJ_FEA_OID%TYPE,
		FeaP_TRM_OID	IN SG_SEQFEATURE_PATH.TRM_OID%TYPE,
		FeaP_DISTANCE	IN SG_SEQFEATURE_PATH.DISTANCE%TYPE)
RETURN SG_SEQFEATURE_PATH%ROWTYPE IS
	SELECT t.* FROM SG_SEQFEATURE_PATH t
	WHERE
		t.SUBJ_FEA_OID = FeaP_SUBJ_FEA_OID
	AND	t.OBJ_FEA_OID = FeaP_OBJ_FEA_OID
	AND	t.TRM_OID = FeaP_TRM_OID
	AND	t.DISTANCE = FeaP_DISTANCE
	;

FUNCTION get_oid(
		SUBJ_FEA_OID	IN SG_SEQFEATURE_PATH.SUBJ_FEA_OID%TYPE,
		TRM_OID	IN SG_SEQFEATURE_PATH.TRM_OID%TYPE,
		OBJ_FEA_OID	IN SG_SEQFEATURE_PATH.OBJ_FEA_OID%TYPE,
		FeaP_DISTANCE	IN SG_SEQFEATURE_PATH.DISTANCE%TYPE,
		Subj_Fea_ENT_OID	IN SG_SEQFEATURE.ENT_OID%TYPE DEFAULT NULL,
		Subj_TYPE_TRM_OID	IN SG_SEQFEATURE.TYPE_TRM_OID%TYPE DEFAULT NULL,
		Subj_SOURCE_TRM_OID	IN SG_SEQFEATURE.SOURCE_TRM_OID%TYPE DEFAULT NULL,
		Subj_Fea_RANK	IN SG_SEQFEATURE.RANK%TYPE DEFAULT NULL,
		Obj_Fea_ENT_OID	IN SG_SEQFEATURE.ENT_OID%TYPE DEFAULT NULL,
		Obj_TYPE_TRM_OID	IN SG_SEQFEATURE.TYPE_TRM_OID%TYPE DEFAULT NULL,
		Obj_SOURCE_TRM_OID	IN SG_SEQFEATURE.SOURCE_TRM_OID%TYPE DEFAULT NULL,
		Obj_Fea_RANK	IN SG_SEQFEATURE.RANK%TYPE DEFAULT NULL,
		Trm_NAME	IN SG_TERM.NAME%TYPE DEFAULT NULL,
		Trm_ONT_OID	IN SG_TERM.ONT_OID%TYPE DEFAULT NULL,
		Trm_ONT_NAME	IN SG_ONTOLOGY.NAME%TYPE DEFAULT NULL,
		Trm_IDENTIFIER	IN SG_TERM.IDENTIFIER%TYPE DEFAULT NULL,
		do_DML		IN NUMBER DEFAULT BSStd.DML_NO)
RETURN INTEGER
IS
	pk	INTEGER DEFAULT NULL;
	FeaP_row FeaP_c%ROWTYPE;
	SUBJ_FEA_OID_	SG_SEQFEATURE.OID%TYPE DEFAULT SUBJ_FEA_OID;
	OBJ_FEA_OID_	SG_SEQFEATURE.OID%TYPE DEFAULT OBJ_FEA_OID;
	TRM_OID_	SG_TERM.OID%TYPE DEFAULT TRM_OID;
	key_str	VARCHAR2(1024) DEFAULT Subj_FEA_OID || '|' || Obj_FEA_OID || '|' || Trm_OID || '|' || FeaP_DISTANCE || '|' || Obj_Fea_ENT_OID || '|' || Obj_TYPE_TRM_OID || '|' || Obj_SOURCE_TRM_OID || '|' || Obj_Fea_RANK || '|' || Subj_Fea_ENT_OID || '|' || Subj_TYPE_TRM_OID || '|' || Subj_SOURCE_TRM_OID || '|' || Subj_Fea_RANK || '|' || Trm_NAME || '|' || Trm_ONT_OID || '|' || Trm_ONT_NAME || '|' || Trm_IDENTIFIER;
BEGIN
	-- initialize
	-- look up
	IF pk IS NULL THEN
		IF (key_str = cache_key) THEN
			pk := FeaP_cached;
		ELSE
			-- reset cache
			cache_key := NULL;
			FeaP_cached := NULL;
                	-- look up SG_SEQFEATURE object
                	IF (OBJ_FEA_OID_ IS NULL) THEN
                		OBJ_FEA_OID_ := Fea.get_oid(
                			ENT_OID => Obj_Fea_ENT_OID,
                			TYPE_TRM_OID => Obj_TYPE_TRM_OID,
                			SOURCE_TRM_OID => Obj_SOURCE_TRM_OID,
                			Fea_RANK => Obj_Fea_RANK);
                	END IF;
                	-- look up SG_SEQFEATURE subject
                	IF (SUBJ_FEA_OID_ IS NULL) THEN
                		SUBJ_FEA_OID_ := Fea.get_oid(
                			ENT_OID => Subj_Fea_ENT_OID,
                			TYPE_TRM_OID => Subj_TYPE_TRM_OID,
                			SOURCE_TRM_OID => Subj_SOURCE_TRM_OID,
                			Fea_RANK => Subj_Fea_RANK);
                	END IF;
                	-- look up SG_TERM
                	IF (TRM_OID_ IS NULL) THEN
                		TRM_OID_ := Trm.get_oid(
                			Trm_NAME => Trm_NAME,
                			ONT_OID => Trm_ONT_OID,
                			ONT_NAME => Trm_ONT_NAME,
                			Trm_IDENTIFIER => Trm_IDENTIFIER);
                	END IF;
			-- do the look up
			FOR FeaP_row IN FeaP_c(SUBJ_FEA_OID_, OBJ_FEA_OID_, TRM_OID_, FeaP_DISTANCE) LOOP
		        	pk := 1;
				-- cache result
			    	cache_key := key_str;
			    	FeaP_cached := pk;
			END LOOP;
		END IF;
	END IF;
	-- insert/update if requested
	IF (pk IS NULL) AND 
	   ((do_DML = BSStd.DML_I) OR (do_DML = BSStd.DML_UI)) THEN
	    	-- look up foreign keys if not provided:
		-- look up SG_SEQFEATURE object successful?
		IF (OBJ_FEA_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Fea <' || Obj_Fea_ENT_OID || '|' || Obj_TYPE_TRM_OID || '|' || Obj_SOURCE_TRM_OID || '|' || Obj_Fea_RANK || '>');
		END IF;
		-- look up SG_SEQFEATURE subject successful?
		IF (SUBJ_FEA_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Fea <' || Subj_Fea_ENT_OID || '|' || Subj_TYPE_TRM_OID || '|' || Subj_SOURCE_TRM_OID || '|' || Subj_Fea_RANK || '>');
		END IF;
		-- look up SG_TERM successful?
		IF (TRM_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Trm <' || Trm_NAME || '|' || Trm_ONT_OID || '|' || Trm_ONT_NAME || '|' || Trm_IDENTIFIER || '>');
		END IF;
	    	-- insert the record and obtain the primary key
	    	pk := do_insert(
		        SUBJ_FEA_OID => SUBJ_FEA_OID_,
			TRM_OID => TRM_OID_,
			OBJ_FEA_OID => OBJ_FEA_OID_,
			DISTANCE => FeaP_DISTANCE);
	END IF; -- no update here
	-- return the primary key
	RETURN pk;
END;

FUNCTION do_insert(
		SUBJ_FEA_OID	IN SG_SEQFEATURE_PATH.SUBJ_FEA_OID%TYPE,
		TRM_OID	IN SG_SEQFEATURE_PATH.TRM_OID%TYPE,
		OBJ_FEA_OID	IN SG_SEQFEATURE_PATH.OBJ_FEA_OID%TYPE,
		DISTANCE	IN SG_SEQFEATURE_PATH.DISTANCE%TYPE)
RETURN INTEGER
IS
BEGIN
	-- insert the record
	INSERT INTO SG_SEQFEATURE_PATH (
		SUBJ_FEA_OID,
		TRM_OID,
		OBJ_FEA_OID,
		DISTANCE)
	VALUES (
		SUBJ_FEA_OID,
		TRM_OID,
		OBJ_FEA_OID,
		DISTANCE)
	;
	-- return TRUE
	RETURN 1;
END;

END FeaP;
/

