%% Generated by the Erlang ASN.1 BER compiler. Version: 5.4.2
%% Purpose: Encoding and decoding of the types in PKIXAttributeCertificate-2009.

-module('PKIXAttributeCertificate-2009').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("PKIXAttributeCertificate-2009.hrl").
-asn1_info([{vsn,'5.4.2'},
            {module,'PKIXAttributeCertificate-2009'},
            {options,[{i,"/var/tmp/portage/dev-lang/erlang-28.1/work/otp-OTP-28.1/lib/public_key/asn1/../src"},
 warnings,ber,errors,
 {cwd,"/var/tmp/portage/dev-lang/erlang-28.1/work/otp-OTP-28.1/lib/public_key/asn1"},
 {outdir,"/var/tmp/portage/dev-lang/erlang-28.1/work/otp-OTP-28.1/lib/public_key/asn1/../src"},
 der,noobj,asn1config,
 {i,"."},
 {i,"/var/tmp/portage/dev-lang/erlang-28.1/work/otp-OTP-28.1/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_AttributeCertificate/2,
enc_AttributeCertificateInfo/2,
enc_AttCertVersion/2,
enc_Holder/2,
enc_ObjectDigestInfo/2,
enc_AttCertIssuer/2,
enc_V2Form/2,
enc_IssuerSerial/2,
enc_AttCertValidityPeriod/2,
enc_Targets/2,
enc_Target/2,
enc_TargetCert/2,
enc_AAControls/2,
enc_AttrSpec/2,
enc_ProxyInfo/2,
enc_IetfAttrSyntax/2,
enc_SvceAuthInfo/2,
enc_RoleSyntax/2,
enc_Clearance/2,
'enc_Clearance-rfc3281'/2,
enc_ClassList/2,
enc_ACClearAttrs/2
]).

-export([
dec_AttributeCertificate/2,
dec_AttributeCertificateInfo/2,
dec_AttCertVersion/2,
dec_Holder/2,
dec_ObjectDigestInfo/2,
dec_AttCertIssuer/2,
dec_V2Form/2,
dec_IssuerSerial/2,
dec_AttCertValidityPeriod/2,
dec_Targets/2,
dec_Target/2,
dec_TargetCert/2,
dec_AAControls/2,
dec_AttrSpec/2,
dec_ProxyInfo/2,
dec_IetfAttrSyntax/2,
dec_SvceAuthInfo/2,
dec_RoleSyntax/2,
dec_Clearance/2,
'dec_Clearance-rfc3281'/2,
dec_ClassList/2,
dec_ACClearAttrs/2
]).

-export([
'enc_ext-auditIdentity'/3,
'enc_ext-targetInformation'/3,
'enc_ext-noRevAvail'/3,
'enc_ext-ac-proxying'/3,
'enc_ext-aaControls'/3,
'enc_at-authenticationInfo'/3,
'enc_at-accesIdentity'/3,
'enc_at-chargingIdentity'/3,
'enc_at-group'/3,
'enc_at-role'/3,
'enc_at-clearance'/3,
'enc_at-clearance-RFC3281'/3,
'enc_at-encAttrs'/3
]).

-export([
'dec_ext-auditIdentity'/3,
'dec_ext-targetInformation'/3,
'dec_ext-noRevAvail'/3,
'dec_ext-ac-proxying'/3,
'dec_ext-aaControls'/3,
'dec_at-authenticationInfo'/3,
'dec_at-accesIdentity'/3,
'dec_at-chargingIdentity'/3,
'dec_at-group'/3,
'dec_at-role'/3,
'dec_at-clearance'/3,
'dec_at-clearance-RFC3281'/3,
'dec_at-encAttrs'/3
]).

-export([
getenc_AttributeCertExtensions/1,
getenc_AttributesDefined/1,
getenc_SupportedSecurityCategories/1,
getenc_internal_object_set_argument_9/1,
getenc_internal_object_set_argument_8/1,
getenc_internal_object_set_argument_7/1,
getenc_internal_object_set_argument_6/1,
getenc_internal_object_set_argument_5/1,
getenc_internal_object_set_argument_3/1,
getenc_internal_object_set_argument_11/1,
getenc_internal_object_set_argument_10/1
]).

-export([
getdec_AttributeCertExtensions/1,
getdec_AttributesDefined/1,
getdec_SupportedSecurityCategories/1,
getdec_internal_object_set_argument_9/1,
getdec_internal_object_set_argument_8/1,
getdec_internal_object_set_argument_7/1,
getdec_internal_object_set_argument_6/1,
getdec_internal_object_set_argument_5/1,
getdec_internal_object_set_argument_3/1,
getdec_internal_object_set_argument_11/1,
getdec_internal_object_set_argument_10/1
]).

-export([
'id-pe-ac-auditIdentity'/0,
'id-pe-aaControls'/0,
'id-pe-ac-proxying'/0,
'id-ce-targetInformation'/0,
'id-ce-noRevAvail'/0,
'id-aca'/0,
'id-aca-authenticationInfo'/0,
'id-aca-accessIdentity'/0,
'id-aca-chargingIdentity'/0,
'id-aca-group'/0,
'id-aca-encAttrs'/0,
'id-at-role'/0,
'id-at-clearance'/0,
'id-at-clearance-rfc3281'/0
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('AttributeCertificate', Data) -> enc_AttributeCertificate(Data);
encode_disp('AttributeCertificateInfo', Data) -> enc_AttributeCertificateInfo(Data);
encode_disp('AttCertVersion', Data) -> enc_AttCertVersion(Data);
encode_disp('Holder', Data) -> enc_Holder(Data);
encode_disp('ObjectDigestInfo', Data) -> enc_ObjectDigestInfo(Data);
encode_disp('AttCertIssuer', Data) -> enc_AttCertIssuer(Data);
encode_disp('V2Form', Data) -> enc_V2Form(Data);
encode_disp('IssuerSerial', Data) -> enc_IssuerSerial(Data);
encode_disp('AttCertValidityPeriod', Data) -> enc_AttCertValidityPeriod(Data);
encode_disp('Targets', Data) -> enc_Targets(Data);
encode_disp('Target', Data) -> enc_Target(Data);
encode_disp('TargetCert', Data) -> enc_TargetCert(Data);
encode_disp('AAControls', Data) -> enc_AAControls(Data);
encode_disp('AttrSpec', Data) -> enc_AttrSpec(Data);
encode_disp('ProxyInfo', Data) -> enc_ProxyInfo(Data);
encode_disp('IetfAttrSyntax', Data) -> enc_IetfAttrSyntax(Data);
encode_disp('SvceAuthInfo', Data) -> enc_SvceAuthInfo(Data);
encode_disp('RoleSyntax', Data) -> enc_RoleSyntax(Data);
encode_disp('Clearance', Data) -> enc_Clearance(Data);
encode_disp('Clearance-rfc3281', Data) -> 'enc_Clearance-rfc3281'(Data);
encode_disp('ClassList', Data) -> enc_ClassList(Data);
encode_disp('ACClearAttrs', Data) -> enc_ACClearAttrs(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('AttributeCertificate', Data) -> dec_AttributeCertificate(Data);
decode_disp('AttributeCertificateInfo', Data) -> dec_AttributeCertificateInfo(Data);
decode_disp('AttCertVersion', Data) -> dec_AttCertVersion(Data);
decode_disp('Holder', Data) -> dec_Holder(Data);
decode_disp('ObjectDigestInfo', Data) -> dec_ObjectDigestInfo(Data);
decode_disp('AttCertIssuer', Data) -> dec_AttCertIssuer(Data);
decode_disp('V2Form', Data) -> dec_V2Form(Data);
decode_disp('IssuerSerial', Data) -> dec_IssuerSerial(Data);
decode_disp('AttCertValidityPeriod', Data) -> dec_AttCertValidityPeriod(Data);
decode_disp('Targets', Data) -> dec_Targets(Data);
decode_disp('Target', Data) -> dec_Target(Data);
decode_disp('TargetCert', Data) -> dec_TargetCert(Data);
decode_disp('AAControls', Data) -> dec_AAControls(Data);
decode_disp('AttrSpec', Data) -> dec_AttrSpec(Data);
decode_disp('ProxyInfo', Data) -> dec_ProxyInfo(Data);
decode_disp('IetfAttrSyntax', Data) -> dec_IetfAttrSyntax(Data);
decode_disp('SvceAuthInfo', Data) -> dec_SvceAuthInfo(Data);
decode_disp('RoleSyntax', Data) -> dec_RoleSyntax(Data);
decode_disp('Clearance', Data) -> dec_Clearance(Data);
decode_disp('Clearance-rfc3281', Data) -> 'dec_Clearance-rfc3281'(Data);
decode_disp('ClassList', Data) -> dec_ClassList(Data);
decode_disp('ACClearAttrs', Data) -> dec_ACClearAttrs(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  AttributeCertificate
%%================================
enc_AttributeCertificate(Val) ->
    enc_AttributeCertificate(Val, [<<48>>]).

enc_AttributeCertificate(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute toBeSigned(1)   External PKIXAttributeCertificate-2009:AttributeCertificateInfo
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_AttributeCertificateInfo'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute algorithmIdentifier(2) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AttributeCertificate_algorithmIdentifier'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_unnamed_bit_string(Cindex3, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  AttributeCertificate_algorithmIdentifier
%%================================
enc_AttributeCertificate_algorithmIdentifier(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIX1Explicit-2009':'getenc_SignatureAlgorithms'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AttributeCertificate(Tlv) ->
   dec_AttributeCertificate(Tlv, [16]).

dec_AttributeCertificate(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute toBeSigned(1)   External PKIXAttributeCertificate-2009:AttributeCertificateInfo
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_AttributeCertificateInfo'(V1, [16]),

%%-------------------------------------------------
%% attribute algorithmIdentifier(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AttributeCertificate_algorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_native_bit_string(V3, [3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'AttributeCertificate',Term1,Term2,Term3},
Res1.
'dec_AttributeCertificate_algorithmIdentifier'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIX1Explicit-2009':'getdec_SignatureAlgorithms'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AttributeCertificate_algorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  AttributeCertificateInfo
%%================================
enc_AttributeCertificateInfo(Val) ->
    enc_AttributeCertificateInfo(Val, [<<48>>]).

enc_AttributeCertificateInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6,Cindex7,Cindex8,Cindex9} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{v2,1}], [<<2>>]),

%%-------------------------------------------------
%% attribute holder(2)   External PKIXAttributeCertificate-2009:Holder
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_Holder'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute issuer(3)   External PKIXAttributeCertificate-2009:AttCertIssuer
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_AttCertIssuer'(Cindex3, []),

%%-------------------------------------------------
%% attribute signature(4) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_AttributeCertificateInfo_signature'(Cindex4, [<<48>>]),

%%-------------------------------------------------
%% attribute serialNumber(5) with type INTEGER
%%-------------------------------------------------
   {EncBytes5,EncLen5} = encode_integer(Cindex5, [<<2>>]),

%%-------------------------------------------------
%% attribute attrCertValidityPeriod(6)   External PKIXAttributeCertificate-2009:AttCertValidityPeriod
%%-------------------------------------------------
   {EncBytes6,EncLen6} = 'enc_AttCertValidityPeriod'(Cindex6, [<<48>>]),

%%-------------------------------------------------
%% attribute attributes(7) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes7,EncLen7} = 'enc_AttributeCertificateInfo_attributes'(Cindex7, [<<48>>]),

%%-------------------------------------------------
%% attribute issuerUniqueID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes8,EncLen8} =  case Cindex8 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_unnamed_bit_string(Cindex8, [<<3>>])
       end,

%%-------------------------------------------------
%% attribute extensions(9) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes9,EncLen9} =  case Cindex9 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_AttributeCertificateInfo_extensions'(Cindex9, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7, EncBytes8, EncBytes9],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7 + EncLen8 + EncLen9,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  AttributeCertificateInfo_signature
%%================================
enc_AttributeCertificateInfo_signature(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXAttributeCertificate-2009':'getenc_internal_object_set_argument_5'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  AttributeCertificateInfo_attributes
%%================================
enc_AttributeCertificateInfo_attributes(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_AttributeCertificateInfo_attributes_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_AttributeCertificateInfo_attributes_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AttributeCertificateInfo_attributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_AttributeCertificateInfo_attributes_AttributeSet'(H, [<<48>>]),
   'enc_AttributeCertificateInfo_attributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  AttributeCertificateInfo_attributes_AttributeSet
%%================================
enc_AttributeCertificateInfo_attributes_AttributeSet(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objtype = 
   'PKIXAttributeCertificate-2009':'getenc_internal_object_set_argument_6'(                                   Cindex1),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AttributeCertificateInfo_attributes_AttributeSet_values'(Cindex2, [<<49>>], Objtype),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  AttributeCertificateInfo_attributes_AttributeSet_values
%%================================
enc_AttributeCertificateInfo_attributes_AttributeSet_values(Val, TagIn, ObjFun) ->
      {EncBytes,EncLen} = 'enc_AttributeCertificateInfo_attributes_AttributeSet_values_components'(Val, ObjFun,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_AttributeCertificateInfo_attributes_AttributeSet_values_components'([], _, AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_AttributeCertificateInfo_attributes_AttributeSet_values_components'([H|T], ObjFun,AccBytes, AccLen) ->
   {TmpBytes,_} = ObjFun('Type', H, []),
   {EncBytes,EncLen} = encode_open_type(TmpBytes, [])
,
   'enc_AttributeCertificateInfo_attributes_AttributeSet_values_components'(T, ObjFun,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  AttributeCertificateInfo_extensions
%%================================
enc_AttributeCertificateInfo_extensions(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_AttributeCertificateInfo_extensions_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_AttributeCertificateInfo_extensions_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AttributeCertificateInfo_extensions_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_AttributeCertificateInfo_extensions_Extension'(H, [<<48>>]),
   'enc_AttributeCertificateInfo_extensions_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  AttributeCertificateInfo_extensions_Extension
%%================================
enc_AttributeCertificateInfo_extensions_Extension(Val, TagIn) ->
   {_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_1(Cindex2) of
true -> {[],0};
false ->
encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AttributeCertificateInfo(Tlv) ->
   dec_AttributeCertificateInfo(Tlv, [16]).

dec_AttributeCertificateInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v2,1}])
end
,

%%-------------------------------------------------
%% attribute holder(2)   External PKIXAttributeCertificate-2009:Holder
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_Holder'(V2, [16]),

%%-------------------------------------------------
%% attribute issuer(3)   External PKIXAttributeCertificate-2009:AttCertIssuer
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_AttCertIssuer'(V3, []),

%%-------------------------------------------------
%% attribute signature(4) with type SEQUENCE
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_AttributeCertificateInfo_signature'(V4, [16]),

%%-------------------------------------------------
%% attribute serialNumber(5) with type INTEGER
%%-------------------------------------------------
[V5|Tlv6] = Tlv5, 
Term5 = decode_integer(V5, [2]),

%%-------------------------------------------------
%% attribute attrCertValidityPeriod(6)   External PKIXAttributeCertificate-2009:AttCertValidityPeriod
%%-------------------------------------------------
[V6|Tlv7] = Tlv6, 
Term6 = 'dec_AttCertValidityPeriod'(V6, [16]),

%%-------------------------------------------------
%% attribute attributes(7) with type SEQUENCE OF
%%-------------------------------------------------
[V7|Tlv8] = Tlv7, 
Term7 = 'dec_AttributeCertificateInfo_attributes'(V7, [16]),

%%-------------------------------------------------
%% attribute issuerUniqueID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term8,Tlv9} = case Tlv8 of
[{3,V8}|TempTlv9] ->
    {decode_native_bit_string(V8, []), TempTlv9};
    _ ->
        { asn1_NOVALUE, Tlv8}
end,

%%-------------------------------------------------
%% attribute extensions(9) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term9,Tlv10} = case Tlv9 of
[{16,V9}|TempTlv10] ->
    {'dec_AttributeCertificateInfo_extensions'(V9, []), TempTlv10};
    _ ->
        { asn1_NOVALUE, Tlv9}
end,

case Tlv10 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv10}}}) % extra fields not allowed
end,
Res1 = {'AttributeCertificateInfo',Term1,Term2,Term3,Term4,Term5,Term6,Term7,Term8,Term9},
Res1.
'dec_AttributeCertificateInfo_signature'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXAttributeCertificate-2009':'getdec_internal_object_set_argument_5'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AttributeCertificateInfo_signature',Term1,Term2},
Res1.
'dec_AttributeCertificateInfo_attributes'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_AttributeCertificateInfo_attributes_AttributeSet'(V1, [16]) || V1 <- Tlv1].


'dec_AttributeCertificateInfo_attributes_AttributeSet'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),
ObjFun = 'PKIXAttributeCertificate-2009':'getdec_internal_object_set_argument_6'(Term1),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AttributeCertificateInfo_attributes_AttributeSet_values'(V2, [17], ObjFun),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AttributeSet',Term1,Term2},
Res1.
'dec_AttributeCertificateInfo_attributes_AttributeSet_values'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[
      begin
         Tmptlv1 = decode_open_type(V1, []),
         case (catch ObjFun('Type', Tmptlv1, [])) of
            {'EXIT',Reason1} ->
               exit({'Type not compatible with table constraint', Reason1});
            Tmpterm1 ->
               Tmpterm1
         end
      end
 || V1 <- Tlv1].


'dec_AttributeCertificateInfo_extensions'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_AttributeCertificateInfo_extensions_Extension'(V1, [16]) || V1 <- Tlv1].


'dec_AttributeCertificateInfo_extensions_Extension'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Extension',Term1,Term2,Term3},
Res1.


%%================================
%%  AttCertVersion
%%================================
enc_AttCertVersion(Val) ->
    enc_AttCertVersion(Val, [<<2>>]).

enc_AttCertVersion(Val, TagIn) ->
encode_integer(Val, [{v2,1}], TagIn).


dec_AttCertVersion(Tlv) ->
   dec_AttCertVersion(Tlv, [2]).

dec_AttCertVersion(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
number2name(Val1, [{v2,1}])
end
.



%%================================
%%  Holder
%%================================
enc_Holder(Val) ->
    enc_Holder(Val, [<<48>>]).

enc_Holder(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute baseCertificateID(1)   External PKIXAttributeCertificate-2009:IssuerSerial OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_IssuerSerial'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute entityName(2)   External PKIX1Implicit-2009:GeneralNames OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Implicit-2009':'enc_GeneralNames'(Cindex2, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute objectDigestInfo(3)   External PKIXAttributeCertificate-2009:ObjectDigestInfo OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ObjectDigestInfo'(Cindex3, [<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_Holder(Tlv) ->
   dec_Holder(Tlv, [16]).

dec_Holder(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute baseCertificateID(1)   External PKIXAttributeCertificate-2009:IssuerSerial OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_IssuerSerial'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute entityName(2)   External PKIX1Implicit-2009:GeneralNames OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralNames'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute objectDigestInfo(3)   External PKIXAttributeCertificate-2009:ObjectDigestInfo OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_ObjectDigestInfo'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Holder',Term1,Term2,Term3},
Res1.


%%================================
%%  ObjectDigestInfo
%%================================
enc_ObjectDigestInfo(Val) ->
    enc_ObjectDigestInfo(Val, [<<48>>]).

enc_ObjectDigestInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute digestedObjectType(1) with type ENUMERATED
%%-------------------------------------------------
   {EncBytes1,EncLen1} = case Cindex1 of
publicKey -> encode_tags([<<10>>], [0], 1);
publicKeyCert -> encode_tags([<<10>>], [1], 1);
otherObjectTypes -> encode_tags([<<10>>], [2], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end,

%%-------------------------------------------------
%% attribute otherObjectTypeID(2) with type OBJECT IDENTIFIER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_object_identifier(Cindex2, [<<6>>])
       end,

%%-------------------------------------------------
%% attribute digestAlgorithm(3) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_ObjectDigestInfo_digestAlgorithm'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute objectDigest(4) with type BIT STRING
%%-------------------------------------------------
   {EncBytes4,EncLen4} = encode_unnamed_bit_string(Cindex4, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  ObjectDigestInfo_digestAlgorithm
%%================================
enc_ObjectDigestInfo_digestAlgorithm(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXAttributeCertificate-2009':'getenc_internal_object_set_argument_3'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ObjectDigestInfo(Tlv) ->
   dec_ObjectDigestInfo(Tlv, [16]).

dec_ObjectDigestInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute digestedObjectType(1) with type ENUMERATED
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = case decode_integer(V1, [10]) of
0 -> publicKey;
1 -> publicKeyCert;
2 -> otherObjectTypes;
Default1 -> exit({error,{asn1,{illegal_enumerated,Default1}}})
end,

%%-------------------------------------------------
%% attribute otherObjectTypeID(2) with type OBJECT IDENTIFIER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{6,V2}|TempTlv3] ->
    {decode_object_identifier(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute digestAlgorithm(3) with type SEQUENCE
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_ObjectDigestInfo_digestAlgorithm'(V3, [16]),

%%-------------------------------------------------
%% attribute objectDigest(4) with type BIT STRING
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = decode_native_bit_string(V4, [3]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'ObjectDigestInfo',Term1,Term2,Term3,Term4},
Res1.
'dec_ObjectDigestInfo_digestAlgorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXAttributeCertificate-2009':'getdec_internal_object_set_argument_3'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'ObjectDigestInfo_digestAlgorithm',Term1,Term2},
Res1.


%%================================
%%  AttCertIssuer
%%================================
enc_AttCertIssuer(Val) ->
    enc_AttCertIssuer(Val, []).

enc_AttCertIssuer(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      v1Form ->
         'PKIX1Implicit-2009':'enc_GeneralNames'(element(2,Val), [<<48>>]);
      v2Form ->
         'enc_V2Form'(element(2,Val), [<<160>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_AttCertIssuer(Tlv) ->
   dec_AttCertIssuer(Tlv, []).

dec_AttCertIssuer(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'v1Form'
    {16, V1} -> 
        {v1Form, 'PKIX1Implicit-2009':'dec_GeneralNames'(V1, [])};


%% 'v2Form'
    {131072, V1} -> 
        {v2Form, 'dec_V2Form'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  V2Form
%%================================
enc_V2Form(Val) ->
    enc_V2Form(Val, [<<48>>]).

enc_V2Form(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute issuerName(1)   External PKIX1Implicit-2009:GeneralNames OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Implicit-2009':'enc_GeneralNames'(Cindex1, [<<48>>])
       end,

%%-------------------------------------------------
%% attribute baseCertificateID(2)   External PKIXAttributeCertificate-2009:IssuerSerial OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_IssuerSerial'(Cindex2, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute objectDigestInfo(3)   External PKIXAttributeCertificate-2009:ObjectDigestInfo OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ObjectDigestInfo'(Cindex3, [<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_V2Form(Tlv) ->
   dec_V2Form(Tlv, [16]).

dec_V2Form(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute issuerName(1)   External PKIX1Implicit-2009:GeneralNames OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{16,V1}|TempTlv2] ->
    {'PKIX1Implicit-2009':'dec_GeneralNames'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute baseCertificateID(2)   External PKIXAttributeCertificate-2009:IssuerSerial OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {'dec_IssuerSerial'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute objectDigestInfo(3)   External PKIXAttributeCertificate-2009:ObjectDigestInfo OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131073,V3}|TempTlv4] ->
    {'dec_ObjectDigestInfo'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'V2Form',Term1,Term2,Term3},
Res1.


%%================================
%%  IssuerSerial
%%================================
enc_IssuerSerial(Val) ->
    enc_IssuerSerial(Val, [<<48>>]).

enc_IssuerSerial(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute issuer(1)   External PKIX1Implicit-2009:GeneralNames
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'PKIX1Implicit-2009':'enc_GeneralNames'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute serial(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute issuerUID(3) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_unnamed_bit_string(Cindex3, [<<3>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_IssuerSerial(Tlv) ->
   dec_IssuerSerial(Tlv, [16]).

dec_IssuerSerial(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute issuer(1)   External PKIX1Implicit-2009:GeneralNames
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'PKIX1Implicit-2009':'dec_GeneralNames'(V1, [16]),

%%-------------------------------------------------
%% attribute serial(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute issuerUID(3) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{3,V3}|TempTlv4] ->
    {decode_native_bit_string(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'IssuerSerial',Term1,Term2,Term3},
Res1.


%%================================
%%  AttCertValidityPeriod
%%================================
enc_AttCertValidityPeriod(Val) ->
    enc_AttCertValidityPeriod(Val, [<<48>>]).

enc_AttCertValidityPeriod(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute notBeforeTime(1) with type GeneralizedTime
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<24>>]),

%%-------------------------------------------------
%% attribute notAfterTime(2) with type GeneralizedTime
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<24>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AttCertValidityPeriod(Tlv) ->
   dec_AttCertValidityPeriod(Tlv, [16]).

dec_AttCertValidityPeriod(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute notBeforeTime(1) with type GeneralizedTime
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
binary_to_list(decode_restricted_string(V1, [24]))
end
,

%%-------------------------------------------------
%% attribute notAfterTime(2) with type GeneralizedTime
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
binary_to_list(decode_restricted_string(V2, [24]))
end
,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AttCertValidityPeriod',Term1,Term2},
Res1.


%%================================
%%  Targets
%%================================
enc_Targets(Val) ->
    enc_Targets(Val, [<<48>>]).

enc_Targets(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_Targets_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Targets_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Targets_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Target'(H, []),
   'enc_Targets_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_Targets(Tlv) ->
   dec_Targets(Tlv, [16]).

dec_Targets(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Target'(V1, []) || V1 <- Tlv1].




%%================================
%%  Target
%%================================
enc_Target(Val) ->
    enc_Target(Val, []).

enc_Target(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      targetName ->
         'PKIX1Implicit-2009':'enc_GeneralName'(element(2,Val), [<<160>>]);
      targetGroup ->
         'PKIX1Implicit-2009':'enc_GeneralName'(element(2,Val), [<<161>>]);
      targetCert ->
         'enc_TargetCert'(element(2,Val), [<<162>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_Target(Tlv) ->
   dec_Target(Tlv, []).

dec_Target(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'targetName'
    {131072, V1} -> 
        {targetName, 'PKIX1Implicit-2009':'dec_GeneralName'(V1, [])};


%% 'targetGroup'
    {131073, V1} -> 
        {targetGroup, 'PKIX1Implicit-2009':'dec_GeneralName'(V1, [])};


%% 'targetCert'
    {131074, V1} -> 
        {targetCert, 'dec_TargetCert'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  TargetCert
%%================================
enc_TargetCert(Val) ->
    enc_TargetCert(Val, [<<48>>]).

enc_TargetCert(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute targetCertificate(1)   External PKIXAttributeCertificate-2009:IssuerSerial
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_IssuerSerial'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute targetName(2)   External PKIX1Implicit-2009:GeneralName OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Implicit-2009':'enc_GeneralName'(Cindex2, [])
       end,

%%-------------------------------------------------
%% attribute certDigestInfo(3)   External PKIXAttributeCertificate-2009:ObjectDigestInfo OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ObjectDigestInfo'(Cindex3, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_TargetCert(Tlv) ->
   dec_TargetCert(Tlv, [16]).

dec_TargetCert(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute targetCertificate(1)   External PKIXAttributeCertificate-2009:IssuerSerial
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_IssuerSerial'(V1, [16]),

%%-------------------------------------------------
%% attribute targetName(2)   External PKIX1Implicit-2009:GeneralName OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[V2 = {131072,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131073,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131074,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131075,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131076,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131077,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131078,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131079,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131080,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute certDigestInfo(3)   External PKIXAttributeCertificate-2009:ObjectDigestInfo OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{16,V3}|TempTlv4] ->
    {'dec_ObjectDigestInfo'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'TargetCert',Term1,Term2,Term3},
Res1.


%%================================
%%  AAControls
%%================================
enc_AAControls(Val) ->
    enc_AAControls(Val, [<<48>>]).

enc_AAControls(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute pathLenConstraint(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex1, [<<2>>])
       end,

%%-------------------------------------------------
%% attribute permittedAttrs(2)   External PKIXAttributeCertificate-2009:AttrSpec OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_AttrSpec'(Cindex2, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute excludedAttrs(3)   External PKIXAttributeCertificate-2009:AttrSpec OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_AttrSpec'(Cindex3, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute permitUnSpecified(4) with type BOOLEAN DEFAULT = true
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case is_default_2(Cindex4) of
true -> {[],0};
false ->
encode_boolean(Cindex4, [<<1>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AAControls(Tlv) ->
   dec_AAControls(Tlv, [16]).

dec_AAControls(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute pathLenConstraint(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{2,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, []),
if 0 =< Val1, Val1 =< 'MAX' ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute permittedAttrs(2)   External PKIXAttributeCertificate-2009:AttrSpec OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {'dec_AttrSpec'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute excludedAttrs(3)   External PKIXAttributeCertificate-2009:AttrSpec OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131073,V3}|TempTlv4] ->
    {'dec_AttrSpec'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute permitUnSpecified(4) with type BOOLEAN DEFAULT = true
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{1,V4}|TempTlv5] ->
    {decode_boolean(V4, []), TempTlv5};
    _ ->
        {true,Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'AAControls',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  AttrSpec
%%================================
enc_AttrSpec(Val) ->
    enc_AttrSpec(Val, [<<48>>]).

enc_AttrSpec(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_AttrSpec_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_AttrSpec_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AttrSpec_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_object_identifier(H, [<<6>>]),
   'enc_AttrSpec_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_AttrSpec(Tlv) ->
   dec_AttrSpec(Tlv, [16]).

dec_AttrSpec(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[decode_object_identifier(V1, [6]) || V1 <- Tlv1].




%%================================
%%  ProxyInfo
%%================================
enc_ProxyInfo(Val) ->
    enc_ProxyInfo(Val, [<<48>>]).

enc_ProxyInfo(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_ProxyInfo_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ProxyInfo_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ProxyInfo_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Targets'(H, [<<48>>]),
   'enc_ProxyInfo_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_ProxyInfo(Tlv) ->
   dec_ProxyInfo(Tlv, [16]).

dec_ProxyInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Targets'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  IetfAttrSyntax
%%================================
enc_IetfAttrSyntax(Val) ->
    enc_IetfAttrSyntax(Val, [<<48>>]).

enc_IetfAttrSyntax(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute policyAuthority(1)   External PKIX1Implicit-2009:GeneralNames OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Implicit-2009':'enc_GeneralNames'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute values(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_IetfAttrSyntax_values'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  IetfAttrSyntax_values
%%================================
enc_IetfAttrSyntax_values(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_IetfAttrSyntax_values_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_IetfAttrSyntax_values_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_IetfAttrSyntax_values_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_IetfAttrSyntax_values_SEQOF'(H, []),
   'enc_IetfAttrSyntax_values_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  IetfAttrSyntax_values_SEQOF
%%================================
enc_IetfAttrSyntax_values_SEQOF(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      octets ->
         encode_restricted_string(element(2,Val), [<<4>>]);
      oid ->
         encode_object_identifier(element(2,Val), [<<6>>]);
      string ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_IetfAttrSyntax(Tlv) ->
   dec_IetfAttrSyntax(Tlv, [16]).

dec_IetfAttrSyntax(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute policyAuthority(1)   External PKIX1Implicit-2009:GeneralNames OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'PKIX1Implicit-2009':'dec_GeneralNames'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute values(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_IetfAttrSyntax_values'(V2, [16]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'IetfAttrSyntax',Term1,Term2},
Res1.
'dec_IetfAttrSyntax_values'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_IetfAttrSyntax_values_SEQOF'(V1, []) || V1 <- Tlv1].


'dec_IetfAttrSyntax_values_SEQOF'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'octets'
    {4, V1} -> 
        {octets, decode_octet_string(V1, [])};


%% 'oid'
    {6, V1} -> 
        {oid, decode_object_identifier(V1, [])};


%% 'string'
    {12, V1} -> 
        {string, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  SvceAuthInfo
%%================================
enc_SvceAuthInfo(Val) ->
    enc_SvceAuthInfo(Val, [<<48>>]).

enc_SvceAuthInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute service(1)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'PKIX1Implicit-2009':'enc_GeneralName'(Cindex1, []),

%%-------------------------------------------------
%% attribute ident(2)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'PKIX1Implicit-2009':'enc_GeneralName'(Cindex2, []),

%%-------------------------------------------------
%% attribute authInfo(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex3, [<<4>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_SvceAuthInfo(Tlv) ->
   dec_SvceAuthInfo(Tlv, [16]).

dec_SvceAuthInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute service(1)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'PKIX1Implicit-2009':'dec_GeneralName'(V1, []),

%%-------------------------------------------------
%% attribute ident(2)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'PKIX1Implicit-2009':'dec_GeneralName'(V2, []),

%%-------------------------------------------------
%% attribute authInfo(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{4,V3}|TempTlv4] ->
    {decode_octet_string(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'SvceAuthInfo',Term1,Term2,Term3},
Res1.


%%================================
%%  RoleSyntax
%%================================
enc_RoleSyntax(Val) ->
    enc_RoleSyntax(Val, [<<48>>]).

enc_RoleSyntax(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute roleAuthority(1)   External PKIX1Implicit-2009:GeneralNames OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Implicit-2009':'enc_GeneralNames'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute roleName(2)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'PKIX1Implicit-2009':'enc_GeneralName'(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_RoleSyntax(Tlv) ->
   dec_RoleSyntax(Tlv, [16]).

dec_RoleSyntax(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute roleAuthority(1)   External PKIX1Implicit-2009:GeneralNames OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'PKIX1Implicit-2009':'dec_GeneralNames'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute roleName(2)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'PKIX1Implicit-2009':'dec_GeneralName'(V2, [131073]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'RoleSyntax',Term1,Term2},
Res1.


%%================================
%%  Clearance
%%================================
enc_Clearance(Val) ->
    enc_Clearance(Val, [<<48>>]).

enc_Clearance(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute policyId(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute classList(2) with type BIT STRING DEFAULT = [unclassified]
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_3(Cindex2) of
true -> {[],0};
false ->
encode_named_bit_string(Cindex2, [{unmarked,0},{unclassified,1},{restricted,2},{confidential,3},{secret,4},{topSecret,5}], [<<3>>])
       end,

%%-------------------------------------------------
%% attribute securityCategories(3) with type SET OF OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Clearance_securityCategories'(Cindex3, [<<49>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  Clearance_securityCategories
%%================================
enc_Clearance_securityCategories(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_Clearance_securityCategories_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Clearance_securityCategories_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_Clearance_securityCategories_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Clearance_securityCategories_SecurityCategory'(H, [<<48>>]),
   'enc_Clearance_securityCategories_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  Clearance_securityCategories_SecurityCategory
%%================================
enc_Clearance_securityCategories_SecurityCategory(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objtype = 
   'PKIXAttributeCertificate-2009':'getenc_internal_object_set_argument_9'(                                   Cindex1),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute value(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes2,_} = Objtype('Type', Cindex2, []),
   {EncBytes2,EncLen2} = encode_open_type(TmpBytes2, [<<161>>])
,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_Clearance(Tlv) ->
   dec_Clearance(Tlv, [16]).

dec_Clearance(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute policyId(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute classList(2) with type BIT STRING DEFAULT = [unclassified]
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{3,V2}|TempTlv3] ->
    {decode_named_bit_string(V2, [{unmarked,0},{unclassified,1},{restricted,2},{confidential,3},{secret,4},{topSecret,5}], []), TempTlv3};
    _ ->
        {[unclassified],Tlv2}
end,

%%-------------------------------------------------
%% attribute securityCategories(3) with type SET OF OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{17,V3}|TempTlv4] ->
    {'dec_Clearance_securityCategories'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Clearance',Term1,Term2,Term3},
Res1.
'dec_Clearance_securityCategories'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Clearance_securityCategories_SecurityCategory'(V1, [16]) || V1 <- Tlv1].


'dec_Clearance_securityCategories_SecurityCategory'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [131072]),

%%-------------------------------------------------
%% attribute value(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = decode_open_type(V2, [131073]),

DecObjtypeTerm1 =
   'PKIXAttributeCertificate-2009':'getdec_internal_object_set_argument_9'(Term1),
Term2 = 
   case (catch DecObjtypeTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'SecurityCategory',Term1,Term2},
Res1.


%%================================
%%  Clearance-rfc3281
%%================================
'enc_Clearance-rfc3281'(Val) ->
    'enc_Clearance-rfc3281'(Val, [<<48>>]).

'enc_Clearance-rfc3281'(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute policyId(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute classList(2) with type BIT STRING DEFAULT = [unclassified]
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_4(Cindex2) of
true -> {[],0};
false ->
encode_named_bit_string(Cindex2, [{unmarked,0},{unclassified,1},{restricted,2},{confidential,3},{secret,4},{topSecret,5}], [<<129>>])
       end,

%%-------------------------------------------------
%% attribute securityCategories(3) with type SET OF OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Clearance-rfc3281_securityCategories'(Cindex3, [<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  Clearance-rfc3281_securityCategories
%%================================
'enc_Clearance-rfc3281_securityCategories'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_Clearance-rfc3281_securityCategories_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Clearance-rfc3281_securityCategories_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_Clearance-rfc3281_securityCategories_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Clearance-rfc3281_securityCategories_SecurityCategory-rfc3281'(H, [<<48>>]),
   'enc_Clearance-rfc3281_securityCategories_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  Clearance-rfc3281_securityCategories_SecurityCategory-rfc3281
%%================================
'enc_Clearance-rfc3281_securityCategories_SecurityCategory-rfc3281'(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objtype = 
   'PKIXAttributeCertificate-2009':'getenc_internal_object_set_argument_10'(                                   Cindex1),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute value(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes2,_} = Objtype('Type', Cindex2, []),
   {EncBytes2,EncLen2} = encode_open_type(TmpBytes2, [<<161>>])
,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_Clearance-rfc3281'(Tlv) ->
   'dec_Clearance-rfc3281'(Tlv, [16]).

'dec_Clearance-rfc3281'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute policyId(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [131072]),

%%-------------------------------------------------
%% attribute classList(2) with type BIT STRING DEFAULT = [unclassified]
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {decode_named_bit_string(V2, [{unmarked,0},{unclassified,1},{restricted,2},{confidential,3},{secret,4},{topSecret,5}], []), TempTlv3};
    _ ->
        {[unclassified],Tlv2}
end,

%%-------------------------------------------------
%% attribute securityCategories(3) with type SET OF OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_Clearance-rfc3281_securityCategories'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Clearance-rfc3281',Term1,Term2,Term3},
Res1.
'dec_Clearance-rfc3281_securityCategories'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Clearance-rfc3281_securityCategories_SecurityCategory-rfc3281'(V1, [16]) || V1 <- Tlv1].


'dec_Clearance-rfc3281_securityCategories_SecurityCategory-rfc3281'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [131072]),

%%-------------------------------------------------
%% attribute value(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = decode_open_type(V2, [131073]),

DecObjtypeTerm1 =
   'PKIXAttributeCertificate-2009':'getdec_internal_object_set_argument_10'(Term1),
Term2 = 
   case (catch DecObjtypeTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'SecurityCategory-rfc3281',Term1,Term2},
Res1.


%%================================
%%  ClassList
%%================================
enc_ClassList(Val) ->
    enc_ClassList(Val, [<<3>>]).

enc_ClassList(Val, TagIn) ->
encode_named_bit_string(Val, [{unmarked,0},{unclassified,1},{restricted,2},{confidential,3},{secret,4},{topSecret,5}], TagIn).


dec_ClassList(Tlv) ->
   dec_ClassList(Tlv, [3]).

dec_ClassList(Tlv, TagIn) ->
decode_named_bit_string(Tlv, [{unmarked,0},{unclassified,1},{restricted,2},{confidential,3},{secret,4},{topSecret,5}], TagIn).



%%================================
%%  ACClearAttrs
%%================================
enc_ACClearAttrs(Val) ->
    enc_ACClearAttrs(Val, [<<48>>]).

enc_ACClearAttrs(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute acIssuer(1)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'PKIX1Implicit-2009':'enc_GeneralName'(Cindex1, []),

%%-------------------------------------------------
%% attribute acSerial(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute attrs(3) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_ACClearAttrs_attrs'(Cindex3, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  ACClearAttrs_attrs
%%================================
enc_ACClearAttrs_attrs(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_ACClearAttrs_attrs_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ACClearAttrs_attrs_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ACClearAttrs_attrs_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_ACClearAttrs_attrs_AttributeSet'(H, [<<48>>]),
   'enc_ACClearAttrs_attrs_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  ACClearAttrs_attrs_AttributeSet
%%================================
enc_ACClearAttrs_attrs_AttributeSet(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objtype = 
   'PKIXAttributeCertificate-2009':'getenc_internal_object_set_argument_11'(                                   Cindex1),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_ACClearAttrs_attrs_AttributeSet_values'(Cindex2, [<<49>>], Objtype),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  ACClearAttrs_attrs_AttributeSet_values
%%================================
enc_ACClearAttrs_attrs_AttributeSet_values(Val, TagIn, ObjFun) ->
      {EncBytes,EncLen} = 'enc_ACClearAttrs_attrs_AttributeSet_values_components'(Val, ObjFun,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ACClearAttrs_attrs_AttributeSet_values_components'([], _, AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_ACClearAttrs_attrs_AttributeSet_values_components'([H|T], ObjFun,AccBytes, AccLen) ->
   {TmpBytes,_} = ObjFun('Type', H, []),
   {EncBytes,EncLen} = encode_open_type(TmpBytes, [])
,
   'enc_ACClearAttrs_attrs_AttributeSet_values_components'(T, ObjFun,[EncBytes|AccBytes], AccLen + EncLen).



dec_ACClearAttrs(Tlv) ->
   dec_ACClearAttrs(Tlv, [16]).

dec_ACClearAttrs(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute acIssuer(1)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'PKIX1Implicit-2009':'dec_GeneralName'(V1, []),

%%-------------------------------------------------
%% attribute acSerial(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute attrs(3) with type SEQUENCE OF
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_ACClearAttrs_attrs'(V3, [16]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'ACClearAttrs',Term1,Term2,Term3},
Res1.
'dec_ACClearAttrs_attrs'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_ACClearAttrs_attrs_AttributeSet'(V1, [16]) || V1 <- Tlv1].


'dec_ACClearAttrs_attrs_AttributeSet'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),
ObjFun = 'PKIXAttributeCertificate-2009':'getdec_internal_object_set_argument_11'(Term1),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_ACClearAttrs_attrs_AttributeSet_values'(V2, [17], ObjFun),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AttributeSet',Term1,Term2},
Res1.
'dec_ACClearAttrs_attrs_AttributeSet_values'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[
      begin
         Tmptlv1 = decode_open_type(V1, []),
         case (catch ObjFun('Type', Tmptlv1, [])) of
            {'EXIT',Reason1} ->
               exit({'Type not compatible with table constraint', Reason1});
            Tmpterm1 ->
               Tmpterm1
         end
      end
 || V1 <- Tlv1].


'id-pe-ac-auditIdentity'() ->
{1,3,6,1,5,5,7,1,4}.

'id-pe-aaControls'() ->
{1,3,6,1,5,5,7,1,6}.

'id-pe-ac-proxying'() ->
{1,3,6,1,5,5,7,1,10}.

'id-ce-targetInformation'() ->
{2,5,29,55}.

'id-ce-noRevAvail'() ->
{2,5,29,56}.

'id-aca'() ->
{1,3,6,1,5,5,7,10}.

'id-aca-authenticationInfo'() ->
{1,3,6,1,5,5,7,10,1}.

'id-aca-accessIdentity'() ->
{1,3,6,1,5,5,7,10,2}.

'id-aca-chargingIdentity'() ->
{1,3,6,1,5,5,7,10,3}.

'id-aca-group'() ->
{1,3,6,1,5,5,7,10,4}.

'id-aca-encAttrs'() ->
{1,3,6,1,5,5,7,10,6}.

'id-at-role'() ->
{2,5,4,72}.

'id-at-clearance'() ->
{2,5,4,55}.

'id-at-clearance-rfc3281'() ->
{2,5,1,5,55}.




%%================================
%%  ext-auditIdentity
%%================================
'enc_ext-auditIdentity'('ExtnType', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<4>>]).


'dec_ext-auditIdentity'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_octet_string(Tlv, [4]).

tlv_format(Bytes) when is_binary(Bytes) ->
  {Tlv,_} = ber_decode_nif(Bytes),
  Tlv;
tlv_format(Bytes) ->
  Bytes.



%%================================
%%  ext-targetInformation
%%================================
'enc_ext-targetInformation'('ExtnType', Val, _RestPrimFieldName) ->
   enc_Targets(Val, [<<48>>]).


'dec_ext-targetInformation'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_Targets(Tlv, [16]).




%%================================
%%  ext-noRevAvail
%%================================
'enc_ext-noRevAvail'('ExtnType', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]).


'dec_ext-noRevAvail'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]).




%%================================
%%  ext-ac-proxying
%%================================
'enc_ext-ac-proxying'('ExtnType', Val, _RestPrimFieldName) ->
   enc_ProxyInfo(Val, [<<48>>]).


'dec_ext-ac-proxying'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ProxyInfo(Tlv, [16]).




%%================================
%%  ext-aaControls
%%================================
'enc_ext-aaControls'('ExtnType', Val, _RestPrimFieldName) ->
   enc_AAControls(Val, [<<48>>]).


'dec_ext-aaControls'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_AAControls(Tlv, [16]).




%%================================
%%  at-authenticationInfo
%%================================
'enc_at-authenticationInfo'('Type', Val, _RestPrimFieldName) ->
   enc_SvceAuthInfo(Val, [<<48>>]);
'enc_at-authenticationInfo'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-authenticationInfo'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_SvceAuthInfo(Tlv, [16]);
'dec_at-authenticationInfo'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-accesIdentity
%%================================
'enc_at-accesIdentity'('Type', Val, _RestPrimFieldName) ->
   enc_SvceAuthInfo(Val, [<<48>>]);
'enc_at-accesIdentity'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-accesIdentity'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_SvceAuthInfo(Tlv, [16]);
'dec_at-accesIdentity'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-chargingIdentity
%%================================
'enc_at-chargingIdentity'('Type', Val, _RestPrimFieldName) ->
   enc_IetfAttrSyntax(Val, [<<48>>]);
'enc_at-chargingIdentity'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-chargingIdentity'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_IetfAttrSyntax(Tlv, [16]);
'dec_at-chargingIdentity'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-group
%%================================
'enc_at-group'('Type', Val, _RestPrimFieldName) ->
   enc_IetfAttrSyntax(Val, [<<48>>]);
'enc_at-group'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-group'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_IetfAttrSyntax(Tlv, [16]);
'dec_at-group'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-role
%%================================
'enc_at-role'('Type', Val, _RestPrimFieldName) ->
   enc_RoleSyntax(Val, [<<48>>]);
'enc_at-role'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-role'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_RoleSyntax(Tlv, [16]);
'dec_at-role'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-clearance
%%================================
'enc_at-clearance'('Type', Val, _RestPrimFieldName) ->
   enc_Clearance(Val, [<<48>>]);
'enc_at-clearance'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-clearance'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_Clearance(Tlv, [16]);
'dec_at-clearance'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-clearance-RFC3281
%%================================
'enc_at-clearance-RFC3281'('Type', Val, _RestPrimFieldName) ->
   'enc_Clearance-rfc3281'(Val, [<<48>>]);
'enc_at-clearance-RFC3281'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-clearance-RFC3281'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_Clearance-rfc3281'(Tlv, [16]);
'dec_at-clearance-RFC3281'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-encAttrs
%%================================
'enc_at-encAttrs'('Type', Val, _RestPrimFieldName) ->
   'CryptographicMessageSyntax-2009':enc_ContentInfo(Val, [<<48>>]);
'enc_at-encAttrs'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-encAttrs'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'CryptographicMessageSyntax-2009':dec_ContentInfo(Tlv, [16]);
'dec_at-encAttrs'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  AttributeCertExtensions
%%================================
getenc_AttributeCertExtensions(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CRLDistributionPoints'(T,V,O) end;
getenc_AttributeCertExtensions(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityKeyIdentifier'(T,V,O) end;
getenc_AttributeCertExtensions(Id) when Id =:= {2,5,29,55} ->
    fun 'enc_ext-targetInformation'/3;
getenc_AttributeCertExtensions(Id) when Id =:= {2,5,29,56} ->
    fun 'enc_ext-noRevAvail'/3;
getenc_AttributeCertExtensions(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityInfoAccess'(T,V,O) end;
getenc_AttributeCertExtensions(Id) when Id =:= {1,3,6,1,5,5,7,1,4} ->
    fun 'enc_ext-auditIdentity'/3;
getenc_AttributeCertExtensions(Id) when Id =:= {1,3,6,1,5,5,7,1,6} ->
    fun 'enc_ext-aaControls'/3;
getenc_AttributeCertExtensions(Id) when Id =:= {1,3,6,1,5,5,7,1,10} ->
    fun 'enc_ext-ac-proxying'/3;
getenc_AttributeCertExtensions(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_AttributeCertExtensions(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CRLDistributionPoints'(T,V,O) end;
getdec_AttributeCertExtensions(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityKeyIdentifier'(T,V,O) end;
getdec_AttributeCertExtensions(Id) when Id =:= {2,5,29,55} ->
    fun 'dec_ext-targetInformation'/3;
getdec_AttributeCertExtensions(Id) when Id =:= {2,5,29,56} ->
    fun 'dec_ext-noRevAvail'/3;
getdec_AttributeCertExtensions(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityInfoAccess'(T,V,O) end;
getdec_AttributeCertExtensions(Id) when Id =:= {1,3,6,1,5,5,7,1,4} ->
    fun 'dec_ext-auditIdentity'/3;
getdec_AttributeCertExtensions(Id) when Id =:= {1,3,6,1,5,5,7,1,6} ->
    fun 'dec_ext-aaControls'/3;
getdec_AttributeCertExtensions(Id) when Id =:= {1,3,6,1,5,5,7,1,10} ->
    fun 'dec_ext-ac-proxying'/3;
getdec_AttributeCertExtensions(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  AttributesDefined
%%================================
getenc_AttributesDefined(Id) when Id =:= {2,5,4,55} ->
    fun 'enc_at-clearance'/3;
getenc_AttributesDefined(Id) when Id =:= {2,5,4,72} ->
    fun 'enc_at-role'/3;
getenc_AttributesDefined(Id) when Id =:= {1,3,6,1,5,5,7,10,1} ->
    fun 'enc_at-authenticationInfo'/3;
getenc_AttributesDefined(Id) when Id =:= {1,3,6,1,5,5,7,10,2} ->
    fun 'enc_at-accesIdentity'/3;
getenc_AttributesDefined(Id) when Id =:= {1,3,6,1,5,5,7,10,3} ->
    fun 'enc_at-chargingIdentity'/3;
getenc_AttributesDefined(Id) when Id =:= {1,3,6,1,5,5,7,10,4} ->
    fun 'enc_at-group'/3;
getenc_AttributesDefined(Id) when Id =:= {1,3,6,1,5,5,7,10,6} ->
    fun 'enc_at-encAttrs'/3;
getenc_AttributesDefined(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_AttributesDefined(Id) when Id =:= {2,5,4,55} ->
    fun 'dec_at-clearance'/3;
getdec_AttributesDefined(Id) when Id =:= {2,5,4,72} ->
    fun 'dec_at-role'/3;
getdec_AttributesDefined(Id) when Id =:= {1,3,6,1,5,5,7,10,1} ->
    fun 'dec_at-authenticationInfo'/3;
getdec_AttributesDefined(Id) when Id =:= {1,3,6,1,5,5,7,10,2} ->
    fun 'dec_at-accesIdentity'/3;
getdec_AttributesDefined(Id) when Id =:= {1,3,6,1,5,5,7,10,3} ->
    fun 'dec_at-chargingIdentity'/3;
getdec_AttributesDefined(Id) when Id =:= {1,3,6,1,5,5,7,10,4} ->
    fun 'dec_at-group'/3;
getdec_AttributesDefined(Id) when Id =:= {1,3,6,1,5,5,7,10,6} ->
    fun 'dec_at-encAttrs'/3;
getdec_AttributesDefined(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SupportedSecurityCategories
%%================================
getenc_SupportedSecurityCategories(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_SupportedSecurityCategories(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_9
%%================================
getenc_internal_object_set_argument_9(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_9(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_8
%%================================
getenc_internal_object_set_argument_8(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CRLDistributionPoints'(T,V,O) end;
getenc_internal_object_set_argument_8(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityKeyIdentifier'(T,V,O) end;
getenc_internal_object_set_argument_8(Id) when Id =:= {2,5,29,55} ->
    fun 'enc_ext-targetInformation'/3;
getenc_internal_object_set_argument_8(Id) when Id =:= {2,5,29,56} ->
    fun 'enc_ext-noRevAvail'/3;
getenc_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityInfoAccess'(T,V,O) end;
getenc_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,1,4} ->
    fun 'enc_ext-auditIdentity'/3;
getenc_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,1,6} ->
    fun 'enc_ext-aaControls'/3;
getenc_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,1,10} ->
    fun 'enc_ext-ac-proxying'/3;
getenc_internal_object_set_argument_8(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_8(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CRLDistributionPoints'(T,V,O) end;
getdec_internal_object_set_argument_8(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityKeyIdentifier'(T,V,O) end;
getdec_internal_object_set_argument_8(Id) when Id =:= {2,5,29,55} ->
    fun 'dec_ext-targetInformation'/3;
getdec_internal_object_set_argument_8(Id) when Id =:= {2,5,29,56} ->
    fun 'dec_ext-noRevAvail'/3;
getdec_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityInfoAccess'(T,V,O) end;
getdec_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,1,4} ->
    fun 'dec_ext-auditIdentity'/3;
getdec_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,1,6} ->
    fun 'dec_ext-aaControls'/3;
getdec_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,1,10} ->
    fun 'dec_ext-ac-proxying'/3;
getdec_internal_object_set_argument_8(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_7
%%================================
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CRLDistributionPoints'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityKeyIdentifier'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,55} ->
    fun 'enc_ext-targetInformation'/3;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,56} ->
    fun 'enc_ext-noRevAvail'/3;
getenc_internal_object_set_argument_7(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityInfoAccess'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {1,3,6,1,5,5,7,1,4} ->
    fun 'enc_ext-auditIdentity'/3;
getenc_internal_object_set_argument_7(Id) when Id =:= {1,3,6,1,5,5,7,1,6} ->
    fun 'enc_ext-aaControls'/3;
getenc_internal_object_set_argument_7(Id) when Id =:= {1,3,6,1,5,5,7,1,10} ->
    fun 'enc_ext-ac-proxying'/3;
getenc_internal_object_set_argument_7(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CRLDistributionPoints'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityKeyIdentifier'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,55} ->
    fun 'dec_ext-targetInformation'/3;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,56} ->
    fun 'dec_ext-noRevAvail'/3;
getdec_internal_object_set_argument_7(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityInfoAccess'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {1,3,6,1,5,5,7,1,4} ->
    fun 'dec_ext-auditIdentity'/3;
getdec_internal_object_set_argument_7(Id) when Id =:= {1,3,6,1,5,5,7,1,6} ->
    fun 'dec_ext-aaControls'/3;
getdec_internal_object_set_argument_7(Id) when Id =:= {1,3,6,1,5,5,7,1,10} ->
    fun 'dec_ext-ac-proxying'/3;
getdec_internal_object_set_argument_7(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_6
%%================================
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,4,55} ->
    fun 'enc_at-clearance'/3;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,4,72} ->
    fun 'enc_at-role'/3;
getenc_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,10,1} ->
    fun 'enc_at-authenticationInfo'/3;
getenc_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,10,2} ->
    fun 'enc_at-accesIdentity'/3;
getenc_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,10,3} ->
    fun 'enc_at-chargingIdentity'/3;
getenc_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,10,4} ->
    fun 'enc_at-group'/3;
getenc_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,10,6} ->
    fun 'enc_at-encAttrs'/3;
getenc_internal_object_set_argument_6(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,4,55} ->
    fun 'dec_at-clearance'/3;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,4,72} ->
    fun 'dec_at-role'/3;
getdec_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,10,1} ->
    fun 'dec_at-authenticationInfo'/3;
getdec_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,10,2} ->
    fun 'dec_at-accesIdentity'/3;
getdec_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,10,3} ->
    fun 'dec_at-chargingIdentity'/3;
getdec_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,10,4} ->
    fun 'dec_at-group'/3;
getdec_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,10,6} ->
    fun 'dec_at-encAttrs'/3;
getdec_internal_object_set_argument_6(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_5
%%================================
getenc_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10040,4,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA224'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA256'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA384'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA512'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD2'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD5'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'enc_sa-rsaSSA-PSS'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA224'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA256'(T,V,O) end;
getenc_internal_object_set_argument_5(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10040,4,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA224'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA256'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA384'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA512'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD2'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD5'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'dec_sa-rsaSSA-PSS'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA224'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA256'(T,V,O) end;
getdec_internal_object_set_argument_5(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_3
%%================================
getenc_internal_object_set_argument_3(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_3(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_11
%%================================
getenc_internal_object_set_argument_11(Id) when Id =:= {2,5,4,55} ->
    fun 'enc_at-clearance'/3;
getenc_internal_object_set_argument_11(Id) when Id =:= {2,5,4,72} ->
    fun 'enc_at-role'/3;
getenc_internal_object_set_argument_11(Id) when Id =:= {1,3,6,1,5,5,7,10,1} ->
    fun 'enc_at-authenticationInfo'/3;
getenc_internal_object_set_argument_11(Id) when Id =:= {1,3,6,1,5,5,7,10,2} ->
    fun 'enc_at-accesIdentity'/3;
getenc_internal_object_set_argument_11(Id) when Id =:= {1,3,6,1,5,5,7,10,3} ->
    fun 'enc_at-chargingIdentity'/3;
getenc_internal_object_set_argument_11(Id) when Id =:= {1,3,6,1,5,5,7,10,4} ->
    fun 'enc_at-group'/3;
getenc_internal_object_set_argument_11(Id) when Id =:= {1,3,6,1,5,5,7,10,6} ->
    fun 'enc_at-encAttrs'/3;
getenc_internal_object_set_argument_11(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_11(Id) when Id =:= {2,5,4,55} ->
    fun 'dec_at-clearance'/3;
getdec_internal_object_set_argument_11(Id) when Id =:= {2,5,4,72} ->
    fun 'dec_at-role'/3;
getdec_internal_object_set_argument_11(Id) when Id =:= {1,3,6,1,5,5,7,10,1} ->
    fun 'dec_at-authenticationInfo'/3;
getdec_internal_object_set_argument_11(Id) when Id =:= {1,3,6,1,5,5,7,10,2} ->
    fun 'dec_at-accesIdentity'/3;
getdec_internal_object_set_argument_11(Id) when Id =:= {1,3,6,1,5,5,7,10,3} ->
    fun 'dec_at-chargingIdentity'/3;
getdec_internal_object_set_argument_11(Id) when Id =:= {1,3,6,1,5,5,7,10,4} ->
    fun 'dec_at-group'/3;
getdec_internal_object_set_argument_11(Id) when Id =:= {1,3,6,1,5,5,7,10,6} ->
    fun 'dec_at-encAttrs'/3;
getdec_internal_object_set_argument_11(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_10
%%================================
getenc_internal_object_set_argument_10(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_10(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.



%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    ok.

is_default_1(asn1_DEFAULT) ->
true;
is_default_1(Def) when Def =:= false ->
true;
is_default_1(_) ->
false.


is_default_2(asn1_DEFAULT) ->
true;
is_default_2(Def) when Def =:= true ->
true;
is_default_2(_) ->
false.


is_default_3(asn1_DEFAULT) ->
true;
is_default_3(Value) ->
try check_named_bitstring(Value, [unclassified], <<1:2>>, 2) of
_ -> true
catch throw:false -> false
end.


is_default_4(asn1_DEFAULT) ->
true;
is_default_4(Value) ->
try check_named_bitstring(Value, [unclassified], <<1:2>>, 2) of
_ -> true
catch throw:false -> false
end.


ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

check_named_bitstring([_ | _] = Val, Names, _, _) ->
    case lists:sort(Val) of
        Names ->
            true;
        _ ->
            throw(false)
    end;
check_named_bitstring(Bs, _, Bs, _) ->
    true;
check_named_bitstring(Val, _, Bs, BsSize) ->
    Rest = bit_size(Val) - BsSize,
    case Val of
        <<Bs:BsSize/bits,0:Rest>> ->
            true;
        _ ->
            throw(false)
    end.

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_, L} | Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L) | Acc]);
collect_parts([{3, <<Unused,Bits/binary>>} | Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T, V} | Rest], Acc) ->
    collect_parts(Rest, [V | Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3, <<Unused,Bits/binary>>} | Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits | Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc | lists:reverse(Acc)]).

dec_subidentifiers(<<>>, _Av, Al) ->
    lists:reverse(Al);
dec_subidentifiers(<<1:1,H:7,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, Av bsl 7 + H, Al);
dec_subidentifiers(<<H,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 + H | Al]).

decode_UTF8_string(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin ->
            Bin
    end.

decode_bitstring2(1, Unused,
                  <<B7:1,B6:1,B5:1,B4:1,B3:1,B2:1,B1:1,B0:1,_/binary>>) ->
    lists:sublist([B7, B6, B5, B4, B3, B2, B1, B0], 8 - Unused);
decode_bitstring2(Len, Unused,
                  <<B7:1,
                    B6:1,
                    B5:1,
                    B4:1,
                    B3:1,
                    B2:1,
                    B1:1,
                    B0:1,
                    Buffer/binary>>) ->
    [B7, B6, B5, B4, B3, B2, B1, B0 |
     decode_bitstring2(Len - 1, Unused, Buffer)].

decode_bitstring_NNL(BitList, NamedNumberList) ->
    decode_bitstring_NNL(BitList, NamedNumberList, 0, []).

decode_bitstring_NNL([], _, _No, Result) ->
    lists:reverse(Result);
decode_bitstring_NNL([B | BitList],
                     [{Name, No} | NamedNumberList],
                     No, Result) ->
    if
        B =:= 0 ->
            decode_bitstring_NNL(BitList, NamedNumberList,
                                 No + 1,
                                 Result);
        true ->
            decode_bitstring_NNL(BitList, NamedNumberList,
                                 No + 1,
                                 [Name | Result])
    end;
decode_bitstring_NNL([1 | BitList], NamedNumberList, No, Result) ->
    decode_bitstring_NNL(BitList, NamedNumberList,
                         No + 1,
                         [{bit, No} | Result]);
decode_bitstring_NNL([0 | BitList], NamedNumberList, No, Result) ->
    decode_bitstring_NNL(BitList, NamedNumberList, No + 1, Result).

decode_boolean(Tlv, TagIn) ->
    Val = match_tags(Tlv, TagIn),
    case Val of
        <<0:8>> ->
            false;
        <<_:8>> ->
            true;
        _ ->
            exit({error, {asn1, {decode_boolean, Val}}})
    end.

decode_integer(Tlv, TagIn) ->
    Bin = match_tags(Tlv, TagIn),
    Len = byte_size(Bin),
    <<Int:Len/signed-unit:8>> = Bin,
    Int.

decode_named_bit_string(Buffer, NamedNumberList, Tags) ->
    case match_and_collect(Buffer, Tags) of
        <<0>> ->
            [];
        <<Unused,Bits/binary>> ->
            BitString = decode_bitstring2(byte_size(Bits), Unused, Bits),
            decode_bitstring_NNL(BitString, NamedNumberList)
    end.

decode_native_bit_string(Buffer, Tags) ->
    case match_and_collect(Buffer, Tags) of
        <<0>> ->
            <<>>;
        <<Unused,Bits/binary>> ->
            Size = bit_size(Bits) - Unused,
            <<Val:Size/bitstring,_:Unused/bitstring>> = Bits,
            Val
    end.

decode_null(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    case Val of
        <<>> ->
            'NULL';
        _ ->
            exit({error, {asn1, {decode_null, Val}}})
    end.

decode_object_identifier(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    [AddedObjVal | ObjVals] = dec_subidentifiers(Val, 0, []),
    {Val1, Val2} =
        if
            AddedObjVal < 40 ->
                {0, AddedObjVal};
            AddedObjVal < 80 ->
                {1, AddedObjVal - 40};
            true ->
                {2, AddedObjVal - 80}
        end,
    list_to_tuple([Val1, Val2 | ObjVals]).

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

decode_open_type(Tlv, TagIn) ->
    case match_tags(Tlv, TagIn) of
        Bin when is_binary(Bin) ->
            {InnerTlv, _} = ber_decode_nif(Bin),
            InnerTlv;
        TlvBytes ->
            TlvBytes
    end.

decode_restricted_string(Tlv, TagsIn) ->
    match_and_collect(Tlv, TagsIn).

do_encode_named_bit_string([FirstVal | RestVal], NamedBitList, TagIn) ->
    ToSetPos = get_all_bitposes([FirstVal | RestVal], NamedBitList, []),
    Size = lists:max(ToSetPos) + 1,
    BitList = make_and_set_list(Size, ToSetPos, 0),
    {Len, Unused, OctetList} = encode_bitstring(BitList),
    encode_tags(TagIn, [Unused | OctetList], Len + 1).

dynamicsort_SETOF(ListOfEncVal) ->
    BinL =
        lists:map(fun(L) when is_list(L) ->
                         list_to_binary(L);
                     (B) ->
                         B
                  end,
                  ListOfEncVal),
    lists:sort(BinL).

e_object_identifier({'OBJECT IDENTIFIER', V}) ->
    e_object_identifier(V);
e_object_identifier(V) when is_tuple(V) ->
    e_object_identifier(tuple_to_list(V));
e_object_identifier([E1, E2 | Tail]) ->
    Head = 40 * E1 + E2,
    {H, Lh} = mk_object_val(Head),
    {R, Lr} = lists:mapfoldl(fun enc_obj_id_tail/2, 0, Tail),
    {[H | R], Lh + Lr}.

enc_obj_id_tail(H, Len) ->
    {B, L} = mk_object_val(H),
    {B, Len + L}.

encode_UTF8_string(UTF8String, TagIn) when is_binary(UTF8String) ->
    encode_tags(TagIn, UTF8String, byte_size(UTF8String));
encode_UTF8_string(UTF8String, TagIn) ->
    encode_tags(TagIn, UTF8String, length(UTF8String)).

encode_bitstring([B8, B7, B6, B5, B4, B3, B2, B1 | Rest]) ->
    Val =
        B8 bsl 7 bor (B7 bsl 6) bor (B6 bsl 5) bor (B5 bsl 4)
        bor
        (B4 bsl 3)
        bor
        (B3 bsl 2)
        bor
        (B2 bsl 1)
        bor
        B1,
    encode_bitstring(Rest, [Val], 1);
encode_bitstring(Val) ->
    {Unused, Octet} = unused_bitlist(Val, 7, 0),
    {1, Unused, [Octet]}.

encode_bitstring([B8, B7, B6, B5, B4, B3, B2, B1 | Rest], Ack, Len) ->
    Val =
        B8 bsl 7 bor (B7 bsl 6) bor (B6 bsl 5) bor (B5 bsl 4)
        bor
        (B4 bsl 3)
        bor
        (B3 bsl 2)
        bor
        (B2 bsl 1)
        bor
        B1,
    encode_bitstring(Rest, [Ack, Val], Len + 1);
encode_bitstring([], Ack, Len) ->
    {Len, 0, Ack};
encode_bitstring(Rest, Ack, Len) ->
    {Unused, Val} = unused_bitlist(Rest, 7, 0),
    {Len + 1, Unused, [Ack, Val]}.

encode_boolean(true, TagIn) ->
    encode_tags(TagIn, [255], 1);
encode_boolean(false, TagIn) ->
    encode_tags(TagIn, [0], 1);
encode_boolean(X, _) ->
    exit({error, {asn1, {encode_boolean, X}}}).

encode_integer(Val) ->
    Bytes =
        if
            Val >= 0 ->
                encode_integer_pos(Val, []);
            true ->
                encode_integer_neg(Val, [])
        end,
    {Bytes, length(Bytes)}.

encode_integer(Val, NamedNumberList, Tag) when is_atom(Val) ->
    case lists:keyfind(Val, 1, NamedNumberList) of
        {_, NewVal} ->
            encode_tags(Tag, encode_integer(NewVal));
        _ ->
            exit({error, {asn1, {encode_integer_namednumber, Val}}})
    end;
encode_integer(Val, _NamedNumberList, Tag) ->
    encode_tags(Tag, encode_integer(Val)).

encode_integer(Val, Tag) when is_integer(Val) ->
    encode_tags(Tag, encode_integer(Val));
encode_integer(Val, _Tag) ->
    exit({error, {asn1, {encode_integer, Val}}}).

encode_integer_neg(-1, [B1 | _T] = L) when B1 > 127 ->
    L;
encode_integer_neg(N, Acc) ->
    encode_integer_neg(N bsr 8, [N band 255 | Acc]).

encode_integer_pos(0, [B | _Acc] = L) when B < 128 ->
    L;
encode_integer_pos(N, Acc) ->
    encode_integer_pos(N bsr 8, [N band 255 | Acc]).

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_named_bit_string([H | _] = Bits, NamedBitList, TagIn)
    when is_atom(H) ->
    do_encode_named_bit_string(Bits, NamedBitList, TagIn);
encode_named_bit_string([{bit, _} | _] = Bits, NamedBitList, TagIn) ->
    do_encode_named_bit_string(Bits, NamedBitList, TagIn);
encode_named_bit_string([], _NamedBitList, TagIn) ->
    encode_unnamed_bit_string(<<>>, TagIn);
encode_named_bit_string(Bits, _NamedBitList, TagIn)
    when is_bitstring(Bits) ->
    encode_unnamed_bit_string(Bits, TagIn).

encode_null(_Val, TagIn) ->
    encode_tags(TagIn, [], 0).

encode_object_identifier(Val, TagIn) ->
    encode_tags(TagIn, e_object_identifier(Val)).

encode_open_type(Val, T) when is_list(Val) ->
    encode_open_type(list_to_binary(Val), T);
encode_open_type(Val, Tag) ->
    encode_tags(Tag, Val, byte_size(Val)).

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags(TagIn, {BytesSoFar, LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

encode_unnamed_bit_string(Bits, TagIn) ->
    Unused = (8 - bit_size(Bits) band 7) band 7,
    Bin = <<Unused,Bits/bitstring,0:Unused>>,
    encode_tags(TagIn, Bin, byte_size(Bin)).

get_all_bitposes([{bit, ValPos} | Rest], NamedBitList, Ack) ->
    get_all_bitposes(Rest, NamedBitList, [ValPos | Ack]);
get_all_bitposes([Val | Rest], NamedBitList, Ack) when is_atom(Val) ->
    case lists:keyfind(Val, 1, NamedBitList) of
        {_ValName, ValPos} ->
            get_all_bitposes(Rest, NamedBitList, [ValPos | Ack]);
        _ ->
            exit({error, {asn1, {bitstring_namedbit, Val}}})
    end;
get_all_bitposes([], _NamedBitList, Ack) ->
    lists:sort(Ack).

make_and_set_list(0, [], _) ->
    [];
make_and_set_list(0, _, _) ->
    exit({error, {asn1, bitstring_sizeconstraint}});
make_and_set_list(Len, [XPos | SetPos], XPos) ->
    [1 | make_and_set_list(Len - 1, SetPos, XPos + 1)];
make_and_set_list(Len, [Pos | SetPos], XPos) ->
    [0 | make_and_set_list(Len - 1, [Pos | SetPos], XPos + 1)];
make_and_set_list(Len, [], XPos) ->
    [0 | make_and_set_list(Len - 1, [], XPos + 1)].

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).

mk_object_val(0, Ack, Len) ->
    {Ack, Len};
mk_object_val(Val, Ack, Len) ->
    mk_object_val(Val bsr 7, [Val band 127 bor 128 | Ack], Len + 1).

mk_object_val(Val) when Val =< 127 ->
    {[255 band Val], 1};
mk_object_val(Val) ->
    mk_object_val(Val bsr 7, [Val band 127], 1).

number2name(Int, NamedNumberList) ->
    case lists:keyfind(Int, 2, NamedNumberList) of
        {NamedVal, _} ->
            NamedVal;
        _ ->
            Int
    end.

unused_bitlist([], Trail, Ack) ->
    {Trail + 1, Ack};
unused_bitlist([Bit | Rest], Trail, Ack) ->
    unused_bitlist(Rest, Trail - 1, Bit bsl Trail bor Ack).
